/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.clockwork.common.entity.projectile.trigger;

import dev.xylonity.bonsai.clockwork.common.entity.projectile.trigger.GenericTriggerProjectile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PotionSprayTriggerProjectile
extends GenericTriggerProjectile {
    private List<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
    private static final String NBT_SPRAY_TICKS = "spray_ticks_left";

    public PotionSprayTriggerProjectile(EntityType<? extends Projectile> type, Level level) {
        super(type, level);
    }

    public PotionSprayTriggerProjectile(EntityType<? extends Projectile> type, Level level, ItemStack potionStack) {
        super(type, level);
        this.effects = PotionSprayTriggerProjectile.computeAdjustedEffects(potionStack);
    }

    private static List<MobEffectInstance> computeAdjustedEffects(ItemStack stack) {
        List originalEffects = PotionUtils.m_43547_((ItemStack)stack);
        ArrayList<MobEffectInstance> newEffects = new ArrayList<MobEffectInstance>(originalEffects.size());
        int effectsLeft = 0;
        if (stack.m_41782_()) {
            effectsLeft = stack.m_41783_().m_128451_(NBT_SPRAY_TICKS);
        }
        if (effectsLeft > 0) {
            int baseMax = 0;
            for (MobEffectInstance effect : originalEffects) {
                baseMax = Math.max(baseMax, effect.m_19557_());
            }
            if (baseMax > 0) {
                for (MobEffectInstance effect : originalEffects) {
                    newEffects.add(new MobEffectInstance(effect.m_19544_(), 60, effect.m_19564_(), effect.m_19571_(), effect.m_19572_(), effect.m_19575_()));
                }
                return newEffects;
            }
        }
        for (MobEffectInstance effect : originalEffects) {
            newEffects.add(new MobEffectInstance(effect.m_19544_(), 60, effect.m_19564_(), effect.m_19571_(), effect.m_19572_(), effect.m_19575_()));
        }
        return newEffects;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.effects.isEmpty()) {
            List entities = this.m_9236_().m_45976_(LivingEntity.class, new AABB(this.m_20185_() - 1.0, this.m_20186_() - 0.5, this.m_20189_() - 1.0, this.m_20185_() + 1.0, this.m_20186_() + 0.5, this.m_20189_() + 1.0));
            for (LivingEntity entity : entities) {
                for (MobEffectInstance effect : this.effects) {
                    if (entity.equals((Object)this.m_19749_()) && this.f_19797_ < 10) continue;
                    entity.m_7292_(new MobEffectInstance(effect.m_19544_(), 60, effect.m_19564_(), effect.m_19571_(), effect.m_19572_(), effect.m_19575_()));
                }
            }
        }
        Vec3 movement = this.m_20184_();
        this.m_20334_(movement.f_82479_ * 0.98, movement.f_82480_ - (double)0.015f, movement.f_82481_ * 0.98);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (!this.m_9236_().f_46443_ && this.m_20096_()) {
            this.m_146870_();
        }
    }
}

