/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.clockwork.common.item;

import dev.xylonity.bonsai.clockwork.Clockwork;
import dev.xylonity.bonsai.clockwork.client.item.renderer.ScopeCrossbowRenderer;
import dev.xylonity.bonsai.clockwork.common.entity.projectile.ClockworkArrowProjectile;
import dev.xylonity.bonsai.clockwork.registry.ClockworkItems;
import dev.xylonity.bonsai.clockwork.registry.ClockworkSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.ForgeEventFactory;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ScopeCrossbow
extends CrossbowItem
implements GeoItem {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final String NBT_LOAD_START_TICK = "bc_load_start";
    private static final String NBT_LOAD_VARIANT = "bc_load_variant";
    private static final String NBT_LOAD_PLAYED = "bc_load_played";
    private static final String NBT_SCOPING = "bc_scoping";
    private static final String NBT_SCOPE_HAND = "bc_scope_hand";
    private static final String NBT_CAN_LOAD = "bc_can_load";
    private static final RawAnimation SHOOT = RawAnimation.begin().thenPlay("shoot");
    private static final RawAnimation LOAD = RawAnimation.begin().thenPlay("load");
    private static final RawAnimation LOADED = RawAnimation.begin().thenPlay("loaded");
    private static final RawAnimation LOAD_QUICKCHARGE_1 = RawAnimation.begin().thenPlay("load_quickcharge_1");
    private static final RawAnimation LOAD_QUICKCHARGE_2 = RawAnimation.begin().thenPlay("load_quickcharge_2");
    private static final RawAnimation LOAD_QUICKCHARGE_3 = RawAnimation.begin().thenPlay("load_quickcharge_3");
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    private static final float DURATION = 1.5f;
    private static final float DURATION_QUICKCHARGE_1 = 1.29f;
    private static final float DURATION_QUICKCHARGE_2 = 1.08f;
    private static final float DURATION_QUICKCHARGE_3 = 0.88f;
    private static final RawAnimation[] LOAD_VARIANTS = new RawAnimation[]{LOAD, LOAD_QUICKCHARGE_1, LOAD_QUICKCHARGE_2, LOAD_QUICKCHARGE_3};
    private static final float[] LOAD_DURATIONS = new float[]{1.5f, 1.29f, 1.08f, 0.88f};
    private boolean cwLoadingPlayedStart = false;

    public ScopeCrossbow(Item.Properties props) {
        super(props);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public static int getQuickChargeLevel(ItemStack stack) {
        int quickCharge = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        if (quickCharge < 0) {
            return 0;
        }
        return Math.min(quickCharge, 3);
    }

    public static int getChargeDurationTicks(ItemStack stack) {
        return Math.max(1, Math.round(LOAD_DURATIONS[ScopeCrossbow.getQuickChargeLevel(stack)] * 20.0f));
    }

    private static float secondsFromVariantTicks(int variant) {
        int ticks = Math.max(1, Math.round(LOAD_DURATIONS[ScopeCrossbow.clampVariant(variant)] * 20.0f));
        return (float)ticks / 20.0f;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128471_(NBT_SCOPING) ? UseAnim.SPYGLASS : UseAnim.CROSSBOW;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private ScopeCrossbowRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new ScopeCrossbowRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "state", 1, this::statePredicate).setSoundKeyframeHandler(event -> Clockwork.PROXY.playScopeCrossbowSound())});
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "fire", 1, this::firePredicate).triggerableAnim("shoot", SHOOT)});
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!ScopeCrossbow.m_40932_((ItemStack)stack)) {
            if (!ScopeCrossbow.hasLoadableAmmo((LivingEntity)player, stack)) {
                stack.m_41784_().m_128379_(NBT_CAN_LOAD, false);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            ScopeCrossbow.markLoadStart(stack, level.m_46467_(), ScopeCrossbow.getQuickChargeLevel(stack));
            this.cwLoadingPlayedStart = false;
            stack.m_41784_().m_128379_(NBT_CAN_LOAD, true);
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_(NBT_SCOPING, true);
        tag.m_128344_(NBT_SCOPE_HAND, (byte)(hand != InteractionHand.MAIN_HAND ? 1 : 0));
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity user, int timeLeft) {
        int chargeTicks;
        boolean scoping = stack.m_41782_() && stack.m_41783_().m_128471_(NBT_SCOPING);
        boolean charged = ScopeCrossbow.m_40932_((ItemStack)stack);
        if (!level.f_46443_ && scoping && charged) {
            this.triggerFire(stack, user);
            ScopeCrossbow.performShootingCW(level, user, stack.m_41782_() && stack.m_41783_().m_128445_(NBT_SCOPE_HAND) == 1 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND, stack, ScopeCrossbow.customContainsChargedProjectile(stack, Items.f_42688_) ? 2.5f : 3.15f, 0.0f);
            ScopeCrossbow.m_40884_((ItemStack)stack, (boolean)false);
            ScopeCrossbow.clearScoping(stack);
            ScopeCrossbow.clearLoadFlags(stack);
            stack.m_41784_().m_128379_(NBT_CAN_LOAD, false);
            return;
        }
        int used = this.m_8105_(stack) - timeLeft;
        if (used >= (chargeTicks = ScopeCrossbow.getChargeDurationTicks(stack)) && !ScopeCrossbow.m_40932_((ItemStack)stack) && ScopeCrossbow.m_40859_(user, stack)) {
            ScopeCrossbow.m_40884_((ItemStack)stack, (boolean)true);
        }
        ScopeCrossbow.clearScoping(stack);
        ScopeCrossbow.clearLoadFlags(stack);
        stack.m_41784_().m_128379_(NBT_CAN_LOAD, false);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int count) {
        if (level.f_46443_) {
            return;
        }
        if (!ScopeCrossbow.m_40932_((ItemStack)stack) && !ScopeCrossbow.hasLoadableAmmo(entity, stack)) {
            entity.m_5810_();
            ScopeCrossbow.clearLoadFlags(stack);
            stack.m_41784_().m_128379_(NBT_CAN_LOAD, false);
            this.cwLoadingPlayedStart = false;
            return;
        }
        int chargeTicks = ScopeCrossbow.getChargeDurationTicks(stack);
        int usedTicks = stack.m_41779_() - count;
        float progress = (float)usedTicks / (float)chargeTicks;
        if (progress < 0.2f) {
            this.cwLoadingPlayedStart = false;
        }
        if (progress >= 0.2f && !this.cwLoadingPlayedStart) {
            this.cwLoadingPlayedStart = true;
            level.m_5594_(null, entity.m_20183_(), (SoundEvent)ClockworkSounds.CLOCKWORK_SCOPE_CROSSBOW_LOADING.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
        }
    }

    public Predicate<ItemStack> m_6437_() {
        return s -> s.m_41720_() instanceof ArrowItem;
    }

    private <T extends GeoAnimatable> PlayState statePredicate(AnimationState<T> event) {
        boolean canLoad;
        LivingEntity entity;
        LivingEntity le;
        ItemStack stack = (ItemStack)event.getData(DataTickets.ITEMSTACK);
        if (stack == null || stack.m_41619_()) {
            return PlayState.STOP;
        }
        Entity e = (Entity)event.getData(DataTickets.ENTITY);
        Object object = e instanceof LivingEntity ? (le = (LivingEntity)e) : (entity = Clockwork.PROXY.getClientPlayer() != null ? Clockwork.PROXY.getClientPlayer() : null);
        if (entity == null) {
            return PlayState.STOP;
        }
        boolean charged = ScopeCrossbow.m_40932_((ItemStack)stack);
        CompoundTag tag = stack.m_41784_();
        long start = tag.m_128454_(NBT_LOAD_START_TICK);
        int variant = ScopeCrossbow.clampVariant(tag.m_128451_(NBT_LOAD_VARIANT));
        boolean played = tag.m_128471_(NBT_LOAD_PLAYED);
        boolean canLoadNBT = tag.m_128471_(NBT_CAN_LOAD);
        boolean hasAmmoNow = ScopeCrossbow.hasLoadableAmmo(entity, stack);
        boolean bl = canLoad = canLoadNBT || hasAmmoNow;
        if (charged) {
            event.setAnimation(LOADED);
            if (start > 0L) {
                ScopeCrossbow.clearLoadFlags(stack);
            }
            return PlayState.CONTINUE;
        }
        if (canLoad && (!charged && entity.m_6117_() && entity.m_21211_() != null && entity.m_21211_().m_41720_() == stack.m_41720_() || start > 0L && !charged)) {
            if (!played) {
                event.getController().setAnimationSpeed((double)(1.0f / Math.max(0.001f, ScopeCrossbow.secondsFromVariantTicks(variant))));
                event.setAndContinue(LOAD_VARIANTS[variant]);
                tag.m_128379_(NBT_LOAD_PLAYED, true);
            }
            return PlayState.CONTINUE;
        }
        event.getController().setAnimationSpeed(1.0);
        event.setAndContinue(IDLE);
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState firePredicate(AnimationState<T> e) {
        e.getController().setAnimationSpeed(1.0);
        return PlayState.CONTINUE;
    }

    private void triggerFire(ItemStack stack, LivingEntity user) {
        if (user.m_9236_() instanceof ServerLevel) {
            this.triggerAnim((Entity)user, GeoItem.getId((ItemStack)stack), "fire", "shoot");
        }
    }

    private static void markLoadStart(ItemStack stack, long tick, int variant) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128356_(NBT_LOAD_START_TICK, tick);
        tag.m_128405_(NBT_LOAD_VARIANT, ScopeCrossbow.clampVariant(variant));
        tag.m_128379_(NBT_LOAD_PLAYED, false);
    }

    private static void clearLoadFlags(ItemStack stack) {
        if (!stack.m_41782_()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128473_(NBT_LOAD_START_TICK);
        tag.m_128473_(NBT_LOAD_VARIANT);
        tag.m_128473_(NBT_LOAD_PLAYED);
    }

    private static void clearScoping(ItemStack stack) {
        if (!stack.m_41782_()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128473_(NBT_SCOPING);
        tag.m_128473_(NBT_SCOPE_HAND);
    }

    private static int clampVariant(int v) {
        return v < 0 ? 0 : Math.min(v, 3);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private static boolean hasLoadableAmmo(LivingEntity user, ItemStack crossbowStack) {
        ItemStack ammo;
        if (user instanceof Player) {
            Player p = (Player)user;
            if (p.m_150110_().f_35937_) {
                return true;
            }
        }
        return !(ammo = user.m_6298_(crossbowStack)).m_41619_() && ammo.m_41720_() instanceof ArrowItem;
    }

    private static boolean m_40859_(LivingEntity shooter, ItemStack crossbowStack) {
        int multishot = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)crossbowStack);
        int shots = multishot == 0 ? 1 : 3;
        boolean creative = shooter instanceof Player && ((Player)shooter).m_150110_().f_35937_;
        ItemStack ammo = shooter.m_6298_(crossbowStack);
        ItemStack ammoCopy = ammo.m_41777_();
        for (int k = 0; k < shots; ++k) {
            if (k > 0) {
                ammo = ammoCopy.m_41777_();
            }
            if (ammo.m_41619_() && creative) {
                ammo = new ItemStack((ItemLike)Items.f_42412_);
                ammoCopy = ammo.m_41777_();
            }
            if (ScopeCrossbow.m_40862_(shooter, crossbowStack, ammo, k > 0, creative)) continue;
            return false;
        }
        return true;
    }

    private static boolean m_40862_(LivingEntity shooter, ItemStack crossbowStack, ItemStack ammo, boolean hasAmmo, boolean creative) {
        ItemStack toAdd;
        boolean flag;
        if (ammo.m_41619_()) {
            return false;
        }
        boolean bl = flag = creative && ammo.m_41720_() instanceof ArrowItem;
        if (!(flag || creative || hasAmmo)) {
            toAdd = ammo.m_41620_(1);
            if (ammo.m_41619_() && shooter instanceof Player) {
                Player p = (Player)shooter;
                p.m_150109_().m_36057_(ammo);
            }
        } else {
            toAdd = ammo.m_41777_();
        }
        ScopeCrossbow.m_40928_(crossbowStack, toAdd);
        return true;
    }

    private static void m_40928_(ItemStack crossbowStack, ItemStack ammoStack) {
        CompoundTag tag = crossbowStack.m_41784_();
        ListTag list = tag.m_128425_("ChargedProjectiles", 9) ? tag.m_128437_("ChargedProjectiles", 10) : new ListTag();
        CompoundTag entry = new CompoundTag();
        ammoStack.m_41739_(entry);
        list.add((Object)entry);
        tag.m_128365_("ChargedProjectiles", (Tag)list);
    }

    private static List<ItemStack> m_40941_(ItemStack crossbowStack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        CompoundTag tag = crossbowStack.m_41783_();
        if (tag != null && tag.m_128425_("ChargedProjectiles", 9)) {
            ListTag listtag = tag.m_128437_("ChargedProjectiles", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                list.add(ItemStack.m_41712_((CompoundTag)listtag.m_128728_(i)));
            }
        }
        return list;
    }

    private static void m_40943_(ItemStack crossbowStack) {
        CompoundTag tag = crossbowStack.m_41783_();
        if (tag != null) {
            ListTag list = tag.m_128437_("ChargedProjectiles", 9);
            list.clear();
            tag.m_128365_("ChargedProjectiles", (Tag)list);
        }
    }

    private static boolean customContainsChargedProjectile(ItemStack crossbowStack, Item item) {
        return ScopeCrossbow.m_40941_(crossbowStack).stream().anyMatch(s -> s.m_150930_(item));
    }

    private static void performShootingCW(Level level, LivingEntity shooter, InteractionHand usedHand, ItemStack crossbowStack, float velocity, float inaccuracy) {
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            if (ForgeEventFactory.onArrowLoose((ItemStack)crossbowStack, (Level)shooter.m_9236_(), (Player)player, (int)1, (boolean)true) < 0) {
                return;
            }
        }
        List<ItemStack> list = ScopeCrossbow.m_40941_(crossbowStack);
        float[] pitches = ScopeCrossbow.m_220023_(shooter.m_217043_());
        for (int i = 0; i < list.size(); ++i) {
            boolean creative;
            ItemStack ammo = list.get(i);
            boolean bl = creative = shooter instanceof Player && ((Player)shooter).m_150110_().f_35937_;
            if (ammo.m_41619_()) continue;
            if (i == 0) {
                ScopeCrossbow.shootProjectileCW(level, shooter, usedHand, crossbowStack, ammo, pitches[i], creative, velocity * 1.45f, inaccuracy, 0.0f);
                continue;
            }
            if (i == 1) {
                ScopeCrossbow.shootProjectileCW(level, shooter, usedHand, crossbowStack, ammo, pitches[i], creative, velocity * 1.45f, inaccuracy, -10.0f);
                continue;
            }
            if (i != 2) continue;
            ScopeCrossbow.shootProjectileCW(level, shooter, usedHand, crossbowStack, ammo, pitches[i], creative, velocity * 1.45f, inaccuracy, 10.0f);
        }
        ScopeCrossbow.onCrossbowShotCW(level, shooter, crossbowStack);
    }

    private static void shootProjectileCW(Level level, LivingEntity shooter, InteractionHand hand, ItemStack crossbowStack, ItemStack ammoStack, float soundPitch, boolean creativeOnlyPickup, float velocity, float inaccuracy, float angleDeg) {
        FireworkRocketEntity proj;
        if (level.f_46443_) {
            return;
        }
        if (ammoStack.m_150930_(Items.f_42688_)) {
            proj = new FireworkRocketEntity(level, ammoStack, (Entity)shooter, shooter.m_20185_(), shooter.m_20188_() - 0.15000000596, shooter.m_20189_(), true);
        } else {
            ArrowItem arrowItem = (ArrowItem)(ammoStack.m_41720_() instanceof ArrowItem ? ammoStack.m_41720_() : Items.f_42412_);
            AbstractArrow arrow = arrowItem.m_6394_(level, ammoStack, shooter);
            if (shooter instanceof Player) {
                arrow.m_36762_(true);
            }
            arrow.m_36793_(true);
            int pierce = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)crossbowStack);
            if (pierce > 0) {
                arrow.m_36767_((byte)pierce);
            }
            if (creativeOnlyPickup || angleDeg != 0.0f) {
                arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            if (arrow instanceof ClockworkArrowProjectile) {
                ClockworkArrowProjectile cw = (ClockworkArrowProjectile)arrow;
                LivingEntity target = ScopeCrossbow.searchForwardTarget(level, shooter, 128.0);
                if (target != null) {
                    cw.setTarget(target);
                }
            }
            proj = arrow;
        }
        if (shooter instanceof CrossbowAttackMob) {
            CrossbowAttackMob mob = (CrossbowAttackMob)shooter;
            mob.m_5811_(mob.m_5448_(), crossbowStack, (Projectile)proj, angleDeg);
        } else {
            Vec3 up = shooter.m_20289_(1.0f);
            Vec3 look = shooter.m_20252_(1.0f);
            Vector3f dir = look.m_252839_().rotate((Quaternionfc)new Quaternionf().setAngleAxis((double)(angleDeg * ((float)Math.PI / 180)), up.f_82479_, up.f_82480_, up.f_82481_));
            proj.m_6686_((double)dir.x(), (double)dir.y(), (double)dir.z(), velocity, inaccuracy);
        }
        crossbowStack.m_41622_(ammoStack.m_150930_(Items.f_42688_) ? 3 : 1, shooter, b -> b.m_21190_(hand));
        level.m_7967_((Entity)proj);
        level.m_5594_(null, shooter.m_20183_(), (SoundEvent)ClockworkSounds.CLOCKWORK_CROSSBOW_SHOOT.get(), SoundSource.PLAYERS, 1.0f, soundPitch);
    }

    public static LivingEntity searchForwardTarget(Level level, LivingEntity shooter, double maxDistance) {
        List potentialTargets;
        Vec3 end;
        float searchRadius = 3.5f;
        Vec3 start = shooter.m_146892_();
        BlockHitResult blockHit = level.m_45547_(new ClipContext(start, end = start.m_82549_(shooter.m_20252_(1.0f).m_82490_(maxDistance)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)shooter));
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            end = blockHit.m_82450_();
        }
        if ((potentialTargets = level.m_6443_(LivingEntity.class, new AABB(start, end).m_82400_((double)searchRadius), entity -> {
            if (!entity.m_6084_()) return false;
            if (entity == shooter) return false;
            if (!entity.m_6087_()) return false;
            if (entity.m_5833_()) return false;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.m_150110_().f_35934_) return false;
                if (player.m_7500_()) return false;
            }
            if (entity.m_7307_((Entity)shooter)) return false;
            return true;
        })).isEmpty()) {
            return null;
        }
        Vec3 trajectoryVector = end.m_82546_(start);
        double tLengthSqr = trajectoryVector.m_82556_();
        LivingEntity closestTarget = null;
        double closestDistanceSquared = Double.MAX_VALUE;
        double closestProjectionDistance = Double.MAX_VALUE;
        for (LivingEntity target : potentialTargets) {
            double factor;
            Vec3 closestPoint;
            Vec3 targetCenter = target.m_20191_().m_82399_();
            double distanceSquared = targetCenter.m_82557_(closestPoint = start.m_82549_(trajectoryVector.m_82490_(factor = tLengthSqr <= 1.0E-9 ? 0.0 : Mth.m_14008_((double)(targetCenter.m_82546_(start).m_82526_(trajectoryVector) / tLengthSqr), (double)0.0, (double)1.0))));
            if (distanceSquared > (double)(searchRadius * searchRadius)) continue;
            double pDistanceSquared = start.m_82557_(closestPoint);
            if (!(distanceSquared < closestDistanceSquared) && (!(Math.abs(distanceSquared - closestDistanceSquared) < 1.0E-9) || !(pDistanceSquared < closestProjectionDistance))) continue;
            closestDistanceSquared = distanceSquared;
            closestProjectionDistance = pDistanceSquared;
            closestTarget = target;
        }
        return closestTarget;
    }

    private static void onCrossbowShotCW(Level level, LivingEntity entity, ItemStack crossbowStack) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (!level.f_46443_) {
                CriteriaTriggers.f_10555_.m_65462_(player, crossbowStack);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)crossbowStack.m_41720_()));
        }
        ScopeCrossbow.m_40943_(crossbowStack);
    }

    private static float[] m_220023_(RandomSource random) {
        boolean flag = random.m_188499_();
        return new float[]{1.0f, ScopeCrossbow.m_220025_(flag, random), ScopeCrossbow.m_220025_(!flag, random)};
    }

    private static float m_220025_(boolean high, RandomSource random) {
        float f = high ? 0.63f : 0.43f;
        return 1.0f / (random.m_188501_() * 0.5f + 1.8f) + f;
    }

    public boolean m_6832_(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.m_41720_() == ClockworkItems.CLOCKWORK_GEAR.get();
    }
}

