/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.clockwork.mixin;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={PotionItem.class})
public abstract class PotionItemMixin {
    @Redirect(method={"finishUsingItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/ItemStack;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/alchemy/PotionUtils;getMobEffects(Lnet/minecraft/world/item/ItemStack;)Ljava/util/List;"))
    private List<MobEffectInstance> clockwork$applyRemainingDuration(ItemStack stack) {
        List originalEffects = PotionUtils.m_43547_((ItemStack)stack);
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_("spray_ticks_left")) {
            return originalEffects;
        }
        int leftTicks = Math.max(0, stack.m_41783_().m_128451_("spray_ticks_left"));
        if (leftTicks <= 0) {
            return List.of();
        }
        int baseMax = 0;
        for (MobEffectInstance effect : originalEffects) {
            baseMax = Math.max(baseMax, effect.m_19557_());
        }
        if (baseMax <= 0) {
            return originalEffects;
        }
        ArrayList<MobEffectInstance> adjustedEffects = new ArrayList<MobEffectInstance>(originalEffects.size());
        for (MobEffectInstance effect : originalEffects) {
            int newDuration = (int)Math.floor((double)effect.m_19557_() * Math.min(1.0, (double)leftTicks / (double)baseMax));
            if (newDuration <= 0) continue;
            adjustedEffects.add(new MobEffectInstance(effect.m_19544_(), newDuration, effect.m_19564_(), effect.m_19571_(), effect.m_19572_(), effect.m_19575_()));
        }
        return adjustedEffects;
    }
}

