/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.clockwork.client.event;

import com.mojang.blaze3d.platform.InputConstants;
import dev.xylonity.bonsai.clockwork.client.entity.renderer.DragonflyRenderer;
import dev.xylonity.bonsai.clockwork.client.particle.PotionSprayParticle;
import dev.xylonity.bonsai.clockwork.client.projectile.renderer.ClockworkArrowProjectileRenderer;
import dev.xylonity.bonsai.clockwork.client.projectile.renderer.GenericProjectileRenderer;
import dev.xylonity.bonsai.clockwork.common.item.BarrelCrossbow;
import dev.xylonity.bonsai.clockwork.common.item.ScopeCrossbow;
import dev.xylonity.bonsai.clockwork.common.sound.ClientSoundProxy;
import dev.xylonity.bonsai.clockwork.common.sound.Sounds;
import dev.xylonity.bonsai.clockwork.network.packets.ClockworkWingsC2SPacket;
import dev.xylonity.bonsai.clockwork.network.packets.DragonflyAscendKeyC2SPacket;
import dev.xylonity.bonsai.clockwork.network.packets.PotionSprayerParticlesC2SPacket;
import dev.xylonity.bonsai.clockwork.registry.ClockworkEntities;
import dev.xylonity.bonsai.clockwork.registry.ClockworkItems;
import dev.xylonity.bonsai.clockwork.registry.ClockworkParticles;
import dev.xylonity.knightlib.api.network.Network;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClockworkClientEvents {

    @Mod.EventBusSubscriber(modid="clockwork", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ClockworkClientGameEvents {
        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            if (Minecraft.m_91087_().f_91074_ != null && event.getKey() == 32 && event.getAction() == 1) {
                if (Minecraft.m_91087_().f_91080_ instanceof ChatScreen) {
                    return;
                }
                Network.sendToServer((Object)new ClockworkWingsC2SPacket());
            }
        }

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent e) {
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)32)) {
                if (Minecraft.m_91087_().f_91080_ instanceof ChatScreen) {
                    return;
                }
                Network.sendToServer((Object)new DragonflyAscendKeyC2SPacket(true));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="clockwork", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClockworkClientModEvents {
        @SubscribeEvent
        public static void registerEntityRenderers(FMLClientSetupEvent event) {
            EntityRenderers.m_174036_((EntityType)((EntityType)ClockworkEntities.DRAGONFLY.get()), DragonflyRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ClockworkEntities.CLOCKWORK_WINGS_BOOST_PROJECTILE.get()), GenericProjectileRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ClockworkEntities.POTION_SPRAY_TRIGGER_PROJECTILE.get()), GenericProjectileRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ClockworkEntities.CLOCKWORK_ARROW_PROJECTILE.get()), ClockworkArrowProjectileRenderer::new);
            ItemProperties.register((Item)((Item)ClockworkItems.BARREL_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pull"), (itemStack, clientLevel, livingEntity, i) -> {
                if (livingEntity == null) {
                    return 0.0f;
                }
                if (CrossbowItem.m_40932_((ItemStack)itemStack)) {
                    return 0.0f;
                }
                int useDur = itemStack.m_41779_();
                int rem = livingEntity.m_21212_();
                int charge = BarrelCrossbow.getChargeDurationTicks(itemStack);
                return (float)(useDur - rem) / (float)charge;
            });
            ItemProperties.register((Item)((Item)ClockworkItems.BARREL_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (itemStack, clientLevel, livingEntity, i) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack && !CrossbowItem.m_40932_((ItemStack)itemStack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ClockworkItems.BARREL_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("charged"), (itemStack, clientLevel, livingEntity, i) -> CrossbowItem.m_40932_((ItemStack)itemStack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ClockworkItems.BARREL_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("firework"), (itemStack, clientLevel, livingEntity, i) -> CrossbowItem.m_40932_((ItemStack)itemStack) && CrossbowItem.m_40871_((ItemStack)itemStack, (Item)Items.f_42688_) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ClockworkItems.SCOPE_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pull"), (itemStack, clientLevel, livingEntity, i) -> {
                if (livingEntity == null) {
                    return 0.0f;
                }
                if (CrossbowItem.m_40932_((ItemStack)itemStack)) {
                    return 0.0f;
                }
                int useDur = itemStack.m_41779_();
                int rem = livingEntity.m_21212_();
                int charge = ScopeCrossbow.getChargeDurationTicks(itemStack);
                return (float)(useDur - rem) / (float)charge;
            });
            ItemProperties.register((Item)((Item)ClockworkItems.SCOPE_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (itemStack, clientLevel, livingEntity, i) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack && !CrossbowItem.m_40932_((ItemStack)itemStack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ClockworkItems.SCOPE_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("charged"), (itemStack, clientLevel, livingEntity, i) -> CrossbowItem.m_40932_((ItemStack)itemStack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ClockworkItems.SCOPE_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("firework"), (itemStack, clientLevel, livingEntity, i) -> CrossbowItem.m_40932_((ItemStack)itemStack) && CrossbowItem.m_40871_((ItemStack)itemStack, (Item)Items.f_42688_) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ClockworkItems.SCOPE_CROSSBOW.get()), (ResourceLocation)new ResourceLocation("clockworkarrow"), (itemStack, clientLevel, livingEntity, i) -> CrossbowItem.m_40932_((ItemStack)itemStack) && CrossbowItem.m_40871_((ItemStack)itemStack, (Item)((Item)ClockworkItems.CLOCKWORK_ARROW.get())) ? 1.0f : 0.0f);
            Sounds.registerClientProxy(new ClientSoundProxy());
            Network.register(PotionSprayerParticlesC2SPacket.TYPE);
        }

        @SubscribeEvent
        public static void registerParticles(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)ClockworkParticles.POTION_SPRAY.get(), PotionSprayParticle.Provider::new);
        }

        @SubscribeEvent
        public static void registerKeys(RegisterKeyMappingsEvent event) {
        }
    }
}

