/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.clockwork.client.item.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xylonity.bonsai.clockwork.client.item.model.PotionSprayerModel;
import dev.xylonity.bonsai.clockwork.common.item.PotionSprayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class PotionSprayerRenderer
extends GeoItemRenderer<PotionSprayer> {
    private ItemDisplayContext lastTransform = ItemDisplayContext.NONE;
    private float fallSway = 0.0f;
    private float prevFallSway = 0.0f;
    private int lastTick = -1;

    public PotionSprayerRenderer() {
        super((GeoModel)new PotionSprayerModel());
    }

    public void renderRecursively(PoseStack poseStack, PotionSprayer animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.getName().equals("spyglass")) {
            return;
        }
        super.renderRecursively(poseStack, (Item)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext ctx, PoseStack pose, MultiBufferSource buf, int light, int overlay) {
        this.lastTransform = ctx;
        if (ctx == ItemDisplayContext.GUI || ctx == ItemDisplayContext.GROUND || ctx == ItemDisplayContext.FIXED) {
            Minecraft mc = Minecraft.m_91087_();
            ModelResourceLocation mrl = new ModelResourceLocation("clockwork", "barrel_crossbow_2d", "inventory");
            BakedModel model = mc.m_91304_().m_119422_(mrl);
            mc.m_91291_().m_115143_(stack, ctx, false, pose, buf, light, overlay, model);
            return;
        }
        super.m_108829_(stack, ctx, pose, buf, light, overlay);
    }

    public void preRender(PoseStack poseStack, PotionSprayer animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        int tick;
        super.preRender(poseStack, (Item)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (!PotionSprayerRenderer.isFirstPerson(this.lastTransform)) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        float pt = partialTick;
        boolean leftHand = this.lastTransform == ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
        int handSign = leftHand ? -1 : 1;
        poseStack.m_85837_(0.09375, -0.015625, 0.0);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(2.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-9.5f));
        if (leftHand) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(19.0f));
        }
        float bobPitch = Mth.m_14189_((float)pt, (float)player.f_108588_, (float)player.f_108586_);
        float headPitch = Mth.m_14189_((float)pt, (float)player.f_19860_, (float)player.m_146909_());
        float swayPitch = headPitch - bobPitch;
        float bobYaw = Mth.m_14189_((float)pt, (float)player.f_108587_, (float)player.f_108585_);
        float headYaw = Mth.m_14189_((float)pt, (float)player.f_20886_, (float)player.f_20885_);
        float swayYaw = headYaw - bobYaw;
        float sprintBoost = player.m_20142_() ? 1.15f : 1.0f;
        float sensitivity = 0.6f * sprintBoost;
        float rollFromYaw = swayYaw * 0.35f;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(swayYaw * sensitivity * (float)handSign));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(swayPitch * sensitivity));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rollFromYaw * sensitivity * (float)handSign));
        if (((Boolean)Minecraft.m_91087_().f_91066_.m_231830_().m_231551_()).booleanValue()) {
            float deltaWalk = player.f_19787_ - player.f_19867_;
            float walk = -(player.f_19787_ + deltaWalk * pt);
            float bob = Mth.m_14179_((float)pt, (float)player.f_36099_, (float)player.f_36100_);
            float bobScale = player.m_20142_() ? 0.9f : 0.5f;
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-(Math.abs(Mth.m_14089_((float)(walk * (float)Math.PI - 0.2f)) * bob) * 3.5f) * bobScale));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(-(Mth.m_14031_((float)(walk * (float)Math.PI)) * bob * 2.0f) * bobScale * (float)handSign));
            poseStack.m_85837_((double)(-(Mth.m_14031_((float)(walk * (float)Math.PI)) * bob * 0.15f) * (float)handSign), (double)(-(-Math.abs(Mth.m_14089_((float)(walk * (float)Math.PI)) * bob)) * 0.12f), 0.0);
        }
        if ((tick = player.f_19797_) != this.lastTick) {
            this.lastTick = tick;
            this.prevFallSway = this.fallSway;
            float deltaY = (float)Mth.m_14008_((double)(player.f_19855_ - player.m_20186_()), (double)-1.0, (double)1.0);
            float pitchNow = Mth.m_14189_((float)1.0f, (float)player.f_19860_, (float)player.m_146909_());
            float pitchFactor = 1.0f - Math.abs(pitchNow) / 90.0f * 0.5f;
            float sensitivityDeg = player.m_20142_() ? 60.0f : 45.0f;
            float target = deltaY * sensitivityDeg * pitchFactor;
            if (Math.abs(target) < 0.15f) {
                target = 0.0f;
            }
            float approachPerTick = player.m_20096_() ? 6.0f : 10.0f;
            this.fallSway = Mth.m_14121_((float)this.fallSway, (float)target, (float)approachPerTick);
        }
        float fallTilt = Mth.m_14179_((float)pt, (float)this.prevFallSway, (float)this.fallSway);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(fallTilt));
    }

    private static boolean isFirstPerson(ItemDisplayContext ctx) {
        return ctx == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || ctx == ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
    }
}

