/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.clockwork.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PotionSprayParticle
extends TextureSheetParticle {
    private final SpriteSet spritesset;
    private int frameIndex = 0;
    private boolean landed = false;
    private int landedFrameTick = 0;
    private int airFrameTick = 0;
    private static final int AIR_FRAME_DURATION_TICKS = 3;
    private static final int GROUND_FRAME_DURATION_TICKS = 3;
    private static final int MAX_FRAME_INDEX = 7;
    private static double defaultVelocityX = 0.0;
    private static double defaultVelocityY = 0.0;
    private static double defaultVelocityZ = 0.0;
    private static int rgb;

    public static void setDefaultVelocityAndColor(double vx, double vy, double vz, int color) {
        defaultVelocityX = vx;
        defaultVelocityY = vy;
        defaultVelocityZ = vz;
        rgb = color;
    }

    public PotionSprayParticle(ClientLevel world, double x, double y, double z, SpriteSet sprites, double velX, double velY, double velZ) {
        super(world, x, y, z);
        this.spritesset = sprites;
        this.f_107663_ = new Random().nextFloat(0.25f, 0.8f);
        this.f_107230_ = 0.0f;
        int color = rgb;
        this.f_107227_ = (float)(color >> 16 & 0xFF) / 255.0f;
        this.f_107228_ = (float)(color >> 8 & 0xFF) / 255.0f;
        this.f_107229_ = (float)(color & 0xFF) / 255.0f;
        this.f_107226_ = 0.55f;
        this.f_107219_ = true;
        this.f_172258_ = 0.98f;
        this.f_107225_ = 600;
        if (velX == 0.0 && velY == 0.0 && velZ == 0.0) {
            this.f_107215_ = defaultVelocityX;
            this.f_107216_ = defaultVelocityY;
            this.f_107217_ = defaultVelocityZ;
        } else {
            this.f_107215_ = velX;
            this.f_107216_ = velY;
            this.f_107217_ = velZ;
        }
        this.setFrame(0);
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5744_(@NotNull VertexConsumer buffer, @NotNull Camera camera, float partialTicks) {
        super.m_5744_(buffer, camera, partialTicks);
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107230_ = this.f_107224_ < 4 ? (float)this.f_107224_ / 5.0f : 1.0f;
        if (!this.landed) {
            if (this.frameIndex < 3) {
                ++this.airFrameTick;
                if (this.airFrameTick >= 3) {
                    this.setFrame(this.frameIndex + 1);
                    this.airFrameTick = 0;
                }
            }
            if (this.f_107218_) {
                this.landed = true;
                this.landedFrameTick = 0;
                this.setFrame(4);
            }
        } else {
            ++this.landedFrameTick;
            if (this.frameIndex < 7) {
                if (this.landedFrameTick >= 3) {
                    this.setFrame(this.frameIndex + 1);
                    this.landedFrameTick = 0;
                }
            } else if (this.landedFrameTick >= 3) {
                this.m_107274_();
                return;
            }
            this.f_107215_ *= 0.85;
            this.f_107217_ *= 0.85;
            this.f_107216_ *= 0.5;
        }
        this.f_107215_ *= 0.98;
        this.f_107216_ *= 0.98;
        this.f_107217_ *= 0.98;
    }

    private void setFrame(int index) {
        this.frameIndex = PotionSprayParticle.clamp(index, 0, 7);
        this.m_108337_(this.spritesset.m_5819_(this.frameIndex, 8));
    }

    private static int clamp(int v, int lo, int hi) {
        return v < lo ? lo : Math.min(v, hi);
    }

    public static Vec3 randomVectorInCone(Vec3 base, double alphaDeg) {
        Vec3 baseNorm = base.m_82556_() > 1.0E-12 ? base.m_82541_() : new Vec3(0.0, 1.0, 0.0);
        Vec3 u = baseNorm.m_82537_(new Vec3(0.0, 1.0, 0.0));
        if (u.m_82556_() < 1.0E-6) {
            u = baseNorm.m_82537_(new Vec3(1.0, 0.0, 0.0));
        }
        u = u.m_82541_();
        Vec3 v = baseNorm.m_82537_(u).m_82541_();
        double alpha = Math.toRadians(alphaDeg);
        double minCos = Math.cos(alpha);
        Random r = new Random();
        double cos = minCos + r.nextDouble() * (1.0 - minCos);
        double sin = Math.sqrt(1.0 - cos * cos);
        double phi = r.nextDouble() * 2.0 * Math.PI;
        Vec3 dir = baseNorm.m_82490_(cos).m_82549_(u.m_82490_(sin * Math.cos(phi))).m_82549_(v.m_82490_(sin * Math.sin(phi)));
        return dir.m_82490_(base.m_82553_());
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            if (dx == 0.0 && dy == 0.0 && dz == 0.0) {
                Vec3 b = new Vec3(defaultVelocityX, defaultVelocityY, defaultVelocityZ);
                Vec3 v = PotionSprayParticle.randomVectorInCone(b, 45.0);
                double f = 0.8 + new Random().nextDouble() * 0.4;
                dx = v.f_82479_ * f;
                dy = v.f_82480_ * f;
                dz = v.f_82481_ * f;
            }
            PotionSprayParticle p = new PotionSprayParticle(level, x, y, z, this.sprites, dx, dy, dz);
            p.m_107264_(x, y, z);
            return p;
        }
    }
}

