/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.clockwork.common.entity.projectile;

import dev.xylonity.bonsai.clockwork.registry.ClockworkEntities;
import dev.xylonity.bonsai.clockwork.registry.ClockworkItems;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ClockworkArrowProjectile
extends AbstractArrow
implements GeoEntity {
    private static final EntityDataAccessor<Optional<UUID>> TARGET_UUID = SynchedEntityData.m_135353_(ClockworkArrowProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final double H_RANGE_XZ = 3.0;
    private static final double H_RANGE_Y = 3.0;
    private static final double HOMING_STRENGTH = 0.1;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation IDLE_OFF = RawAnimation.begin().thenPlay("idle_off");
    private boolean hasPlayedIdleOff = false;
    private LivingEntity cachedTarget;

    public ClockworkArrowProjectile(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public ClockworkArrowProjectile(Level level, LivingEntity shooter) {
        super((EntityType)ClockworkEntities.CLOCKWORK_ARROW_PROJECTILE.get(), shooter, level);
    }

    private static EntityType<? extends AbstractArrow> entityType() {
        throw new IllegalStateException("Use el ctor (EntityType, Level) en el registro");
    }

    public void setTarget(@Nullable LivingEntity target) {
        this.cachedTarget = target;
        if (target != null) {
            this.f_19804_.m_135381_(TARGET_UUID, Optional.of(target.m_20148_()));
        } else {
            this.f_19804_.m_135381_(TARGET_UUID, Optional.empty());
        }
    }

    @Nullable
    public LivingEntity getTarget() {
        LivingEntity le;
        ServerLevel sl;
        Entity e;
        Level level;
        if (this.cachedTarget != null && this.cachedTarget.m_6084_()) {
            return this.cachedTarget;
        }
        Optional opt = (Optional)this.f_19804_.m_135370_(TARGET_UUID);
        if (opt.isPresent() && (level = this.m_9236_()) instanceof ServerLevel && (e = (sl = (ServerLevel)level).m_8791_((UUID)opt.get())) instanceof LivingEntity && (le = (LivingEntity)e).m_6084_()) {
            this.cachedTarget = le;
            return le;
        }
        return null;
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_ && !this.f_36703_) {
            Vec3 v;
            double speed;
            LivingEntity target = this.getTarget();
            if (!(target != null && this.isValidEnemy(target) || (target = this.findNearestEnemy()) == null)) {
                this.setTarget(target);
            }
            if (target != null && (speed = (v = this.m_20184_()).m_82553_()) > 1.0E-4) {
                Vec3 toTarget = target.m_146892_().m_82546_(this.m_20182_()).m_82541_();
                Vec3 newDir = v.m_82541_().m_165921_(toTarget, 0.1).m_82541_();
                this.m_20256_(newDir.m_82490_(speed));
                this.f_19812_ = true;
            }
        }
        super.m_8119_();
    }

    private boolean isValidEnemy(LivingEntity candidate) {
        Entity owner;
        if (!candidate.m_6084_() || candidate.m_213877_()) {
            return false;
        }
        if (candidate.m_5833_()) {
            return false;
        }
        if (candidate instanceof Player) {
            Player p = (Player)candidate;
            if (p.m_150110_().f_35934_ || p.m_7500_()) {
                return false;
            }
        }
        if ((owner = this.m_19749_()) instanceof LivingEntity) {
            LivingEntity lo = (LivingEntity)owner;
            if (candidate == lo) {
                return false;
            }
            if (candidate.m_7307_((Entity)lo)) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private LivingEntity findNearestEnemy() {
        AABB box = this.m_20191_().m_82377_(3.0, 3.0, 3.0);
        List list = this.m_9236_().m_6443_(LivingEntity.class, box, this::isValidEnemy);
        if (list.isEmpty()) {
            return null;
        }
        list.sort(Comparator.comparingDouble(e -> e.m_20280_((Entity)this)));
        return (LivingEntity)list.get(0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_UUID, Optional.empty());
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        ((Optional)this.f_19804_.m_135370_(TARGET_UUID)).ifPresent(uuid -> tag.m_128362_("Target", uuid));
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_("Target")) {
            this.f_19804_.m_135381_(TARGET_UUID, Optional.of(tag.m_128342_("Target")));
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.f_36703_) {
            if (!this.hasPlayedIdleOff) {
                event.setAndContinue(this.IDLE_OFF);
                this.hasPlayedIdleOff = true;
            }
            return PlayState.CONTINUE;
        }
        this.hasPlayedIdleOff = false;
        event.setAnimation(this.IDLE);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ClockworkItems.CLOCKWORK_ARROW.get());
    }
}

