/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.clockwork.common.entity.projectile.trigger;

import dev.xylonity.bonsai.clockwork.common.entity.projectile.trigger.GenericTriggerProjectile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PotionSprayTriggerProjectile
extends GenericTriggerProjectile {
    private List<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
    private static final String NBT_SPRAY_TICKS = "spray_ticks_left";

    public PotionSprayTriggerProjectile(EntityType<? extends Projectile> type, Level level) {
        super(type, level);
    }

    public PotionSprayTriggerProjectile(EntityType<? extends Projectile> type, Level level, ItemStack potionStack) {
        super(type, level);
        this.effects = PotionSprayTriggerProjectile.computeAdjustedEffects(potionStack);
    }

    private static List<MobEffectInstance> computeAdjustedEffects(ItemStack stack) {
        List original = PotionUtils.m_43547_((ItemStack)stack);
        ArrayList<MobEffectInstance> out = new ArrayList<MobEffectInstance>(original.size());
        int left = 0;
        if (stack.m_41782_()) {
            left = stack.m_41783_().m_128451_(NBT_SPRAY_TICKS);
        }
        if (left > 0) {
            int baseMax = 0;
            for (MobEffectInstance e : original) {
                baseMax = Math.max(baseMax, e.m_19557_());
            }
            if (baseMax > 0) {
                for (MobEffectInstance e : original) {
                    out.add(new MobEffectInstance(e.m_19544_(), 60, e.m_19564_(), e.m_19571_(), e.m_19572_(), e.m_19575_()));
                }
                return out;
            }
        }
        for (MobEffectInstance e : original) {
            out.add(new MobEffectInstance(e.m_19544_(), 60, e.m_19564_(), e.m_19571_(), e.m_19572_(), e.m_19575_()));
        }
        return out;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.effects.isEmpty()) {
            AABB box = new AABB(this.m_20185_() - 1.0, this.m_20186_() - 0.5, this.m_20189_() - 1.0, this.m_20185_() + 1.0, this.m_20186_() + 0.5, this.m_20189_() + 1.0);
            List entities = this.m_9236_().m_45976_(LivingEntity.class, box);
            for (LivingEntity le : entities) {
                for (MobEffectInstance eff : this.effects) {
                    boolean ok = le.equals((Object)this.m_19749_()) && this.f_19797_ < 10;
                    if (ok) continue;
                    le.m_7292_(new MobEffectInstance(eff.m_19544_(), 60, eff.m_19564_(), eff.m_19571_(), eff.m_19572_(), eff.m_19575_()));
                }
            }
        }
        Vec3 m = this.m_20184_();
        this.m_20334_(m.f_82479_ * 0.98, m.f_82480_ - (double)0.015f, m.f_82481_ * 0.98);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (!this.m_9236_().f_46443_ && this.m_20096_()) {
            this.m_146870_();
        }
    }
}

