/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.clockwork.common.event;

import dev.xylonity.bonsai.clockwork.common.entity.custom.DragonflyEntity;
import dev.xylonity.bonsai.clockwork.common.item.ClockworkWings;
import dev.xylonity.bonsai.clockwork.config.ClockworkConfig;
import dev.xylonity.bonsai.clockwork.network.packets.ClockworkWingsC2SPacket;
import dev.xylonity.bonsai.clockwork.network.packets.DragonflyAscendKeyC2SPacket;
import dev.xylonity.bonsai.clockwork.network.packets.GenericSoundC2SPacket;
import dev.xylonity.bonsai.clockwork.network.packets.PotionSprayerParticlesC2SPacket;
import dev.xylonity.bonsai.clockwork.registry.ClockworkEntities;
import dev.xylonity.knightlib.api.network.Network;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class ClockworkServerEvents {

    @Mod.EventBusSubscriber(modid="clockwork", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ClockworkServerGameBus {
        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                Player player = event.player;
                if (!player.m_21255_()) {
                    return;
                }
                if (!(player.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ClockworkWings)) {
                    return;
                }
                Vec3 deltaMovement = player.m_20184_();
                deltaMovement = new Vec3(deltaMovement.f_82479_ * ClockworkConfig.CLOCKWORK_WINGS_DEFAULT_VELOCITY, deltaMovement.f_82480_, deltaMovement.f_82481_ * ClockworkConfig.CLOCKWORK_WINGS_DEFAULT_VELOCITY);
                if (deltaMovement.f_82480_ < 0.0) {
                    deltaMovement = deltaMovement.m_82520_(0.0, -ClockworkConfig.CLOCKWORK_WINGS_DEFAULT_SINK, 0.0);
                }
                player.m_20256_(deltaMovement);
                player.f_19812_ = true;
            }
        }
    }

    @Mod.EventBusSubscriber(modid="clockwork", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClockworkServerModBus {
        @SubscribeEvent
        public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
            event.put((EntityType)ClockworkEntities.DRAGONFLY.get(), DragonflyEntity.setAttributes().m_22265_());
        }

        @SubscribeEvent
        public static void commonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> {
                Network.register(ClockworkWingsC2SPacket.TYPE);
                Network.register(DragonflyAscendKeyC2SPacket.TYPE);
                Network.register(GenericSoundC2SPacket.TYPE);
                Network.register(PotionSprayerParticlesC2SPacket.TYPE);
            });
        }
    }
}

