/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.clockwork.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dev.xylonity.bonsai.clockwork.common.entity.projectile.ClockworkWingsBoostProjectile;
import dev.xylonity.bonsai.clockwork.common.item.generic.GenericGeckoArmorItem;
import dev.xylonity.bonsai.clockwork.config.ClockworkConfig;
import dev.xylonity.bonsai.clockwork.network.packets.GenericSoundC2SPacket;
import dev.xylonity.bonsai.clockwork.registry.ClockworkEntities;
import dev.xylonity.knightlib.api.network.Network;
import dev.xylonity.knightlib.common.entity.BaseProjectile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ClockworkWings
extends GenericGeckoArmorItem {
    private static final String NBT_GLIDING = "clockwork_wings_gliding";
    private static final String NBT_INIT = "clockwork_wings_init";
    private static final String NBT_FALL_ACCELERATION = "clockwork_wings_fall_acceleration";
    private static final String NBT_DIVE_ACCELERATION = "clockwork_wings_dive_acceleration";
    private static final String NBT_BOOST_UNTIL = "clockwork_wings_boost_until";
    private static final String NBT_FLAP_PULSE = "clockwork_wings_flap_pulse";
    private static final String NBT_FLAP_TICK = "clockwork_wings_flap_tick";
    private static final int FALL_ACCELERATION_MAX = 8;
    private static final int DIVE_ACCELERATION_MAX = 12;
    public static final int BOOST_COOLDOWN_TICKS = ClockworkConfig.CLOCKWORK_WINGS_BOOST_COOLDOWN_TICKS;
    private static final Map<UUID, AnimationStateData> clientAnimationCache = new HashMap<UUID, AnimationStateData>();
    private static final RawAnimation CLOSED = RawAnimation.begin().thenLoop("closed");
    private static final RawAnimation GLIDE = RawAnimation.begin().thenLoop("glide");
    private static final RawAnimation FALL = RawAnimation.begin().thenLoop("fall");
    private static final RawAnimation DIVE = RawAnimation.begin().thenLoop("dive");
    private static final RawAnimation FLAP = RawAnimation.begin().thenPlay("flap");
    private static final RawAnimation OPEN = RawAnimation.begin().thenPlay("open");
    private static final RawAnimation CLOSE = RawAnimation.begin().thenPlay("close");

    public ClockworkWings(Item.Properties properties, ArmorMaterials armorMaterial, ArmorItem.Type type, String id) {
        super((ArmorMaterial)armorMaterial, type, properties, id);
    }

    public int getMaxDamage(ItemStack stack) {
        return ClockworkConfig.CLOCKWORK_WINGS_DEFAULT_DURABILITY;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return ImmutableMultimap.of();
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return ClockworkWings.isFlyEnabled(stack);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        int next;
        if (!entity.m_9236_().f_46443_ && (next = flightTicks + 1) % 10 == 0) {
            if (next % 20 == 0 && entity instanceof Player) {
                Player player = (Player)entity;
                if (!player.m_150110_().f_35937_) {
                    stack.m_41622_(1, entity, e -> e.m_21166_(EquipmentSlot.CHEST));
                }
            }
            entity.m_146850_(GameEvent.f_223705_);
        }
        return true;
    }

    public static boolean isFlyEnabled(ItemStack stack) {
        return stack.m_41773_() < stack.m_41776_() - 1;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity player = (LivingEntity)entity;
        if (player.m_6844_(EquipmentSlot.CHEST).m_41720_() == this) {
            AnimationStateData stateData;
            if (!level.m_6443_(ClockworkWingsBoostProjectile.class, player.m_20191_().m_82400_(1.6), e -> e.m_6084_() && e.f_19797_ <= 1).isEmpty()) {
                if (!level.f_46443_) {
                    CompoundTag tag = stack.m_41784_();
                    tag.m_128356_(NBT_FLAP_TICK, level.m_46467_());
                }
                if (level.f_46443_) {
                    stateData = ClockworkWings.getOrCreateAnimationState(player.m_20148_());
                    stateData.flapPulse = true;
                }
            }
            if (level.f_46443_) {
                boolean isGlidingNow;
                long nbtFlapTick;
                stateData = ClockworkWings.getOrCreateAnimationState(player.m_20148_());
                long now = level.m_46467_();
                CompoundTag tag = stack.m_41783_();
                if (tag != null && tag.m_128441_(NBT_FLAP_TICK) && (nbtFlapTick = tag.m_128454_(NBT_FLAP_TICK)) != stateData.lastFlapTick && nbtFlapTick > 0L) {
                    stateData.lastFlapTick = nbtFlapTick;
                    stateData.flapPulse = true;
                }
                boolean bl = isGlidingNow = player.m_21255_() && ClockworkWings.isFlyEnabled(stack);
                if (isGlidingNow && !stateData.lastIsGliding) {
                    if (now - stateData.lastSoundTick >= 2L) {
                        Network.sendToServer((Object)new GenericSoundC2SPacket(1));
                        stateData.lastSoundTick = now;
                    }
                    stateData.lastIsGliding = true;
                }
                if (!isGlidingNow && stateData.lastIsGliding) {
                    if (now - stateData.lastSoundTick >= 2L) {
                        Network.sendToServer((Object)new GenericSoundC2SPacket(0));
                        stateData.lastSoundTick = now;
                    }
                    stateData.lastIsGliding = false;
                }
                if (stateData.flapPulse && isGlidingNow) {
                    stateData.flapPulse = false;
                    if (now - stateData.lastSoundTick >= 2L) {
                        Network.sendToServer((Object)new GenericSoundC2SPacket(2));
                        stateData.lastSoundTick = now;
                    }
                }
                if (!player.m_21255_() && (player.m_20096_() || player.m_20069_() || player.m_20077_())) {
                    stateData.fallAcc = 0;
                    stateData.diveAcc = 0;
                }
            }
        } else {
            if (level.f_46443_) {
                clientAnimationCache.remove(player.m_20148_());
            }
            ClockworkWings.resetFlags(stack);
        }
    }

    private static AnimationStateData getOrCreateAnimationState(UUID playerId) {
        return clientAnimationCache.computeIfAbsent(playerId, k -> new AnimationStateData());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "state", 2, this::statePredicate)});
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "transition", 2, this::transitionPredicate)});
    }

    private <T extends GeoAnimatable> PlayState statePredicate(AnimationState<T> event) {
        long nbtFlapTick;
        CompoundTag tag;
        boolean onGroundish;
        Entity raw = (Entity)event.getData(DataTickets.ENTITY);
        if (!(raw instanceof LivingEntity)) {
            return PlayState.STOP;
        }
        LivingEntity player = (LivingEntity)raw;
        ItemStack stack = (ItemStack)event.getData(DataTickets.ITEMSTACK);
        if (stack == null || stack.m_41619_()) {
            return PlayState.STOP;
        }
        if (player.m_6844_(EquipmentSlot.CHEST).m_41720_() != this) {
            return PlayState.STOP;
        }
        AnimationStateData stateData = ClockworkWings.getOrCreateAnimationState(player.m_20148_());
        long currentTick = player.m_9236_().m_46467_();
        boolean bl = onGroundish = !player.m_21255_() && (player.m_20096_() || player.m_20069_() || player.m_20077_());
        if (onGroundish) {
            stateData.fallAcc = 0;
            stateData.diveAcc = 0;
        }
        if (player.m_9236_().f_46443_ && (tag = stack.m_41783_()) != null && tag.m_128441_(NBT_FLAP_TICK) && (nbtFlapTick = tag.m_128454_(NBT_FLAP_TICK)) != stateData.lastFlapTick && nbtFlapTick > 0L) {
            stateData.lastFlapTick = nbtFlapTick;
            stateData.flapPulse = true;
        }
        if (onGroundish || currentTick - stateData.lastUpdateTick >= 2L) {
            boolean isGlidingNow = player.m_21255_() && ClockworkWings.isFlyEnabled(stack);
            boolean isFallingNow = !isGlidingNow && ClockworkWings.computeFalling(player);
            boolean isDivingNow = isGlidingNow && ClockworkWings.computeDiving(player);
            stateData.fallAcc = isFallingNow ? Math.min(stateData.fallAcc + 1, 8) : Math.max(stateData.fallAcc - 1, 0);
            stateData.diveAcc = isDivingNow ? Math.min(stateData.diveAcc + 1, 12) : Math.max(stateData.diveAcc - 1, 0);
            isFallingNow = stateData.fallAcc >= 2;
            isDivingNow = stateData.diveAcc >= 8;
            stateData.lastUpdateTick = currentTick;
            if (!stateData.isInit) {
                if (isGlidingNow) {
                    event.setAndContinue(isDivingNow ? DIVE : GLIDE);
                } else if (isFallingNow) {
                    event.setAndContinue(FALL);
                } else {
                    event.setAndContinue(CLOSED);
                }
                stateData.isInit = true;
                stateData.isGliding = isGlidingNow;
                return PlayState.CONTINUE;
            }
            if (isGlidingNow) {
                event.setAndContinue(isDivingNow ? DIVE : GLIDE);
            } else if (isFallingNow) {
                event.setAndContinue(FALL);
            } else {
                event.setAndContinue(CLOSED);
            }
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState transitionPredicate(AnimationState<T> event) {
        long nbtFlapTick;
        CompoundTag tag;
        boolean isGlidingNow;
        Entity raw = (Entity)event.getData(DataTickets.ENTITY);
        if (!(raw instanceof LivingEntity)) {
            return PlayState.STOP;
        }
        LivingEntity player = (LivingEntity)raw;
        ItemStack stack = (ItemStack)event.getData(DataTickets.ITEMSTACK);
        if (stack == null || stack.m_41619_()) {
            return PlayState.STOP;
        }
        if (player.m_6844_(EquipmentSlot.CHEST).m_41720_() != this) {
            return PlayState.STOP;
        }
        AnimationStateData stateData = ClockworkWings.getOrCreateAnimationState(player.m_20148_());
        if (!stateData.isInit) {
            return PlayState.STOP;
        }
        boolean bl = isGlidingNow = player.m_21255_() && ClockworkWings.isFlyEnabled(stack);
        if (player.m_9236_().f_46443_ && (tag = stack.m_41783_()) != null && tag.m_128441_(NBT_FLAP_TICK) && (nbtFlapTick = tag.m_128454_(NBT_FLAP_TICK)) != stateData.lastFlapTick && nbtFlapTick > 0L) {
            stateData.lastFlapTick = nbtFlapTick;
            stateData.flapPulse = true;
        }
        if (stateData.flapPulse) {
            stateData.flapPulse = false;
            if (isGlidingNow) {
                event.getController().forceAnimationReset();
                event.setAndContinue(FLAP);
                return PlayState.CONTINUE;
            }
        }
        if (isGlidingNow && !stateData.isGliding) {
            stateData.isGliding = true;
            event.getController().forceAnimationReset();
            event.setAndContinue(OPEN);
            return PlayState.CONTINUE;
        }
        if (!isGlidingNow && stateData.isGliding) {
            stateData.isGliding = false;
            event.getController().forceAnimationReset();
            event.setAndContinue(CLOSE);
            return PlayState.CONTINUE;
        }
        return event.getController().getCurrentAnimation() != null && !event.getController().hasAnimationFinished() ? PlayState.CONTINUE : PlayState.STOP;
    }

    private static boolean computeFalling(LivingEntity entity) {
        if (entity.m_21255_()) {
            return false;
        }
        if (entity.m_6147_()) {
            return false;
        }
        if (entity.m_20069_() || entity.m_20077_()) {
            return false;
        }
        if (entity.m_20096_()) {
            return false;
        }
        return entity.m_20184_().f_82480_ <= -0.1 && (double)entity.f_19789_ >= 0.9;
    }

    private static boolean computeDiving(LivingEntity player) {
        if (!player.m_21255_()) {
            return false;
        }
        if (player.m_6147_()) {
            return false;
        }
        if (player.m_20069_() || player.m_20077_()) {
            return false;
        }
        Vec3 deltaMovement = player.m_20184_();
        if (deltaMovement.m_82553_() < 0.02) {
            return false;
        }
        return deltaMovement.f_82480_ <= -0.35 && player.m_20154_().m_82541_().m_82526_(deltaMovement.m_82541_()) >= 0.7 && player.m_146909_() >= 42.0f;
    }

    private static void resetFlags(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_(NBT_INIT, false);
        tag.m_128379_(NBT_GLIDING, false);
        tag.m_128405_(NBT_FALL_ACCELERATION, 0);
        tag.m_128405_(NBT_DIVE_ACCELERATION, 0);
        tag.m_128379_(NBT_FLAP_PULSE, false);
        tag.m_128473_(NBT_FLAP_TICK);
    }

    public static void spawnBoostEntity(Level level, Player player) {
        if (level.f_46443_) {
            return;
        }
        ItemStack stack = player.m_6844_(EquipmentSlot.CHEST);
        if (stack.m_41619_() || stack.m_41720_() != player.m_6844_(EquipmentSlot.CHEST).m_41720_()) {
            return;
        }
        if (!(stack.m_41720_() instanceof ClockworkWings)) {
            return;
        }
        if (!player.m_21255_()) {
            return;
        }
        if (!ClockworkWings.isFlyEnabled(stack)) {
            return;
        }
        int ticksLeft = ClockworkWings.getBoostRemainingTicks(stack, level);
        if (ticksLeft > 0) {
            int secsLeft = (int)Math.ceil((double)ticksLeft / 20.0);
            player.m_5661_((Component)Component.m_237113_((String)("Boost ready in " + secsLeft + "s")), true);
            return;
        }
        level.m_7967_((Entity)new ClockworkWingsBoostProjectile((EntityType<? extends BaseProjectile>)((EntityType)ClockworkEntities.CLOCKWORK_WINGS_BOOST_PROJECTILE.get()), level, (LivingEntity)player));
        double dx = (level.f_46441_.m_188500_() - 0.5) * 2.0;
        double dy = (level.f_46441_.m_188500_() - 0.5) * 2.0;
        double dz = (level.f_46441_.m_188500_() - 0.5) * 2.0;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, player.m_20185_(), player.m_20186_() + (double)(player.m_20206_() * 0.5f), player.m_20189_(), 10, dx, dy, dz, 0.0225);
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128356_(NBT_BOOST_UNTIL, level.m_46467_() + (long)BOOST_COOLDOWN_TICKS);
    }

    private static int getBoostRemainingTicks(ItemStack stack, Level level) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return 0;
        }
        long now = level.m_46467_();
        long until = tag.m_128454_(NBT_BOOST_UNTIL);
        long left = until - now;
        return (int)Math.max(0L, left);
    }

    private static class AnimationStateData {
        boolean isGliding = false;
        boolean isInit = false;
        int fallAcc = 0;
        int diveAcc = 0;
        boolean flapPulse = false;
        long lastUpdateTick = 0L;
        boolean lastIsGliding = false;
        long lastSoundTick = 0L;
        long lastFlapTick = -1L;

        private AnimationStateData() {
        }
    }
}

