/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.clockwork.common.item;

import dev.xylonity.bonsai.clockwork.Clockwork;
import dev.xylonity.bonsai.clockwork.client.item.renderer.PotionSprayerRenderer;
import dev.xylonity.bonsai.clockwork.client.particle.PotionSprayParticle;
import dev.xylonity.bonsai.clockwork.network.packets.PotionSprayerParticlesC2SPacket;
import dev.xylonity.knightlib.api.network.Network;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class PotionSprayer
extends Item
implements GeoItem {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final RawAnimation USE = RawAnimation.begin().thenPlay("use");
    private static final String NBT_SPRAY_TICKS = "spray_ticks_left";
    private static final String NBT_SPRAYING = "clockwork_spraying";

    public PotionSprayer(Item.Properties properties) {
        super(properties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    private static boolean isAnyPotion(ItemStack s) {
        return !s.m_41619_() && (s.m_150930_(Items.f_42589_) || s.m_150930_(Items.f_42736_) || s.m_150930_(Items.f_42739_)) && !PotionSprayer.isInstantPotion(s);
    }

    private static boolean isInstantPotion(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        for (MobEffectInstance e : PotionUtils.m_43547_((ItemStack)stack)) {
            if (!e.m_19544_().m_8093_()) continue;
            return true;
        }
        return false;
    }

    private static int initialPotionTicks(ItemStack potion) {
        int max = 0;
        for (MobEffectInstance e : PotionUtils.m_43547_((ItemStack)potion)) {
            max = Math.max(max, e.m_19557_());
        }
        return max;
    }

    private static int getSprayTicks(ItemStack potion) {
        return potion.m_41784_().m_128451_(NBT_SPRAY_TICKS);
    }

    private static void setSprayTicks(ItemStack potion, int t) {
        potion.m_41784_().m_128405_(NBT_SPRAY_TICKS, Math.max(0, t));
    }

    @Nullable
    private static PotionRef findFirstPotion(Player p) {
        ItemStack off = p.m_21206_();
        if (PotionSprayer.isAnyPotion(off)) {
            return new PotionRef(off, () -> p.m_21008_(InteractionHand.OFF_HAND, off));
        }
        ItemStack main = p.m_21205_();
        if (PotionSprayer.isAnyPotion(main)) {
            return new PotionRef(main, () -> p.m_21008_(InteractionHand.MAIN_HAND, main));
        }
        Inventory inv = p.m_150109_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack s = inv.m_8020_(i);
            if (!PotionSprayer.isAnyPotion(s)) continue;
            int idx = i;
            return new PotionRef(s, () -> inv.m_6836_(idx, s));
        }
        return null;
    }

    private static boolean isSpraying(ItemStack s) {
        return s.m_41782_() && s.m_41784_().m_128471_(NBT_SPRAYING);
    }

    private static void setSpraying(ItemStack s, boolean v) {
        s.m_41784_().m_128379_(NBT_SPRAYING, v);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        PotionRef ref = PotionSprayer.findFirstPotion(player);
        if (ref == null) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!ref.stack.m_41784_().m_128441_(NBT_SPRAY_TICKS)) {
            int ticks = PotionSprayer.initialPotionTicks(ref.stack);
            if (ticks <= 0) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            PotionSprayer.setSprayTicks(ref.stack, ticks);
            ref.save.run();
        }
        PotionSprayer.setSpraying(stack, true);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        PotionSprayer.setSpraying(stack, false);
    }

    public void m_5929_(Level level, LivingEntity user, ItemStack sprayer, int remainingUseDuration) {
        if (level.f_46443_) {
            return;
        }
        if (!(user instanceof Player)) {
            return;
        }
        Player p = (Player)user;
        PotionRef ref = PotionSprayer.findFirstPotion(p);
        if (ref == null) {
            p.m_5810_();
            PotionSprayer.setSpraying(sprayer, false);
            return;
        }
        ItemStack potion = ref.stack;
        if (!potion.m_41784_().m_128441_(NBT_SPRAY_TICKS)) {
            int init = PotionSprayer.initialPotionTicks(potion);
            if (init <= 0) {
                p.m_5810_();
                PotionSprayer.setSpraying(sprayer, false);
                return;
            }
            PotionSprayer.setSprayTicks(potion, init);
            ref.save.run();
        }
        int left = PotionSprayer.getSprayTicks(potion) - 1;
        PotionSprayer.setSprayTicks(potion, left);
        ref.save.run();
        if (left <= 0) {
            int nextTicks;
            PotionRef next;
            boolean wasDrinkable = potion.m_150930_(Items.f_42589_);
            potion.m_41774_(1);
            ref.save.run();
            if (wasDrinkable) {
                ItemStack bottle = new ItemStack((ItemLike)Items.f_42590_);
                if (!p.m_150109_().m_36054_(bottle)) {
                    p.m_36176_(bottle, false);
                }
            }
            if ((next = PotionSprayer.findFirstPotion(p)) == null) {
                p.m_5810_();
                PotionSprayer.setSpraying(sprayer, false);
                return;
            }
            int n = nextTicks = next.stack.m_41784_().m_128441_(NBT_SPRAY_TICKS) ? PotionSprayer.getSprayTicks(next.stack) : PotionSprayer.initialPotionTicks(next.stack);
            if (nextTicks <= 0) {
                p.m_5810_();
                PotionSprayer.setSpraying(sprayer, false);
                return;
            }
            PotionSprayer.setSprayTicks(next.stack, nextTicks);
            next.save.run();
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        LivingEntity le;
        boolean currentlyUsing;
        LivingEntity le2;
        LivingEntity le3;
        if (!level.f_46443_) {
            return;
        }
        boolean heldInMain = entity instanceof LivingEntity && (le3 = (LivingEntity)entity).m_21205_() == stack;
        boolean heldInOff = entity instanceof LivingEntity && (le2 = (LivingEntity)entity).m_21206_() == stack;
        boolean bl = currentlyUsing = entity instanceof LivingEntity && (le = (LivingEntity)entity).m_6117_() && le.m_21211_() == stack;
        if ((!heldInMain && !heldInOff || !currentlyUsing) && PotionSprayer.isSpraying(stack)) {
            PotionSprayer.setSpraying(stack, false);
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private PotionSprayerRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new PotionSprayerRenderer();
                }
                return this.renderer;
            }
        });
    }

    private static int getFirstPotionColor(Player p) {
        ItemStack off = p.m_21206_();
        if (PotionSprayer.isPotion(off)) {
            return PotionUtils.m_43575_((ItemStack)off);
        }
        ItemStack main = p.m_21205_();
        if (PotionSprayer.isPotion(main)) {
            return PotionUtils.m_43575_((ItemStack)main);
        }
        Inventory inv = p.m_150109_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack s = inv.m_8020_(i);
            if (!PotionSprayer.isPotion(s)) continue;
            return PotionUtils.m_43575_((ItemStack)s);
        }
        return 0xFFFFFF;
    }

    private static boolean isPotion(ItemStack s) {
        return !s.m_41619_() && (s.m_150930_(Items.f_42589_) || s.m_150930_(Items.f_42736_) || s.m_150930_(Items.f_42739_));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "main", 0, state -> {
            ItemStack stack = (ItemStack)state.getData(DataTickets.ITEMSTACK);
            if (stack != null && PotionSprayer.isSpraying(stack)) {
                state.setAnimation(USE);
            } else if (stack != null && !PotionSprayer.isSpraying(stack)) {
                return PlayState.STOP;
            }
            return PlayState.CONTINUE;
        }).setParticleKeyframeHandler(event -> {
            Player p = Clockwork.PROXY.getClientPlayer();
            if (p == null) {
                return;
            }
            Vec3 eye = p.m_20299_(1.0f);
            Vec3 look = p.m_20154_().m_82541_();
            Vec3 right = new Vec3(-look.f_82481_, 0.0, look.f_82479_).m_82541_();
            double side = p.m_5737_() == HumanoidArm.RIGHT ? 1.0 : -1.0;
            double forward = 0.8;
            double lateral = 0.0;
            double up = -0.3;
            Vec3 pos = eye.m_82549_(look.m_82490_(forward)).m_82549_(right.m_82490_(lateral * side)).m_82520_(0.0, up, 0.0);
            Vec3 viewVector = p.m_20252_(1.0f).m_82541_().m_82559_(new Vec3((double)0.3225f, (double)0.3225f, (double)0.3225f));
            PotionSprayParticle.setDefaultVelocityAndColor((float)viewVector.f_82479_, (float)viewVector.f_82480_, (float)viewVector.f_82481_, PotionSprayer.getFirstPotionColor(p));
            ItemStack potion = ItemStack.f_41583_;
            PotionRef ref = PotionSprayer.findFirstPotion(p);
            if (ref != null) {
                potion = ref.stack;
            }
            Network.sendToServer((Object)new PotionSprayerParticlesC2SPacket(pos.f_82479_, pos.f_82480_, pos.f_82481_, (float)viewVector.f_82479_, (float)viewVector.f_82480_, (float)viewVector.f_82481_, potion));
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getBoneResetTime() {
        return 0.0;
    }

    private static class PotionRef {
        ItemStack stack;
        Runnable save;

        PotionRef(ItemStack s, Runnable save) {
            this.stack = s;
            this.save = save;
        }
    }
}

