/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.clockwork.common.sound;

import dev.xylonity.bonsai.clockwork.common.entity.custom.DragonflyEntity;
import dev.xylonity.bonsai.clockwork.common.sound.SoundProxy;
import dev.xylonity.bonsai.clockwork.mixin.AbstractTickableSoundInstanceAccessor;
import dev.xylonity.bonsai.clockwork.registry.ClockworkSounds;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public final class ClientSoundProxy
implements SoundProxy {
    private final Map<Integer, FlyLoop> flyById = new HashMap<Integer, FlyLoop>();
    private final Map<Integer, IdleLoop> idleById = new HashMap<Integer, IdleLoop>();

    @Override
    public void tickDragonflySounds(DragonflyEntity e) {
        DragonflyLoop loop;
        DragonflyLoop current;
        boolean wantIdle;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        int id = e.m_19879_();
        int state = e.getState();
        boolean isFlying = state == 1;
        boolean bl = wantIdle = !isFlying;
        if (isFlying) {
            current = this.flyById.get(id);
            if (current == null || current.m_7801_()) {
                loop = new FlyLoop((SoundEvent)ClockworkSounds.DRAGONFLY_FLY.get(), e);
                ClientSoundProxy.play(loop);
                this.flyById.put(id, (FlyLoop)loop);
            }
        } else {
            ClientSoundProxy.stopImmediate(this.flyById.remove(id));
        }
        if (wantIdle) {
            current = this.idleById.get(id);
            if (current == null || current.m_7801_()) {
                loop = new IdleLoop((SoundEvent)ClockworkSounds.DRAGONFLY_IDLE.get(), e);
                ClientSoundProxy.play(loop);
                this.idleById.put(id, (IdleLoop)loop);
            }
        } else {
            ClientSoundProxy.stopImmediate(this.idleById.remove(id));
        }
        if (isFlying) {
            ClientSoundProxy.stopImmediate(this.idleById.remove(id));
        } else if (wantIdle) {
            ClientSoundProxy.stopImmediate(this.flyById.remove(id));
        }
    }

    @Override
    public void stopAllFor(DragonflyEntity e) {
        int id = e.m_19879_();
        ClientSoundProxy.stopImmediate(this.flyById.remove(id));
        ClientSoundProxy.stopImmediate(this.idleById.remove(id));
    }

    private static void play(AbstractTickableSoundInstance s) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91106_() != null) {
            mc.m_91106_().m_120367_((SoundInstance)s);
        }
    }

    private static void stopImmediate(AbstractTickableSoundInstance s) {
        if (s != null) {
            ((AbstractTickableSoundInstanceAccessor)s).clockwork$stop();
        }
    }

    private static final class FlyLoop
    extends DragonflyLoop {
        FlyLoop(SoundEvent event, DragonflyEntity entity) {
            super(event, entity);
        }

        @Override
        protected boolean isStillValidFor(DragonflyEntity e) {
            return e.getState() == 1 && !e.m_213877_();
        }
    }

    private static final class IdleLoop
    extends DragonflyLoop {
        IdleLoop(SoundEvent event, DragonflyEntity entity) {
            super(event, entity);
        }

        @Override
        protected boolean isStillValidFor(DragonflyEntity e) {
            int s = e.getState();
            return e.getState() != 1 && !e.m_213877_();
        }
    }

    private static abstract class DragonflyLoop
    extends AbstractTickableSoundInstance {
        protected final DragonflyEntity entity;

        protected DragonflyLoop(SoundEvent event, DragonflyEntity entity) {
            super(event, SoundSource.NEUTRAL, SoundInstance.m_235150_());
            this.entity = entity;
            this.f_119578_ = true;
            this.f_119579_ = 0;
            this.f_119573_ = 0.4f;
            this.f_119574_ = 1.0f;
            this.f_119575_ = (float)entity.m_20185_();
            this.f_119576_ = (float)entity.m_20186_();
            this.f_119577_ = (float)entity.m_20189_();
        }

        public void m_7788_() {
            if (this.entity == null || this.entity.m_213877_() || !this.entity.m_9236_().f_46443_) {
                this.m_119609_();
                return;
            }
            this.f_119575_ = (float)this.entity.m_20185_();
            this.f_119576_ = (float)this.entity.m_20186_();
            this.f_119577_ = (float)this.entity.m_20189_();
            if (!this.isStillValidFor(this.entity)) {
                this.m_119609_();
            }
        }

        protected abstract boolean isStillValidFor(DragonflyEntity var1);
    }
}

