/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.clockwork.mixin;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={PotionItem.class})
public abstract class PotionItemMixin {
    private static final String NBT_SPRAY_TICKS = "spray_ticks_left";

    @Redirect(method={"finishUsingItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/ItemStack;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/alchemy/PotionUtils;getMobEffects(Lnet/minecraft/world/item/ItemStack;)Ljava/util/List;"))
    private List<MobEffectInstance> clockwork$applyRemainingDuration(ItemStack stack) {
        List original = PotionUtils.m_43547_((ItemStack)stack);
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_(NBT_SPRAY_TICKS)) {
            return original;
        }
        int leftTicks = Math.max(0, stack.m_41783_().m_128451_(NBT_SPRAY_TICKS));
        if (leftTicks <= 0) {
            return List.of();
        }
        int baseMax = 0;
        for (MobEffectInstance e : original) {
            baseMax = Math.max(baseMax, e.m_19557_());
        }
        if (baseMax <= 0) {
            return original;
        }
        double ratio = Math.min(1.0, (double)leftTicks / (double)baseMax);
        ArrayList<MobEffectInstance> adjusted = new ArrayList<MobEffectInstance>(original.size());
        for (MobEffectInstance e : original) {
            int newDur = (int)Math.floor((double)e.m_19557_() * ratio);
            if (newDur <= 0) continue;
            adjusted.add(new MobEffectInstance(e.m_19544_(), newDur, e.m_19564_(), e.m_19571_(), e.m_19572_(), e.m_19575_()));
        }
        return adjusted;
    }
}

