/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.clockwork.mixin;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PotionUtils.class})
public abstract class PotionUtilsMixin {
    private static final String NBT_SPRAY_TICKS = "spray_ticks_left";

    @Inject(method={"addPotionTooltip(Lnet/minecraft/world/item/ItemStack;Ljava/util/List;F)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void bonsai$adjustTooltip(ItemStack stack, List<Component> tooltips, float durationFactor, CallbackInfo ci) {
        if (!(stack.m_150930_(Items.f_42589_) || stack.m_150930_(Items.f_42736_) || stack.m_150930_(Items.f_42739_))) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(NBT_SPRAY_TICKS)) {
            return;
        }
        int leftTicks = Math.max(0, tag.m_128451_(NBT_SPRAY_TICKS));
        List original = PotionUtils.m_43566_((CompoundTag)stack.m_41783_());
        if (original.isEmpty()) {
            return;
        }
        int baseMax = 0;
        for (MobEffectInstance e : original) {
            baseMax = Math.max(baseMax, e.m_19557_());
        }
        if (baseMax <= 0) {
            return;
        }
        double ratio = Math.min(1.0, (double)leftTicks / (double)baseMax);
        ArrayList<MobEffectInstance> adjusted = new ArrayList<MobEffectInstance>(original.size());
        for (MobEffectInstance e : original) {
            int newDur = (int)Math.floor((double)e.m_19557_() * ratio);
            adjusted.add(new MobEffectInstance(e.m_19544_(), Math.max(0, newDur), e.m_19564_(), e.m_19571_(), e.m_19572_(), e.m_19575_()));
        }
        PotionUtils.m_257410_(adjusted, tooltips, (float)durationFactor);
        ci.cancel();
    }
}

