/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.insidethesystem.procedures;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.mcreator.insidethesystem.InsideTheSystemMod;
import net.mcreator.insidethesystem.entity.CoolPlayer303Entity;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber
public class CoolPlayerTooFarProcedure {
    private static final Map<UUID, Boolean> waitingForResponse = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Boolean> hasAskedBefore = new HashMap<UUID, Boolean>();
    private static final Map<UUID, UUID> coolPlayerToPlayerMap = new HashMap<UUID, UUID>();
    private static final double TELEPORT_DISTANCE = 60.0;

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Pre event) {
        CoolPlayerTooFarProcedure.execute((LevelAccessor)event.getEntity().level(), event.getEntity());
    }

    @SubscribeEvent
    public static void onChat(ServerChatEvent event) {
        ServerPlayer player = event.getPlayer();
        String rawMessage = event.getRawText();
        CoolPlayerTooFarProcedure.handleChatResponse((Player)player, rawMessage);
    }

    private static void execute(LevelAccessor world, Entity entity) {
        if (entity == null || world.isClientSide()) {
            return;
        }
        if (entity instanceof CoolPlayer303Entity) {
            UUID expectedPlayerId;
            CoolPlayer303Entity coolPlayer = (CoolPlayer303Entity)entity;
            UUID coolPlayerId = coolPlayer.getUUID();
            Player nearestPlayer = world.getNearestPlayer(coolPlayer.getX(), coolPlayer.getY(), coolPlayer.getZ(), -1.0, false);
            if (nearestPlayer == null) {
                return;
            }
            UUID playerId = nearestPlayer.getUUID();
            double distance = coolPlayer.distanceTo((Entity)nearestPlayer);
            if (waitingForResponse.getOrDefault(coolPlayerId, false).booleanValue() && distance <= 60.0 && (expectedPlayerId = coolPlayerToPlayerMap.get(coolPlayerId)) != null && expectedPlayerId.equals(playerId)) {
                waitingForResponse.put(coolPlayerId, false);
                coolPlayerToPlayerMap.remove(coolPlayerId);
                CoolPlayerTooFarProcedure.broadcastMessage(world, "<CoolPlayer303> Oh, you're back! Never mind then");
                return;
            }
            if (distance > 60.0 && !waitingForResponse.getOrDefault(coolPlayerId, false).booleanValue() && !hasAskedBefore.getOrDefault(coolPlayerId, false).booleanValue()) {
                CoolPlayerTooFarProcedure.askForTeleport(world, coolPlayerId, playerId);
            }
        }
    }

    private static void askForTeleport(LevelAccessor world, UUID coolPlayerId, UUID playerId) {
        waitingForResponse.put(coolPlayerId, true);
        hasAskedBefore.put(coolPlayerId, true);
        coolPlayerToPlayerMap.put(coolPlayerId, playerId);
        CoolPlayerTooFarProcedure.broadcastMessage(world, "<CoolPlayer303> Hey, I think I lost you... You're too far away!");
        InsideTheSystemMod.queueServerWork(40, () -> {
            if (waitingForResponse.getOrDefault(coolPlayerId, false).booleanValue()) {
                CoolPlayerTooFarProcedure.broadcastMessage(world, "<CoolPlayer303> Can I teleport to you? Just say 'yes' or 'no' in chat!");
                CoolPlayerTooFarProcedure.broadcastMessage(world, "<CoolPlayer303> You can also just say 'tp for me' anytime, but DON'T go too far, or I'll get unloaded and can't teleport!");
            }
        });
    }

    private static void handleChatResponse(Player player, String message) {
        ServerPlayer serverPlayer;
        block14: {
            block13: {
                if (!(player instanceof ServerPlayer)) break block13;
                serverPlayer = (ServerPlayer)player;
                if (message != null) break block14;
            }
            return;
        }
        String cleanMessage = message.toLowerCase().trim();
        UUID playerId = serverPlayer.getUUID();
        UUID waitingCoolPlayerId = null;
        for (Map.Entry<UUID, UUID> entry : coolPlayerToPlayerMap.entrySet()) {
            if (!entry.getValue().equals(playerId) || !waitingForResponse.getOrDefault(entry.getKey(), false).booleanValue()) continue;
            waitingCoolPlayerId = entry.getKey();
            break;
        }
        if (waitingCoolPlayerId != null) {
            CoolPlayer303Entity coolPlayer = CoolPlayerTooFarProcedure.findCoolPlayerById((LevelAccessor)serverPlayer.level(), waitingCoolPlayerId);
            if (coolPlayer == null) {
                return;
            }
            UUID finalCoolPlayerId = waitingCoolPlayerId;
            if (cleanMessage.equals("yes") || cleanMessage.equals("y")) {
                CoolPlayerTooFarProcedure.performTeleport(serverPlayer, coolPlayer, finalCoolPlayerId, true);
                return;
            }
            if (cleanMessage.equals("no") || cleanMessage.equals("n")) {
                waitingForResponse.put(finalCoolPlayerId, false);
                coolPlayerToPlayerMap.remove(finalCoolPlayerId);
                InsideTheSystemMod.queueServerWork(20, () -> CoolPlayerTooFarProcedure.broadcastMessage((LevelAccessor)serverPlayer.level(), "<CoolPlayer303> Okay, I'll wait here then. Let me know if you change your mind!"));
                return;
            }
        }
        if (cleanMessage.equals("\u0442\u043f \u0444\u043e\u0440 \u043c\u0438") || cleanMessage.equals("tp for me")) {
            UUID coolPlayerUUID = CoolPlayerTooFarProcedure.findClosestCoolPlayerUUID((LevelAccessor)serverPlayer.level(), serverPlayer.getUUID());
            if (coolPlayerUUID != null) {
                CoolPlayer303Entity coolPlayer = CoolPlayerTooFarProcedure.findCoolPlayerById((LevelAccessor)serverPlayer.level(), coolPlayerUUID);
                if (coolPlayer != null) {
                    waitingForResponse.put(coolPlayer.getUUID(), false);
                    coolPlayerToPlayerMap.remove(coolPlayer.getUUID());
                    CoolPlayerTooFarProcedure.performTeleport(serverPlayer, coolPlayer, coolPlayer.getUUID(), false);
                } else {
                    serverPlayer.sendSystemMessage((Component)Component.literal((String)"\u00a77[System] ERROR: CoolPlayer303 not found or is too far and unloaded."));
                }
            } else {
                serverPlayer.sendSystemMessage((Component)Component.literal((String)"\u00a77[System] ERROR: CoolPlayer303 not found or is too far and unloaded."));
            }
        }
    }

    private static UUID findClosestCoolPlayerUUID(LevelAccessor world, UUID playerId) {
        if (!(world instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        List entities = serverLevel.getEntitiesOfClass(CoolPlayer303Entity.class, new AABB(-3.0E7, -256.0, -3.0E7, 3.0E7, 320.0, 3.0E7));
        if (entities.isEmpty()) {
            return null;
        }
        return entities.stream().findFirst().map(Entity::getUUID).orElse(null);
    }

    private static void performTeleport(ServerPlayer serverPlayer, CoolPlayer303Entity coolPlayer, UUID coolPlayerId, boolean requestedByAnswer) {
        waitingForResponse.put(coolPlayerId, false);
        coolPlayerToPlayerMap.remove(coolPlayerId);
        InsideTheSystemMod.queueServerWork(20, () -> {
            CoolPlayerTooFarProcedure.broadcastMessage((LevelAccessor)serverPlayer.level(), "<CoolPlayer303> Thank you! Teleporting to you now!");
            InsideTheSystemMod.queueServerWork(20, () -> {
                if (coolPlayer != null && !coolPlayer.isRemoved() && serverPlayer != null && !serverPlayer.isRemoved()) {
                    coolPlayer.teleportTo(serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ());
                    if (requestedByAnswer) {
                        CoolPlayerTooFarProcedure.broadcastMessage((LevelAccessor)serverPlayer.level(), "<CoolPlayer303> Thank you, I won't ask again");
                    } else {
                        CoolPlayerTooFarProcedure.broadcastMessage((LevelAccessor)serverPlayer.level(), "<CoolPlayer303> TP accepted. I'm teleporting now");
                    }
                }
            });
        });
    }

    private static CoolPlayer303Entity findCoolPlayerById(LevelAccessor world, UUID coolPlayerId) {
        if (!(world instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        List entities = serverLevel.getEntitiesOfClass(CoolPlayer303Entity.class, new AABB(-3.0E7, -256.0, -3.0E7, 3.0E7, 320.0, 3.0E7), entity -> entity.getUUID().equals(coolPlayerId));
        return entities.stream().findFirst().orElse(null);
    }

    private static void broadcastMessage(LevelAccessor world, String message) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            serverLevel.getServer().getPlayerList().broadcastSystemMessage((Component)Component.literal((String)message), false);
        }
    }
}

