/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.insidethesystem.procedures;

import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.mcreator.insidethesystem.InsideTheSystemMod;
import net.mcreator.insidethesystem.init.InsideTheSystemModBlocks;
import net.mcreator.insidethesystem.init.InsideTheSystemModSounds;
import net.mcreator.insidethesystem.network.InsideTheSystemModVariables;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ChangeChunkProcedure {
    private static final Map<UUID, Integer> countdowns = new ConcurrentHashMap<UUID, Integer>();
    private static final Random random = new Random();
    private static final int COUNTDOWN_INTERVAL = 30;

    private static BlockState getTargetBlockState() {
        return ((Block)InsideTheSystemModBlocks.BLOODY_JUKEBOX.get()).m_49966_();
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ChangeChunkProcedure.execute((Event)event, (LevelAccessor)event.player.f_19853_, (Entity)event.player);
        }
    }

    public static void execute(LevelAccessor world, Entity entity) {
        ChangeChunkProcedure.execute(null, world, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, Entity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        UUID playerId = player.m_20148_();
        if (InsideTheSystemModVariables.MapVariables.get((LevelAccessor)world).Change) {
            InsideTheSystemModVariables.MapVariables.get((LevelAccessor)world).Change = false;
            InsideTheSystemModVariables.MapVariables.get(world).syncData(world);
            countdowns.put(playerId, 300);
            if (!world.m_5776_()) {
                player.m_213846_((Component)Component.m_237113_((String)":)"));
            }
            ChangeChunkProcedure.scheduleCountdown(world, player, playerId);
        }
    }

    private static void scheduleCountdown(LevelAccessor world, Player player, UUID playerId) {
        ServerLevel serverLevel;
        int tick = countdowns.getOrDefault(playerId, 0);
        if (tick == 150 && world instanceof ServerLevel) {
            serverLevel = (ServerLevel)world;
            serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)InsideTheSystemModSounds.GLITCH.get(), SoundSource.MASTER, 1.0f, 1.0f);
        }
        if (tick <= 0) {
            if (world instanceof ServerLevel) {
                serverLevel = (ServerLevel)world;
                ChangeChunkProcedure.changeChunks(serverLevel, player);
                ChangeChunkProcedure.setNight(serverLevel);
            }
            countdowns.remove(playerId);
            return;
        }
        if (tick % 30 == 0) {
            int seconds = tick / 30;
            if (!world.m_5776_() && seconds > 0) {
                player.m_213846_((Component)Component.m_237113_((String)String.valueOf(seconds)));
            }
        }
        if (tick % 5 == 0 && tick > 0) {
            ChangeChunkProcedure.changeBlocksAroundPlayer(world, player, 5);
        }
        countdowns.put(playerId, tick - 1);
        InsideTheSystemMod.queueServerWork(1, () -> ChangeChunkProcedure.scheduleCountdown(world, player, playerId));
    }

    private static void setNight(ServerLevel world) {
        world.m_8615_(13000L);
    }

    private static void changeBlocksAroundPlayer(LevelAccessor world, Player player, int radius) {
        BlockState targetBlockState = ChangeChunkProcedure.getTargetBlockState();
        BlockPos playerPos = player.m_20183_();
        for (int i = 0; i < 5; ++i) {
            int dz;
            int dy;
            int dx = random.nextInt(2 * radius) - radius;
            BlockPos targetPos = playerPos.m_7918_(dx, dy = random.nextInt(2 * radius) - radius, dz = random.nextInt(2 * radius) - radius);
            BlockState currentState = world.m_8055_(targetPos);
            if (currentState.m_60795_() || currentState.m_60734_() == Blocks.f_50752_ || !(targetPos.m_123331_((Vec3i)playerPos) > 1.0)) continue;
            world.m_7731_(targetPos, targetBlockState, 3);
        }
    }

    private static void changeChunks(ServerLevel world, Player player) {
        BlockState targetBlockState = ChangeChunkProcedure.getTargetBlockState();
        int chunkX = player.m_146902_().f_45578_;
        int chunkZ = player.m_146902_().f_45579_;
        int xStart = chunkX * 16;
        int zStart = chunkZ * 16;
        for (int x = xStart; x < xStart + 16; ++x) {
            for (int z = zStart; z < zStart + 16; ++z) {
                for (int y = world.m_141937_(); y <= world.m_151558_() - 1; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = world.m_8055_(pos);
                    if (state.m_60795_() || state.m_60734_() == Blocks.f_50752_) continue;
                    world.m_7731_(pos, targetBlockState, 3);
                }
            }
        }
    }
}

