/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.insidethesystem.procedures;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mcreator.insidethesystem.InsideTheSystemMod;
import net.mcreator.insidethesystem.entity.CoolPlayer303Entity;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CoolPlayerTooFarProcedure {
    private static final Map<UUID, Boolean> waitingForResponse = new HashMap<UUID, Boolean>();
    private static final Map<UUID, UUID> coolPlayerToPlayerMap = new HashMap<UUID, UUID>();
    private static final Map<UUID, Long> lastQuestionTime = new HashMap<UUID, Long>();
    private static final long QUESTION_COOLDOWN = 10000L;

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        CoolPlayerTooFarProcedure.execute((Event)event, (LevelAccessor)event.getEntity().m_9236_(), (Entity)event.getEntity());
    }

    @SubscribeEvent
    public static void onChat(ServerChatEvent event) {
        ServerPlayer player = event.getPlayer();
        String rawMessage = event.getRawText();
        CoolPlayerTooFarProcedure.handleChatResponse((Player)player, rawMessage);
    }

    public static void execute(LevelAccessor world, Entity entity) {
        CoolPlayerTooFarProcedure.execute(null, world, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, Entity entity) {
        if (entity == null || world.m_5776_()) {
            return;
        }
        if (entity instanceof CoolPlayer303Entity) {
            UUID expectedPlayerId;
            CoolPlayer303Entity coolPlayer = (CoolPlayer303Entity)entity;
            UUID coolPlayerId = coolPlayer.m_20148_();
            Player nearestPlayer = world.m_45924_(coolPlayer.m_20185_(), coolPlayer.m_20186_(), coolPlayer.m_20189_(), -1.0, false);
            if (nearestPlayer == null) {
                return;
            }
            UUID playerId = nearestPlayer.m_20148_();
            double distance = coolPlayer.m_20270_((Entity)nearestPlayer);
            if (waitingForResponse.getOrDefault(coolPlayerId, false).booleanValue() && distance <= 50.0 && (expectedPlayerId = coolPlayerToPlayerMap.get(coolPlayerId)) != null && expectedPlayerId.equals(playerId)) {
                waitingForResponse.put(coolPlayerId, false);
                coolPlayerToPlayerMap.remove(coolPlayerId);
                lastQuestionTime.put(coolPlayerId, System.currentTimeMillis());
                CoolPlayerTooFarProcedure.broadcastMessage(world, "<CoolPlayer303> Oh, you're back! Never mind then.");
                return;
            }
            if (distance > 50.0 && !waitingForResponse.getOrDefault(coolPlayerId, false).booleanValue()) {
                long currentTime = System.currentTimeMillis();
                Long lastTime = lastQuestionTime.get(coolPlayerId);
                if (lastTime == null || currentTime - lastTime > 10000L) {
                    CoolPlayerTooFarProcedure.askForTeleport(world, coolPlayerId, playerId);
                    lastQuestionTime.put(coolPlayerId, currentTime);
                }
            }
        }
    }

    private static void askForTeleport(LevelAccessor world, UUID coolPlayerId, UUID playerId) {
        waitingForResponse.put(coolPlayerId, true);
        coolPlayerToPlayerMap.put(coolPlayerId, playerId);
        CoolPlayerTooFarProcedure.broadcastMessage(world, "<CoolPlayer303> Hey, I think I lost you... You're too far away!");
        InsideTheSystemMod.queueServerWork(40, () -> {
            if (waitingForResponse.getOrDefault(coolPlayerId, false).booleanValue()) {
                CoolPlayerTooFarProcedure.broadcastMessage(world, "<CoolPlayer303> Can I teleport to you? Just say 'yes' or 'no' in chat!");
            }
        });
    }

    private static void handleChatResponse(Player player, String message) {
        ServerPlayer serverPlayer;
        block10: {
            block9: {
                if (!(player instanceof ServerPlayer)) break block9;
                serverPlayer = (ServerPlayer)player;
                if (message != null) break block10;
            }
            return;
        }
        String cleanMessage = message.toLowerCase().trim();
        UUID playerId = serverPlayer.m_20148_();
        UUID waitingCoolPlayerId = null;
        for (Map.Entry<UUID, UUID> entry : coolPlayerToPlayerMap.entrySet()) {
            if (!entry.getValue().equals(playerId) || !waitingForResponse.getOrDefault(entry.getKey(), false).booleanValue()) continue;
            waitingCoolPlayerId = entry.getKey();
            break;
        }
        if (waitingCoolPlayerId == null) {
            return;
        }
        CoolPlayer303Entity coolPlayer = CoolPlayerTooFarProcedure.findCoolPlayerById((LevelAccessor)serverPlayer.m_9236_(), waitingCoolPlayerId);
        if (coolPlayer == null) {
            return;
        }
        UUID finalCoolPlayerId = waitingCoolPlayerId;
        if (cleanMessage.equals("yes") || cleanMessage.equals("y")) {
            waitingForResponse.put(finalCoolPlayerId, false);
            coolPlayerToPlayerMap.remove(finalCoolPlayerId);
            lastQuestionTime.put(finalCoolPlayerId, System.currentTimeMillis());
            InsideTheSystemMod.queueServerWork(20, () -> {
                CoolPlayerTooFarProcedure.broadcastMessage((LevelAccessor)serverPlayer.m_9236_(), "<CoolPlayer303> Thank you! Teleporting to you now!");
                InsideTheSystemMod.queueServerWork(20, () -> {
                    if (coolPlayer != null && !coolPlayer.m_213877_() && serverPlayer != null && !serverPlayer.m_213877_()) {
                        coolPlayer.m_6021_(serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_());
                        CoolPlayerTooFarProcedure.broadcastMessage((LevelAccessor)serverPlayer.m_9236_(), "<CoolPlayer303> There we go! Much better!");
                        lastQuestionTime.put(finalCoolPlayerId, System.currentTimeMillis());
                    }
                });
            });
        } else if (cleanMessage.equals("no") || cleanMessage.equals("n")) {
            waitingForResponse.put(finalCoolPlayerId, false);
            coolPlayerToPlayerMap.remove(finalCoolPlayerId);
            lastQuestionTime.put(finalCoolPlayerId, System.currentTimeMillis());
            InsideTheSystemMod.queueServerWork(20, () -> CoolPlayerTooFarProcedure.broadcastMessage((LevelAccessor)serverPlayer.m_9236_(), "<CoolPlayer303> Okay, I'll wait here then. Let me know if you change your mind!"));
        }
    }

    private static CoolPlayer303Entity findCoolPlayerById(LevelAccessor world, UUID coolPlayerId) {
        if (!(world instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        List entities = serverLevel.m_6443_(CoolPlayer303Entity.class, new AABB(-3.0E7, -256.0, -3.0E7, 3.0E7, 320.0, 3.0E7), entity -> entity.m_20148_().equals(coolPlayerId));
        return entities.stream().findFirst().orElse(null);
    }

    private static void broadcastMessage(LevelAccessor world, String message) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            serverLevel.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)message), false);
        }
    }
}

