/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.insidethesystem.procedures;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.mcreator.insidethesystem.entity.CoolPlayer303Entity;
import net.mcreator.insidethesystem.network.InsideTheSystemModVariables;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class InventoryProcedure {
    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getHand() != event.getEntity().m_7655_()) {
            return;
        }
        InventoryProcedure.execute((Event)event, (LevelAccessor)event.getLevel(), event.getTarget(), (Entity)event.getEntity(), event.getHand());
    }

    public static void execute(LevelAccessor world, Entity entity, Entity sourceentity, InteractionHand hand) {
        InventoryProcedure.execute(null, world, entity, sourceentity, hand);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, Entity entity, Entity sourceentity, InteractionHand hand) {
        EquipmentSlot targetSlot;
        if (entity == null || sourceentity == null) {
            return;
        }
        if (!(entity instanceof CoolPlayer303Entity) || !(sourceentity instanceof Player)) {
            return;
        }
        Player player = (Player)sourceentity;
        ItemStack heldItem = player.m_21120_(hand);
        boolean changed = false;
        if (player.m_6144_() && heldItem.m_41619_()) {
            List<EquipmentSlot> slots = Arrays.asList(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET, EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND);
            for (EquipmentSlot slot : slots) {
                ItemStack equipped = ((LivingEntity)entity).m_6844_(slot);
                if (equipped.m_41619_() || InventoryProcedure.isUnremovable(equipped)) continue;
                InventoryProcedure.returnItemToPlayer(player, equipped.m_41777_());
                ((LivingEntity)entity).m_8061_(slot, ItemStack.f_41583_);
                changed = true;
                if (event != null) {
                    event.setCanceled(true);
                }
                break;
            }
        } else if (!heldItem.m_41619_() && (targetSlot = InventoryProcedure.getTargetSlotForItem(heldItem, (LivingEntity)entity)) != null) {
            LivingEntity coolEntity = (LivingEntity)entity;
            ItemStack currentItem = coolEntity.m_6844_(targetSlot);
            if (!currentItem.m_41619_()) {
                if (InventoryProcedure.isUnremovable(currentItem)) {
                    if (event != null) {
                        event.setCanceled(true);
                    }
                    return;
                }
                InventoryProcedure.returnItemToPlayer(player, currentItem.m_41777_());
                coolEntity.m_8061_(targetSlot, ItemStack.f_41583_);
                changed = true;
            }
            ItemStack copy = heldItem.m_41777_();
            copy.m_41764_(1);
            coolEntity.m_8061_(targetSlot, copy);
            heldItem.m_41774_(1);
            if (heldItem.m_41619_()) {
                player.m_21008_(hand, ItemStack.f_41583_);
            }
            changed = true;
            if (event != null) {
                event.setCanceled(true);
            }
        }
        if (changed) {
            InventoryProcedure.updateAllItemsAndTriggerStructure(world, entity);
        }
    }

    private static void updateAllItemsAndTriggerStructure(LevelAccessor world, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        ItemStack mainHand = living.m_6844_(EquipmentSlot.MAINHAND);
        ItemStack offHand = living.m_6844_(EquipmentSlot.OFFHAND);
        ItemStack chest = living.m_6844_(EquipmentSlot.CHEST);
        ResourceLocation mainId = ForgeRegistries.ITEMS.getKey((Object)mainHand.m_41720_());
        ResourceLocation offId = ForgeRegistries.ITEMS.getKey((Object)offHand.m_41720_());
        ResourceLocation chestId = ForgeRegistries.ITEMS.getKey((Object)chest.m_41720_());
        boolean hasBloodyKnife = mainId != null && mainId.m_135815_().equals("bloodyknife");
        boolean hasGerd = offId != null && offId.m_135815_().equals("gerd");
        boolean hasShell = chestId != null && chestId.m_135815_().equals("shellnecklace_chestplate");
        boolean allItems = hasBloodyKnife && hasGerd && hasShell;
        InsideTheSystemModVariables.MapVariables vars = InsideTheSystemModVariables.MapVariables.get(world);
        vars.AllItems = allItems;
        if (allItems && !vars.generated && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            InventoryProcedure.generateStructure(world, serverWorld, vars);
        }
        vars.syncData(world);
    }

    private static void generateStructure(LevelAccessor world, ServerLevel serverWorld, InsideTheSystemModVariables.MapVariables vars) {
        RandomSource random = serverWorld.m_213780_();
        double x = 0.0;
        double z = 0.0;
        int y = 0;
        boolean found = false;
        for (int i = 0; i < 200; ++i) {
            double angle = random.m_188500_() * Math.PI * 2.0;
            double dist = random.m_188500_() * 1000.0;
            x = Math.cos(angle) * dist;
            z = Math.sin(angle) * dist;
            y = random.m_188503_(21) + 20;
            BlockPos pos = new BlockPos(x, (double)y, z);
            BlockState state = world.m_8055_(pos);
            FluidState fluid = world.m_6425_(pos);
            BlockState below = world.m_8055_(pos.m_7495_());
            FluidState belowFluid = world.m_6425_(pos.m_7495_());
            if (state.m_60795_() || !fluid.m_76178_() || below.m_60795_() || !belowFluid.m_76178_() || InventoryProcedure.isExposed(world, pos)) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        StructureTemplate template = serverWorld.m_215082_().m_230359_(new ResourceLocation("inside_the_system", "stonehouse"));
        if (template == null) {
            return;
        }
        BlockPos structurePos = new BlockPos(x, (double)y, z);
        template.m_230328_((ServerLevelAccessor)serverWorld, structurePos, structurePos, new StructurePlaceSettings().m_74379_(Rotation.NONE).m_74377_(Mirror.NONE).m_74392_(false), random, 3);
        InventoryProcedure.createStonePillar(serverWorld, x, y, z);
        vars.x = x;
        vars.y = y;
        vars.z = z;
        vars.generated = true;
        vars.chatTriggered = false;
    }

    private static void createStonePillar(ServerLevel world, double x, double y, double z) {
        for (int yy = (int)y; yy <= 90; ++yy) {
            BlockPos pos = new BlockPos(x, (double)yy, z);
            if (!world.m_8055_(pos).m_60795_()) continue;
            world.m_7731_(pos, Blocks.f_50069_.m_49966_(), 3);
        }
    }

    private static boolean isExposed(LevelAccessor world, BlockPos pos) {
        int air = 0;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    if (dx == 0 && dy == 0 && dz == 0 || !world.m_8055_(pos.m_7918_(dx, dy, dz)).m_60795_()) continue;
                    ++air;
                }
            }
        }
        return air > 10;
    }

    private static boolean isUnremovable(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (id == null) {
            return false;
        }
        return id.m_135815_().equals("bloodyknife") || id.m_135815_().equals("gerd") || id.m_135815_().equals("shellnecklace_chestplate");
    }

    private static EquipmentSlot getTargetSlotForItem(ItemStack stack, LivingEntity entity) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (id == null) {
            return null;
        }
        String path = id.m_135815_();
        if (path.equals("bloodyknife")) {
            return EquipmentSlot.MAINHAND;
        }
        if (path.equals("gerd")) {
            return EquipmentSlot.OFFHAND;
        }
        if (path.equals("shellnecklace_chestplate")) {
            return EquipmentSlot.CHEST;
        }
        Item item = stack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            return armor.m_40402_();
        }
        if (InventoryProcedure.isWeaponOrTool(path)) {
            return EquipmentSlot.MAINHAND;
        }
        if (path.contains("shield")) {
            return EquipmentSlot.OFFHAND;
        }
        return EquipmentSlot.MAINHAND;
    }

    private static boolean isWeaponOrTool(String path) {
        return path.contains("sword") || path.contains("axe") || path.contains("pickaxe") || path.contains("shovel") || path.contains("hoe") || path.contains("bow") || path.contains("trident");
    }

    private static void returnItemToPlayer(Player player, ItemStack stack) {
        if (!player.m_150109_().m_36054_(stack)) {
            Vec3 pos = player.m_20182_();
            ItemEntity drop = new ItemEntity(player.f_19853_, pos.f_82479_, pos.f_82480_ + 0.5, pos.f_82481_, stack);
            player.f_19853_.m_7967_((Entity)drop);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        double dz;
        double dx;
        double horizontalDistSq;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Level world = player.f_19853_;
        InsideTheSystemModVariables.MapVariables vars = InsideTheSystemModVariables.MapVariables.get((LevelAccessor)world);
        if (vars.AllItems && vars.generated && !vars.chatTriggered && (horizontalDistSq = (dx = player.m_20185_() - vars.x) * dx + (dz = player.m_20189_() - vars.z) * dz) <= 100.0) {
            if (!world.m_5776_()) {
                player.m_213846_((Component)Component.m_237113_((String)"<CoolPlayer303> Well, here we are... I'm really counting on you"));
            }
            vars.chatTriggered = true;
            vars.syncData((LevelAccessor)world);
        }
    }
}

