/*
 * Decompiled with CFR 0.152.
 */
package combat.mamtak.combatSystem;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public final class CombatSystem
extends JavaPlugin
implements Listener,
CommandExecutor,
TabCompleter {
    private final Map<UUID, BukkitTask> tasks = new ConcurrentHashMap<UUID, BukkitTask>();
    private final Map<UUID, UUID> combatWith = new ConcurrentHashMap<UUID, UUID>();
    private int combatTime;

    public void onEnable() {
        this.saveDefaultConfig();
        this.combatTime = this.getConfig().getInt("combat-time", 15);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("combat").setExecutor((CommandExecutor)this);
        this.getCommand("combat").setTabCompleter((TabCompleter)this);
    }

    public void onDisable() {
        this.tasks.values().forEach(BukkitTask::cancel);
        this.tasks.clear();
        this.combatWith.clear();
    }

    @EventHandler
    public void onDamage(EntityDamageByEntityEvent e) {
        if (!(e.getDamager() instanceof Player) || !(e.getEntity() instanceof Player)) {
            return;
        }
        Player attacker = (Player)e.getDamager();
        Player victim = (Player)e.getEntity();
        this.startCombat(attacker, victim.getUniqueId());
        this.startCombat(victim, attacker.getUniqueId());
    }

    private void startCombat(final Player p, UUID oppId) {
        final UUID id = p.getUniqueId();
        boolean already = this.combatWith.containsKey(id);
        if (this.tasks.containsKey(id)) {
            this.tasks.get(id).cancel();
        }
        this.combatWith.put(id, oppId);
        if (!already) {
            Player opp = Bukkit.getPlayer((UUID)oppId);
            String name = opp != null ? opp.getName() : "Unknown";
            p.sendMessage(String.valueOf(ChatColor.RED) + "You are now in combat with " + String.valueOf(ChatColor.GOLD) + name + String.valueOf(ChatColor.RED) + "!");
        }
        BukkitTask t = new BukkitRunnable(){
            int left;
            {
                this.left = CombatSystem.this.combatTime;
            }

            public void run() {
                if (this.left <= 0) {
                    CombatSystem.this.combatWith.remove(id);
                    CombatSystem.this.tasks.remove(id);
                    p.sendMessage(String.valueOf(ChatColor.GREEN) + "You are out of combat! You can now log out.");
                    this.cancel();
                    return;
                }
                p.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(String.valueOf(ChatColor.YELLOW) + "Combat: " + String.valueOf(ChatColor.RED) + this.left + "s"));
                --this.left;
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
        this.tasks.put(id, t);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        if (this.combatWith.containsKey(e.getPlayer().getUniqueId())) {
            e.getPlayer().setHealth(0.0);
        }
    }

    @EventHandler
    public void onCommandPreprocess(PlayerCommandPreprocessEvent e) {
        UUID id = e.getPlayer().getUniqueId();
        if (!this.combatWith.containsKey(id)) {
            return;
        }
        String full = e.getMessage();
        String cmd = full.split(" ")[0];
        if (cmd.equalsIgnoreCase("/combat")) {
            return;
        }
        e.setCancelled(true);
        e.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "You cannot use " + String.valueOf(ChatColor.YELLOW) + cmd + String.valueOf(ChatColor.RED) + " while in combat!");
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player dead = event.getEntity();
        UUID deadId = dead.getUniqueId();
        this.cancelCombat(deadId);
        Player killer = dead.getKiller();
        if (killer != null) {
            this.cancelCombat(killer.getUniqueId());
        }
    }

    public boolean onCommand(CommandSender s, Command cmd, String label, String[] args) {
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (!s.hasPermission("combat.reload")) {
                s.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            this.reloadConfig();
            this.combatTime = this.getConfig().getInt("combat-time", 15);
            s.sendMessage(String.valueOf(ChatColor.GREEN) + "Combat config reloaded. New combat-time: " + String.valueOf(ChatColor.YELLOW) + this.combatTime + "s");
            return true;
        }
        s.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /combat reload");
        return true;
    }

    private void cancelCombat(UUID id) {
        if (this.tasks.containsKey(id)) {
            this.tasks.get(id).cancel();
            this.tasks.remove(id);
        }
        this.combatWith.remove(id);
    }

    public List<String> onTabComplete(CommandSender s, Command cmd, String alias, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("reload").stream().filter(x -> x.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return Arrays.asList(new String[0]);
    }
}

