/*
 * Decompiled with CFR 0.152.
 */
package me.geri.welcomeMat;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.geri.welcomeMat.WelcomeMat;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lme/geri/welcomeMat/ConfigFileWatcher;", "Ljava/lang/Thread;", "main", "Lme/geri/welcomeMat/WelcomeMat;", "<init>", "(Lme/geri/welcomeMat/WelcomeMat;)V", "getMain", "()Lme/geri/welcomeMat/WelcomeMat;", "run", "", "WelcomeMat"})
@SourceDebugExtension(value={"SMAP\nConfigFileWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigFileWatcher.kt\nme/geri/welcomeMat/ConfigFileWatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1869#2,2:42\n*S KotlinDebug\n*F\n+ 1 ConfigFileWatcher.kt\nme/geri/welcomeMat/ConfigFileWatcher\n*L\n19#1:42,2\n*E\n"})
public final class ConfigFileWatcher
extends Thread {
    @NotNull
    private final WelcomeMat main;

    public ConfigFileWatcher(@NotNull WelcomeMat main) {
        Intrinsics.checkNotNullParameter((Object)main, "main");
        this.main = main;
    }

    @NotNull
    public final WelcomeMat getMain() {
        return this.main;
    }

    @Override
    public void run() {
        WatchKey key;
        WatchService watchService = FileSystems.getDefault().newWatchService();
        WatchEvent.Kind[] kindArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY};
        Path.of(this.main.getDataFolder().getAbsolutePath(), new String[0]).register(watchService, kindArray);
        do {
            key = watchService.take();
            List<WatchEvent<?>> list = key.pollEvents();
            Intrinsics.checkNotNullExpressionValue(list, "pollEvents(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WatchEvent event = (WatchEvent)element$iv;
                boolean bl = false;
                WatchEvent.Kind kind = event.kind();
                Object t = event.context();
                Intrinsics.checkNotNull(t, "null cannot be cast to non-null type java.nio.file.Path");
                Path eventPath = (Path)t;
                if (!Intrinsics.areEqual(((Object)eventPath.getFileName()).toString(), "config.yml") || !Intrinsics.areEqual(kind, StandardWatchEventKinds.ENTRY_MODIFY)) continue;
                try {
                    this.main.reloadConfig();
                }
                catch (Exception ex) {
                    this.main.getLogger().severe("Could not reload config.yml");
                    this.main.getLogger().severe("Please check your config.yml");
                    this.main.getLogger().severe("If you are still having this problem, please report it to geri@flacker.net");
                }
            }
        } while (key.reset());
    }
}

