/*
 * Decompiled with CFR 0.152.
 */
package me.geri.welcomeMat;

import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.time.Clock;
import me.geri.welcomeMat.WelcomeMat;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nJ\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\nJ\u0016\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\nJ\u0016\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lme/geri/welcomeMat/UserManager;", "", "main", "Lme/geri/welcomeMat/WelcomeMat;", "<init>", "(Lme/geri/welcomeMat/WelcomeMat;)V", "connection", "Ljava/sql/Connection;", "userCache", "", "", "getUserCache", "()Ljava/util/List;", "getSha256", "value", "bytesToHex", "bytes", "", "changePassword", "", "userName", "password", "deleteUser", "userExists", "", "registerUser", "user", "Lorg/bukkit/entity/Player;", "validateUser", "WelcomeMat"})
public final class UserManager {
    @NotNull
    private final WelcomeMat main;
    private Connection connection;
    @NotNull
    private final List<String> userCache;

    @NotNull
    public final List<String> getUserCache() {
        return this.userCache;
    }

    public UserManager(@NotNull WelcomeMat main) {
        Intrinsics.checkNotNullParameter((Object)main, "main");
        this.userCache = new ArrayList();
        this.main = main;
        if (main.getConfig().getBoolean("database.enabled")) {
            String jdbcUrl = "jdbc:mysql://" + main.getConfig().getString("database.host") + ":" + main.getConfig().getString("database.port") + "/" + main.getConfig().getString("database.database");
            try {
                Class.forName("com.mysql.jdbc.Driver");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            try {
                Connection connection = DriverManager.getConnection(jdbcUrl, main.getConfig().getString("database.user"), main.getConfig().getString("database.password"));
                Intrinsics.checkNotNullExpressionValue(connection, "getConnection(...)");
                this.connection = connection;
            }
            catch (Exception e) {
                main.getLogger().severe("Connection to database could not be established.");
                main.getServer().getPluginManager().disablePlugin((Plugin)main);
                return;
            }
            Connection connection = this.connection;
            if (connection == null) {
                Intrinsics.throwUninitializedPropertyAccessException("connection");
                connection = null;
            }
            PreparedStatement preparedStatement = connection.prepareStatement("select count(*) as 'count' from information_schema.tables where table_schema = ? and table_name = ?");
            Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
            PreparedStatement statement = preparedStatement;
            statement.setString(1, main.getConfig().getString("database.database"));
            statement.setString(2, main.getConfig().getString("database.table"));
            ResultSet rs = statement.executeQuery();
            rs.next();
            if (rs.getInt("count") == 0) {
                Connection connection2 = this.connection;
                if (connection2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("connection");
                    connection2 = null;
                }
                PreparedStatement preparedStatement2 = connection2.prepareStatement("CREATE TABLE if not exists `users` ( `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT, `name` TEXT NOT NULL COLLATE 'utf8mb4_uca1400_ai_ci', `uuid` TEXT NOT NULL COLLATE 'utf8mb4_uca1400_ai_ci', `last_login` INT(10) UNSIGNED NOT NULL DEFAULT '0', `hash` VARCHAR(64) NULL DEFAULT NULL COLLATE 'utf8mb4_uca1400_ai_ci', PRIMARY KEY (`id`) USING BTREE ) COLLATE='utf8mb4_uca1400_ai_ci' ENGINE=InnoDB ;");
                Intrinsics.checkNotNullExpressionValue(preparedStatement2, "prepareStatement(...)");
                PreparedStatement statement2 = preparedStatement2;
                statement2.executeUpdate();
                statement2.close();
            }
            rs.close();
            statement.close();
            Connection connection3 = this.connection;
            if (connection3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("connection");
                connection3 = null;
            }
            PreparedStatement preparedStatement3 = connection3.prepareStatement("select name from users");
            Intrinsics.checkNotNullExpressionValue(preparedStatement3, "prepareStatement(...)");
            PreparedStatement statement3 = preparedStatement3;
            ResultSet rs2 = statement3.executeQuery();
            while (rs2.next()) {
                String string = rs2.getString("name");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                this.userCache.add(string);
            }
            rs2.close();
            statement3.close();
        }
    }

    private final String getSha256(String value) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            String string = value;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            md.update(byArray);
            byte[] byArray2 = md.digest();
            Intrinsics.checkNotNullExpressionValue(byArray2, "digest(...)");
            return this.bytesToHex(byArray2);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private final String bytesToHex(byte[] bytes) {
        StringBuffer result = new StringBuffer();
        for (byte b : bytes) {
            String string = Integer.toString((b & 0xFF) + 256, CharsKt.checkRadix(16));
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String string2 = string.substring(1);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            result.append(string2);
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public final void changePassword(@NotNull String userName, @NotNull String password) {
        Intrinsics.checkNotNullParameter(userName, "userName");
        Intrinsics.checkNotNullParameter(password, "password");
        if (!this.main.getConfig().getBoolean("database.enabled")) {
            Connection connection = DriverManager.getConnection(this.main.getConfig().getString("sqlite_jdbc"));
            Intrinsics.checkNotNullExpressionValue(connection, "getConnection(...)");
            Connection sqliteConnection = connection;
            PreparedStatement preparedStatement = sqliteConnection.prepareStatement("update users set hash = ? where name = ?");
            Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
            PreparedStatement statement = preparedStatement;
            statement.setString(1, this.getSha256(password));
            statement.setString(2, userName);
            statement.executeUpdate();
            statement.close();
            sqliteConnection.close();
            return;
        }
        Connection connection = this.connection;
        if (connection == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connection");
            connection = null;
        }
        PreparedStatement preparedStatement = connection.prepareStatement("update users set hash = ? where name = ?");
        Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
        PreparedStatement statement = preparedStatement;
        statement.setString(1, this.getSha256(password));
        statement.setString(2, userName);
        statement.executeUpdate();
        statement.close();
    }

    public final void deleteUser(@NotNull String userName) {
        Intrinsics.checkNotNullParameter(userName, "userName");
        if (!this.main.getConfig().getBoolean("database.enabled")) {
            Connection connection = DriverManager.getConnection(this.main.getConfig().getString("sqlite_jdbc"));
            Intrinsics.checkNotNullExpressionValue(connection, "getConnection(...)");
            Connection sqliteConnection = connection;
            PreparedStatement preparedStatement = sqliteConnection.prepareStatement("delete from users where name = ?");
            Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
            PreparedStatement statement = preparedStatement;
            statement.setString(1, userName);
            statement.executeUpdate();
            statement.close();
            this.userCache.remove(userName);
            return;
        }
        Connection connection = this.connection;
        if (connection == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connection");
            connection = null;
        }
        PreparedStatement preparedStatement = connection.prepareStatement("delete from users where name = ?");
        Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
        PreparedStatement statement = preparedStatement;
        statement.setString(1, userName);
        statement.executeUpdate();
        statement.close();
        this.userCache.remove(userName);
    }

    public final boolean userExists(@NotNull String userName) {
        Intrinsics.checkNotNullParameter(userName, "userName");
        boolean exists = false;
        if (!this.main.getConfig().getBoolean("database.enabled")) {
            Connection connection = DriverManager.getConnection(this.main.getConfig().getString("sqlite_jdbc"));
            Intrinsics.checkNotNullExpressionValue(connection, "getConnection(...)");
            Connection sqliteConnection = connection;
            PreparedStatement preparedStatement = sqliteConnection.prepareStatement("select iif(count(*) = 1, true, false) as 'exists' from users where name = ?");
            Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
            PreparedStatement statement = preparedStatement;
            statement.setString(1, userName);
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                if (!rs.getBoolean("exists")) continue;
                exists = true;
            }
            statement.close();
            sqliteConnection.close();
            return exists;
        }
        Connection connection = this.connection;
        if (connection == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connection");
            connection = null;
        }
        PreparedStatement preparedStatement = connection.prepareStatement("select count(*) as 'count' from users where name = ?");
        Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
        PreparedStatement statement = preparedStatement;
        statement.setString(1, userName);
        ResultSet rs = statement.executeQuery();
        while (rs.next()) {
            if (rs.getInt("count") != 1) continue;
            exists = true;
        }
        statement.close();
        return exists;
    }

    public final void registerUser(@NotNull Player user, @NotNull String password) {
        Intrinsics.checkNotNullParameter(user, "user");
        Intrinsics.checkNotNullParameter(password, "password");
        if (!this.main.getConfig().getBoolean("database.enabled")) {
            Connection connection = DriverManager.getConnection(this.main.getConfig().getString("sqlite_jdbc"));
            Intrinsics.checkNotNullExpressionValue(connection, "getConnection(...)");
            Connection sqliteConnection = connection;
            PreparedStatement preparedStatement = sqliteConnection.prepareStatement("insert into users (name, uuid, last_login, hash) values (?, ?, ?, ?)");
            Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
            PreparedStatement statement = preparedStatement;
            statement.setString(1, user.getName());
            statement.setString(2, user.getUniqueId().toString());
            statement.setInt(3, (int)Clock.System.INSTANCE.now().getEpochSeconds());
            statement.setString(4, this.getSha256(password));
            statement.executeUpdate();
            statement.close();
            sqliteConnection.close();
            String string = user.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            this.userCache.add(string);
            return;
        }
        Connection connection = this.connection;
        if (connection == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connection");
            connection = null;
        }
        PreparedStatement preparedStatement = connection.prepareStatement("insert into users (name, uuid, last_login, hash) values (?, ?, ?, ?)");
        Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
        PreparedStatement statement = preparedStatement;
        statement.setString(1, user.getName());
        statement.setString(2, user.getUniqueId().toString());
        statement.setInt(3, (int)Clock.System.INSTANCE.now().getEpochSeconds());
        statement.setString(4, this.getSha256(password));
        statement.executeUpdate();
        statement.close();
        String string = user.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        this.userCache.add(string);
    }

    public final boolean validateUser(@NotNull Player user, @NotNull String password) {
        Intrinsics.checkNotNullParameter(user, "user");
        Intrinsics.checkNotNullParameter(password, "password");
        boolean valid = false;
        if (!this.main.getConfig().getBoolean("database.enabled")) {
            Connection connection = DriverManager.getConnection(this.main.getConfig().getString("sqlite_jdbc"));
            Intrinsics.checkNotNullExpressionValue(connection, "getConnection(...)");
            Connection sqliteConnection = connection;
            PreparedStatement preparedStatement = sqliteConnection.prepareStatement("select iif(hash = ?, true, false) as 'valid' from users where name = ?");
            Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
            PreparedStatement statement = preparedStatement;
            statement.setString(1, this.getSha256(password));
            statement.setString(2, user.getName());
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                PreparedStatement statement2;
                if (!rs.getBoolean("valid")) continue;
                valid = true;
                Intrinsics.checkNotNullExpressionValue(sqliteConnection.prepareStatement("update users set last_login = ? where name = ?"), "prepareStatement(...)");
                statement2.setInt(1, (int)Clock.System.INSTANCE.now().getEpochSeconds());
                statement2.setString(2, user.getName());
                statement2.executeUpdate();
                statement2.close();
            }
            statement.close();
            sqliteConnection.close();
        } else {
            Connection connection = this.connection;
            if (connection == null) {
                Intrinsics.throwUninitializedPropertyAccessException("connection");
                connection = null;
            }
            PreparedStatement preparedStatement = connection.prepareStatement("select hash from users where name = ?");
            Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
            PreparedStatement statement = preparedStatement;
            statement.setString(1, user.getName());
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                PreparedStatement statement2;
                if (!Intrinsics.areEqual(rs.getString(1), this.getSha256(password))) continue;
                valid = true;
                Connection connection2 = this.connection;
                if (connection2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("connection");
                    connection2 = null;
                }
                Intrinsics.checkNotNullExpressionValue(connection2.prepareStatement("update users set last_login = ? where name = ?"), "prepareStatement(...)");
                statement2.setInt(1, (int)Clock.System.INSTANCE.now().getEpochSeconds());
                statement2.setString(2, user.getName());
                statement2.executeUpdate();
                statement2.close();
            }
            statement.close();
        }
        return valid;
    }
}

