/*
 * Decompiled with CFR 0.152.
 */
package snownee.pdgamerules;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.pdgamerules.PDGameRulesConfig;
import snownee.pdgamerules.PDGameRulesMod;
import snownee.pdgamerules.mixin.GameRulesValueAccess;

public class PDGameRuleCommand {
    private static final SimpleCommandExceptionType ERROR_OVERWORLD = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.pdgamerules.overworldCheck.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        final LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)Commands.m_82127_((String)"pdgamerule").requires(commandSourceStack -> commandSourceStack.m_6761_(2));
        GameRules.m_46164_((GameRules.GameRuleTypeVisitor)new GameRules.GameRuleTypeVisitor(){

            public <T extends GameRules.Value<T>> void m_6889_(GameRules.Key<T> key, GameRules.Type<T> type) {
                if (!PDGameRulesMod.isSupported(key)) {
                    return;
                }
                try {
                    RequiredArgumentBuilder setNode = PDGameRulesMod.getPlatformNode(key, type);
                    if (setNode == null) {
                        setNode = type.m_46358_("value");
                    }
                    literalArgumentBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)key.m_46328_()).executes(commandContext -> PDGameRuleCommand.queryRule((CommandSourceStack)commandContext.getSource(), key))).then(setNode.executes(commandContext -> PDGameRuleCommand.setRule((CommandContext<CommandSourceStack>)commandContext, key)))).then(Commands.m_82127_((String)"clear!").executes(commandContext -> PDGameRuleCommand.clearRule((CommandContext<CommandSourceStack>)commandContext, key))));
                }
                catch (Exception e) {
                    PDGameRulesMod.LOGGER.error("Failed to register command for " + key.m_46328_(), (Throwable)e);
                }
            }
        });
        commandDispatcher.register(literalArgumentBuilder);
    }

    static <T extends GameRules.Value<T>> int setRule(CommandContext<CommandSourceStack> commandContext, GameRules.Key<T> key) throws CommandSyntaxException {
        CommandSourceStack commandSourceStack = (CommandSourceStack)commandContext.getSource();
        PDGameRuleCommand.checkOverworld(commandSourceStack, key);
        GameRules.Value value = ((GameRulesValueAccess)commandSourceStack.m_81372_().m_46469_().m_46170_(key)).getType().m_46352_();
        value.m_46370_(commandContext, "value");
        String dimension = commandSourceStack.m_81372_().m_46472_().m_135782_().toString();
        Map map = PDGameRulesConfig.rules.computeIfAbsent(dimension, k -> Maps.newHashMap());
        String serialized = value.m_5831_();
        map.put(key.m_46328_(), serialized);
        KiwiConfigManager.getHandler(PDGameRulesConfig.class).save();
        PDGameRulesMod.onPDRuleChange(commandSourceStack.m_81372_(), key, serialized);
        commandSourceStack.m_288197_(() -> Component.m_237110_((String)"commands.gamerule.set", (Object[])new Object[]{key.m_46328_(), value.toString()}), true);
        return value.m_6855_();
    }

    static <T extends GameRules.Value<T>> int clearRule(CommandContext<CommandSourceStack> commandContext, GameRules.Key<T> key) throws CommandSyntaxException {
        CommandSourceStack commandSourceStack = (CommandSourceStack)commandContext.getSource();
        PDGameRuleCommand.checkOverworld(commandSourceStack, key);
        String dimension = commandSourceStack.m_81372_().m_46472_().m_135782_().toString();
        Map<String, Object> map = PDGameRulesConfig.rules.get(dimension);
        if (map == null || !map.containsKey(key.m_46328_())) {
            commandSourceStack.m_81352_((Component)Component.m_237110_((String)"commands.pdgamerules.clear.failed", (Object[])new Object[]{key.m_46328_()}));
            return 0;
        }
        map.remove(key.m_46328_());
        KiwiConfigManager.getHandler(PDGameRulesConfig.class).save();
        PDGameRulesMod.onPDRuleChange(commandSourceStack.m_81372_(), key, null);
        commandSourceStack.m_288197_(() -> Component.m_237110_((String)"commands.pdgamerules.clear", (Object[])new Object[]{key.m_46328_()}), true);
        return 1;
    }

    static <T extends GameRules.Value<T>> int queryRule(CommandSourceStack commandSourceStack, GameRules.Key<T> key) throws CommandSyntaxException {
        PDGameRuleCommand.checkOverworld(commandSourceStack, key);
        GameRules.Value value = commandSourceStack.m_81372_().m_46469_().m_46170_(key);
        commandSourceStack.m_288197_(() -> Component.m_237110_((String)"commands.gamerule.query", (Object[])new Object[]{key.m_46328_(), value.toString()}), false);
        return value.m_6855_();
    }

    static void checkOverworld(CommandSourceStack source, GameRules.Key<?> key) throws CommandSyntaxException {
        if (source.m_81372_().m_46472_() == Level.f_46428_ && !PDGameRulesMod.canUseInOverworld(key)) {
            throw ERROR_OVERWORLD.create();
        }
    }
}

