/*
 * Decompiled with CFR 0.152.
 */
package snownee.pdgamerules;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.pdgamerules.PDGameRulesConfig;
import snownee.pdgamerules.PDGameRulesMod;
import snownee.pdgamerules.mixin.GameRulesAccess;
import snownee.pdgamerules.mixin.GameRulesValueAccess;

public class PDGameRules
extends GameRules {
    private final GameRules parent;
    private final String dimension;
    private final boolean overworld;
    private final Cache<GameRules.Key<?>, GameRules.Value<?>> cache = CacheBuilder.newBuilder().build();

    public PDGameRules(GameRules parent, ResourceKey<Level> dimension) {
        this.parent = parent;
        this.dimension = dimension.m_135782_().toString();
        this.overworld = dimension == Level.f_46428_;
        ((GameRulesAccess)((Object)this)).setRules(Map.of());
    }

    public <T extends GameRules.Value<T>> T m_46170_(GameRules.Key<T> key) {
        try {
            return (T)((GameRules.Value)this.cache.get(key, () -> {
                Map rules = PDGameRulesConfig.rules.getOrDefault(this.dimension, Map.of());
                Object value = rules.get(key.m_46328_());
                if (value == null) {
                    return this.parent.m_46170_(key);
                }
                if (this.overworld && !PDGameRulesMod.canUseInOverworld(key)) {
                    PDGameRulesConfig.rules.get(this.dimension).remove(key.m_46328_());
                    KiwiConfigManager.getHandler(PDGameRulesConfig.class).save();
                    return this.parent.m_46170_(key);
                }
                GameRulesValueAccess rule = (GameRulesValueAccess)this.parent.m_46170_(key);
                rule = (GameRulesValueAccess)rule.getType().m_46352_();
                rule.callDeserialize(String.valueOf(value));
                return (GameRules.Value)rule;
            }));
        }
        catch (Exception exception) {
            return (T)this.parent.m_46170_(key);
        }
    }

    public void invalidate() {
        this.cache.invalidateAll();
    }

    public void m_46176_(GameRules rules, @Nullable MinecraftServer server) {
        this.parent.m_46176_(rules, server);
    }

    public GameRules m_46202_() {
        return this.parent.m_46202_();
    }

    public CompoundTag m_46163_() {
        return this.parent.m_46163_();
    }
}

