/*
 * Decompiled with CFR 0.152.
 */
package snownee.pdgamerules;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.logging.LogUtils;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.LevelData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import snownee.pdgamerules.PDGameRuleCommand;
import snownee.pdgamerules.duck.PDDerivedLevelData;

@Mod(value="pdgamerules")
public class PDGameRulesMod {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Set<GameRules.Key<?>> UNSUPPORTED_GAME_RULES = Sets.newHashSet();
    public static final Set<GameRules.Key<?>> UNSUPPORTED_GAME_RULES_OVERWORLD = Sets.newHashSet();
    private static int generation = 0;

    public PDGameRulesMod() {
        UNSUPPORTED_GAME_RULES.add(GameRules.f_46144_);
        UNSUPPORTED_GAME_RULES.add(GameRules.f_46152_);
        UNSUPPORTED_GAME_RULES.add(GameRules.f_46145_);
        UNSUPPORTED_GAME_RULES_OVERWORLD.add(GameRules.f_46140_);
        UNSUPPORTED_GAME_RULES_OVERWORLD.add(GameRules.f_46150_);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
    }

    private void registerCommands(RegisterCommandsEvent event) {
        PDGameRuleCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static boolean isSupported(GameRules.Key<?> key) {
        return !UNSUPPORTED_GAME_RULES.contains(key);
    }

    public static boolean canUseInOverworld(GameRules.Key<?> key) {
        return !UNSUPPORTED_GAME_RULES_OVERWORLD.contains(key);
    }

    public static int getGeneration() {
        return generation;
    }

    public static void iterateGeneration() {
        ++generation;
    }

    public static void onPDRuleChange(ServerLevel level, GameRules.Key<?> key, @Nullable String value) {
        LevelData levelData;
        if ((key == GameRules.f_46140_ || key == GameRules.f_46150_) && (levelData = level.m_6106_()) instanceof PDDerivedLevelData) {
            PDDerivedLevelData data = (PDDerivedLevelData)levelData;
            if (key == GameRules.f_46140_) {
                data.pdgamerules$setIndependentDayTime(value != null);
            } else {
                data.pdgamerules$setIndependentWeather(value != null);
            }
        }
        PDGameRulesMod.iterateGeneration();
    }

    public static <T extends GameRules.Value<T>, E extends Enum<E>> RequiredArgumentBuilder<CommandSourceStack, ?> getPlatformNode(GameRules.Key<T> key, GameRules.Type<T> type) {
        return null;
    }
}

