/*
 * Decompiled with CFR 0.152.
 */
package snownee.pdgamerules;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Map;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.pdgamerules.PDGameRulesConfig;
import snownee.pdgamerules.PDGameRulesMod;
import snownee.pdgamerules.mixin.GameRulesValueAccess;

public class PDGameRuleCommand {
    private static final SimpleCommandExceptionType ERROR_OVERWORLD = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.pdgamerules.overworldCheck.failed"));

    public static void register(CommandDispatcher<class_2168> commandDispatcher) {
        final LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)class_2170.method_9247((String)"pdgamerule").requires(commandSourceStack -> commandSourceStack.method_9259(2));
        class_1928.method_20744((class_1928.class_4311)new class_1928.class_4311(){

            public <T extends class_1928.class_4315<T>> void method_20762(class_1928.class_4313<T> key, class_1928.class_4314<T> type) {
                if (!PDGameRulesMod.isSupported(key)) {
                    return;
                }
                try {
                    RequiredArgumentBuilder setNode = PDGameRulesMod.getPlatformNode(key, type);
                    if (setNode == null) {
                        setNode = type.method_20775("value");
                    }
                    literalArgumentBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)key.method_20771()).executes(commandContext -> PDGameRuleCommand.queryRule((class_2168)commandContext.getSource(), key))).then(setNode.executes(commandContext -> PDGameRuleCommand.setRule((CommandContext<class_2168>)commandContext, key)))).then(class_2170.method_9247((String)"clear!").executes(commandContext -> PDGameRuleCommand.clearRule((CommandContext<class_2168>)commandContext, key))));
                }
                catch (Exception e) {
                    PDGameRulesMod.LOGGER.error("Failed to register command for " + key.method_20771(), (Throwable)e);
                }
            }
        });
        commandDispatcher.register(literalArgumentBuilder);
    }

    static <T extends class_1928.class_4315<T>> int setRule(CommandContext<class_2168> commandContext, class_1928.class_4313<T> key) throws CommandSyntaxException {
        class_2168 commandSourceStack = (class_2168)commandContext.getSource();
        PDGameRuleCommand.checkOverworld(commandSourceStack, key);
        class_1928.class_4315 value = ((GameRulesValueAccess)commandSourceStack.method_9225().method_8450().method_20746(key)).getType().method_20773();
        value.method_20780(commandContext, "value");
        String dimension = commandSourceStack.method_9225().method_27983().method_29177().toString();
        Map map = PDGameRulesConfig.rules.computeIfAbsent(dimension, k -> Maps.newHashMap());
        String serialized = value.method_20779();
        map.put(key.method_20771(), serialized);
        KiwiConfigManager.getHandler(PDGameRulesConfig.class).save();
        PDGameRulesMod.onPDRuleChange(commandSourceStack.method_9225(), key, serialized);
        commandSourceStack.method_9226(() -> class_2561.method_43469((String)"commands.gamerule.set", (Object[])new Object[]{key.method_20771(), value.toString()}), true);
        return value.method_20781();
    }

    static <T extends class_1928.class_4315<T>> int clearRule(CommandContext<class_2168> commandContext, class_1928.class_4313<T> key) throws CommandSyntaxException {
        class_2168 commandSourceStack = (class_2168)commandContext.getSource();
        PDGameRuleCommand.checkOverworld(commandSourceStack, key);
        String dimension = commandSourceStack.method_9225().method_27983().method_29177().toString();
        Map<String, Object> map = PDGameRulesConfig.rules.get(dimension);
        if (map == null || !map.containsKey(key.method_20771())) {
            commandSourceStack.method_9213((class_2561)class_2561.method_43469((String)"commands.pdgamerules.clear.failed", (Object[])new Object[]{key.method_20771()}));
            return 0;
        }
        map.remove(key.method_20771());
        KiwiConfigManager.getHandler(PDGameRulesConfig.class).save();
        PDGameRulesMod.onPDRuleChange(commandSourceStack.method_9225(), key, null);
        commandSourceStack.method_9226(() -> class_2561.method_43469((String)"commands.pdgamerules.clear", (Object[])new Object[]{key.method_20771()}), true);
        return 1;
    }

    static <T extends class_1928.class_4315<T>> int queryRule(class_2168 commandSourceStack, class_1928.class_4313<T> key) throws CommandSyntaxException {
        PDGameRuleCommand.checkOverworld(commandSourceStack, key);
        class_1928.class_4315 value = commandSourceStack.method_9225().method_8450().method_20746(key);
        commandSourceStack.method_9226(() -> class_2561.method_43469((String)"commands.gamerule.query", (Object[])new Object[]{key.method_20771(), value.toString()}), false);
        return value.method_20781();
    }

    static void checkOverworld(class_2168 source, class_1928.class_4313<?> key) throws CommandSyntaxException {
        if (source.method_9225().method_27983() == class_1937.field_25179 && !PDGameRulesMod.canUseInOverworld(key)) {
            throw ERROR_OVERWORLD.create();
        }
    }
}

