/*
 * Decompiled with CFR 0.152.
 */
package snownee.pdgamerules;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.pdgamerules.PDGameRulesConfig;
import snownee.pdgamerules.PDGameRulesMod;
import snownee.pdgamerules.mixin.GameRulesAccess;
import snownee.pdgamerules.mixin.GameRulesValueAccess;

public class PDGameRules
extends class_1928 {
    private final class_1928 parent;
    private final String dimension;
    private final boolean overworld;
    private final Cache<class_1928.class_4313<?>, class_1928.class_4315<?>> cache = CacheBuilder.newBuilder().build();

    public PDGameRules(class_1928 parent, class_5321<class_1937> dimension) {
        this.parent = parent;
        this.dimension = dimension.method_29177().toString();
        this.overworld = dimension == class_1937.field_25179;
        ((GameRulesAccess)((Object)this)).setRules(Map.of());
    }

    @NotNull
    public <T extends class_1928.class_4315<T>> T method_20746(class_1928.class_4313<T> key) {
        try {
            return (T)((class_1928.class_4315)this.cache.get(key, () -> {
                Map rules = PDGameRulesConfig.rules.getOrDefault(this.dimension, Map.of());
                Object value = rules.get(key.method_20771());
                if (value == null) {
                    return this.parent.method_20746(key);
                }
                if (this.overworld && !PDGameRulesMod.canUseInOverworld(key)) {
                    PDGameRulesConfig.rules.get(this.dimension).remove(key.method_20771());
                    KiwiConfigManager.getHandler(PDGameRulesConfig.class).save();
                    return this.parent.method_20746(key);
                }
                GameRulesValueAccess rule = (GameRulesValueAccess)this.parent.method_20746(key);
                rule = (GameRulesValueAccess)rule.getType().method_20773();
                rule.callDeserialize(String.valueOf(value));
                return (class_1928.class_4315)rule;
            }));
        }
        catch (Exception exception) {
            return (T)this.parent.method_20746(key);
        }
    }

    public void invalidate() {
        this.cache.invalidateAll();
    }

    public void method_27322(class_1928 rules, @Nullable MinecraftServer server) {
        this.parent.method_27322(rules, server);
    }

    @NotNull
    public class_1928 method_27325() {
        return this.parent.method_27325();
    }

    @NotNull
    public class_2487 method_8358() {
        return this.parent.method_8358();
    }
}

