/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage;

import com.simibubi.create.foundation.data.CreateRegistrate;
import java.util.Objects;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.fxnt.fxntstorage.backpack.main.BackpackScreen;
import net.fxnt.fxntstorage.backpack.renderer.BackpackRenderPlayer;
import net.fxnt.fxntstorage.backpack.tooltip.BackpackClientTooltip;
import net.fxnt.fxntstorage.backpack.tooltip.BackpackTooltip;
import net.fxnt.fxntstorage.backpack.upgrade.JetpackAirOverlay;
import net.fxnt.fxntstorage.compat.constructionwand.ConstructionWandCompat;
import net.fxnt.fxntstorage.compat.everycomp.EveryCompCompat;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.container.StorageBoxEntityRenderer;
import net.fxnt.fxntstorage.container.StorageBoxScreen;
import net.fxnt.fxntstorage.container.mounted.StorageBoxMountedScreen;
import net.fxnt.fxntstorage.init.ModBlockEntities;
import net.fxnt.fxntstorage.init.ModBlocks;
import net.fxnt.fxntstorage.init.ModItems;
import net.fxnt.fxntstorage.init.ModLootConditionTypes;
import net.fxnt.fxntstorage.init.ModMenuTypes;
import net.fxnt.fxntstorage.init.ModNetwork;
import net.fxnt.fxntstorage.init.ModRecipes;
import net.fxnt.fxntstorage.init.ModTabs;
import net.fxnt.fxntstorage.init.ModUnpackers;
import net.fxnt.fxntstorage.passer.PasserEntityRenderer;
import net.fxnt.fxntstorage.ponder.CsPonderPlugin;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxEntityRenderer;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxScreen;
import net.fxnt.fxntstorage.simple_storage.mounted.SimpleStorageBoxMountedScreen;
import net.fxnt.fxntstorage.util.KeybindHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="fxntstorage")
public class FXNTStorage {
    public static final String MOD_ID = "fxntstorage";
    public static final Logger LOGGER = LogManager.getLogger(FXNTStorage.class);
    public static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"fxntstorage");
    public static boolean curiosLoaded;

    public FXNTStorage(FMLJavaModLoadingContext context) {
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigManager.ClientConfig.CLIENT_SPEC);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigManager.CommonConfig.COMMON_SPEC);
        IEventBus modEventBus = context.getModEventBus();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(FXNTStorage::registerTooltipComponent);
        }
        ModBlocks.register();
        ModBlockEntities.register();
        ModItems.register();
        ModRecipes.register(modEventBus);
        ModTabs.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModLootConditionTypes.register(modEventBus);
        REGISTRATE.registerEventListeners(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(FXNTStorage::onCommonSetup);
        curiosLoaded = ModList.get().isLoaded("curios");
        if (ModList.get().isLoaded("constructionwand")) {
            ConstructionWandCompat.init();
        }
        if (ModList.get().isLoaded("everycomp")) {
            EveryCompCompat.init();
        }
    }

    private static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModNetwork.registerCommonPackets();
            ModUnpackers.registerHandlers();
        });
    }

    private static void registerTooltipComponent(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(BackpackTooltip.class, BackpackClientTooltip::new);
    }

    public static ResourceLocation modLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    @Mod.EventBusSubscriber(modid="fxntstorage", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onConfigReload(ModConfigEvent.Reloading event) {
            if (Objects.equals(event.getConfig().getModId(), FXNTStorage.MOD_ID) && event.getConfig().getType().equals((Object)ModConfig.Type.CLIENT) && Minecraft.m_91087_().m_91403_() != null && Minecraft.m_91087_().f_91074_ != null) {
                ConfigManager.ClientConfig.sendSettings((Player)Minecraft.m_91087_().f_91074_);
            }
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.SIMPLE_STORAGE_BOX_MENU.get()), SimpleStorageBoxScreen::createScreen);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.SIMPLE_STORAGE_BOX_MOUNTED_MENU.get()), SimpleStorageBoxMountedScreen::createScreen);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.STORAGE_BOX_MENU.get()), StorageBoxScreen::createScreen);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.STORAGE_BOX_MOUNTED_MENU.get()), StorageBoxMountedScreen::createScreen);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.BACKPACK_ITEM_MENU.get()), BackpackScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.BACKPACK_BLOCK_MENU.get()), BackpackScreen::new);
            PonderIndex.addPlugin((PonderPlugin)new CsPonderPlugin());
        }

        @SubscribeEvent
        public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
            ClientModEvents.addPlayerLayer(event, "default");
            ClientModEvents.addPlayerLayer(event, "slim");
        }

        private static void addPlayerLayer(EntityRenderersEvent.AddLayers event, String skinType) {
            PlayerRenderer playerRenderer = (PlayerRenderer)event.getSkin(skinType);
            if (playerRenderer != null) {
                playerRenderer.m_115326_((RenderLayer)new BackpackRenderPlayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)playerRenderer));
            }
        }

        @SubscribeEvent
        public static void registerEntityRenderer(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.STORAGE_BOX_ENTITY.get(), StorageBoxEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.SIMPLE_STORAGE_BOX_ENTITY.get(), SimpleStorageBoxEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.SMART_PASSER_ENTITY.get(), PasserEntityRenderer::new);
        }

        @SubscribeEvent
        public static void onKeyRegister(RegisterKeyMappingsEvent event) {
            event.register(KeybindHandler.TOGGLE_BACKPACK_KEY);
            event.register(KeybindHandler.TOGGLE_JETPACK_HOVER_KEY);
            event.register(KeybindHandler.CLEAR_BACKPACK_SHAPE_CACHE);
            event.register(KeybindHandler.OREMINE_ANY_BLOCK);
        }

        @SubscribeEvent
        public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
            event.registerAbove(VanillaGuiOverlay.AIR_LEVEL.id(), "remaining_air", (IGuiOverlay)JetpackAirOverlay.INSTANCE);
        }
    }
}

