/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack;

import io.netty.buffer.Unpooled;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fxnt.fxntstorage.backpack.BackpackBlock;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.backpack.main.BackpackBlockMenu;
import net.fxnt.fxntstorage.backpack.main.IBackpackContainer;
import net.fxnt.fxntstorage.backpack.upgrade.BackpackAsBlockUpgradeHandler;
import net.fxnt.fxntstorage.init.ModBlocks;
import net.fxnt.fxntstorage.init.ModNetwork;
import net.fxnt.fxntstorage.item.upgrades.UpgradeItem;
import net.fxnt.fxntstorage.network.packet.SetSortOrderPacket;
import net.fxnt.fxntstorage.util.SortOrder;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class BackpackEntity
extends BlockEntity
implements IBackpackContainer,
MenuProvider,
Nameable {
    private int slotCount;
    private final BlockPos pos;
    private int lastTick = 0;
    private boolean doTick = false;
    private Component customName;
    private boolean initializedBlock = false;
    private boolean isGhostSlotLocked = false;
    private final Block block;
    public int stackMultiplier;
    private SortOrder sortOrder;
    public NonNullList<String> upgrades = NonNullList.m_122779_();
    public boolean isPlayerInteraction = false;
    private final ItemStackHandler itemHandler;
    private LazyOptional<IItemHandlerModifiable> lazyItemHandler = LazyOptional.empty();
    private final int GHOST_SLOT;

    public BackpackEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.pos = pPos;
        this.block = pBlockState.m_60734_();
        this.sortOrder = SortOrder.COUNT;
        Block block = this.block;
        if (block instanceof BackpackBlock) {
            BackpackBlock backpackBlock = (BackpackBlock)block;
            this.stackMultiplier = backpackBlock.getStackMultiplier();
            this.slotCount = BackpackBlock.getSlotCount();
        }
        this.itemHandler = this.createItemHandler();
        this.GHOST_SLOT = this.itemHandler.getSlots() - 1;
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(this.slotCount + 1){

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (BackpackEntity.this.isPlayerInteraction || slot < Util.ITEM_SLOT_END_RANGE) {
                    return super.extractItem(slot, amount, simulate);
                }
                return ItemStack.f_41583_;
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                if (BackpackEntity.filterTest(stack)) {
                    return false;
                }
                if (BackpackEntity.this.isPlayerInteraction) {
                    return true;
                }
                if (slot != BackpackEntity.this.GHOST_SLOT || !BackpackEntity.this.itemHandler.getStackInSlot(BackpackEntity.this.GHOST_SLOT).m_41619_() || BackpackEntity.this.isGhostSlotLocked) {
                    return false;
                }
                return BackpackEntity.this.hasEmptyOrNonMaxSlot(stack);
            }

            public CompoundTag serializeNBT() {
                ListTag nbtTagList = new ListTag();
                for (int i = 0; i < this.stacks.size(); ++i) {
                    if (((ItemStack)this.stacks.get(i)).m_41619_()) continue;
                    CompoundTag itemTag = new CompoundTag();
                    itemTag.m_128405_("Slot", i);
                    itemTag.m_128405_("ActualCount", ((ItemStack)this.stacks.get(i)).m_41613_());
                    ((ItemStack)this.stacks.get(i)).m_41739_(itemTag);
                    nbtTagList.add((Object)itemTag);
                }
                CompoundTag nbt = new CompoundTag();
                nbt.m_128365_("Items", (Tag)nbtTagList);
                nbt.m_128405_("Size", this.stacks.size());
                return nbt;
            }

            public void deserializeNBT(CompoundTag nbt) {
                this.setSize(nbt.m_128425_("Size", 3) ? nbt.m_128451_("Size") : this.stacks.size());
                ListTag tagList = nbt.m_128437_("Items", 10);
                for (int i = 0; i < tagList.size(); ++i) {
                    CompoundTag itemTags = tagList.m_128728_(i);
                    int slot = itemTags.m_128451_("Slot");
                    ItemStack slotStack = ItemStack.m_41712_((CompoundTag)itemTags);
                    if (itemTags.m_128425_("ActualCount", 3)) {
                        slotStack.m_41764_(itemTags.m_128451_("ActualCount"));
                    }
                    this.stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags).m_255036_(slotStack.m_41613_()));
                }
                this.onLoad();
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                BackpackEntity.this.m_6596_();
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        if (this.m_58904_() != null && this.m_58904_().f_46443_) {
            this.m_6596_();
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public NonNullList<String> getUpgrades() {
        return this.upgrades;
    }

    public void setCustomName(Component hoverName) {
        this.customName = hoverName;
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    @NotNull
    public Component m_7755_() {
        return this.m_5446_();
    }

    @NotNull
    public Component m_5446_() {
        if (this.customName != null) {
            return this.customName;
        }
        Level blockLevel = this.f_58857_;
        if (blockLevel != null) {
            return this.block.m_7397_((BlockGetter)this.f_58857_, this.pos, this.m_58900_()).m_41786_();
        }
        return new ItemStack((ItemLike)ModBlocks.BACKPACK.get()).m_41786_();
    }

    public void setData(int slotCount, int maxStackSize) {
        this.slotCount = slotCount;
        this.stackMultiplier = maxStackSize;
    }

    public void m_142466_(CompoundTag tag) {
        int i;
        super.m_142466_(tag);
        if (tag.m_128441_("Items")) {
            ListTag listTag = tag.m_128469_("Items").m_128437_("Items", 10);
            for (i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundTag = listTag.m_128728_(i);
                int slot = compoundTag.m_128445_("Slot") & 0xFF;
                ItemStack slotStack = ItemStack.m_41712_((CompoundTag)compoundTag);
                if (compoundTag.m_128425_("ActualCount", 3)) {
                    slotStack.m_41764_(compoundTag.m_128451_("ActualCount"));
                }
                if (slot >= this.itemHandler.getSlots()) continue;
                this.itemHandler.setStackInSlot(slot, slotStack);
            }
        }
        if (tag.m_128441_("Upgrades")) {
            this.upgrades.clear();
            ListTag upgradesList = tag.m_128437_("Upgrades", 8);
            for (i = 0; i < upgradesList.size(); ++i) {
                this.upgrades.add(i, (Object)upgradesList.m_128778_(i));
            }
        }
        if (tag.m_128441_("StackMultiplier")) {
            this.stackMultiplier = tag.m_128451_("StackMultiplier");
        }
        if (tag.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
        this.sortOrder = tag.m_128425_("SortOrder", 8) ? SortOrder.valueOf(tag.m_128461_("SortOrder")) : SortOrder.COUNT;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Items", (Tag)this.itemHandler.serializeNBT());
        ListTag upgradesList = new ListTag();
        for (int i = 0; i < this.upgrades.size(); ++i) {
            upgradesList.add(i, (Tag)StringTag.m_129297_((String)((String)this.upgrades.get(i))));
        }
        tag.m_128365_("Upgrades", (Tag)upgradesList);
        tag.m_128405_("StackMultiplier", this.stackMultiplier);
        if (this.customName != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        tag.m_128359_("SortOrder", this.sortOrder.name());
    }

    public ItemStack saveToItemStack(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("BlockEntityTag");
        this.m_183515_(tag);
        if (this.customName != null) {
            CompoundTag displayTag = stack.m_41698_("display");
            displayTag.m_128359_("Name", Component.Serializer.m_130703_((Component)this.customName));
        }
        return stack;
    }

    public void refreshUpgrades() {
        this.upgrades.clear();
        int UPGRADE_SLOT_START_INDEX = 132;
        int UPGRADE_SLOT_END_INDEX = UPGRADE_SLOT_START_INDEX + 6;
        for (int i = UPGRADE_SLOT_START_INDEX; i < UPGRADE_SLOT_END_INDEX; ++i) {
            UpgradeItem upgradeItem;
            String upgradeName;
            ItemStack itemStack = this.itemHandler.getStackInSlot(i);
            Item item = itemStack.m_41720_();
            if (!(item instanceof UpgradeItem) || this.upgrades.contains((Object)(upgradeName = (upgradeItem = (UpgradeItem)item).getUpgradeName()))) continue;
            this.upgrades.add((Object)upgradeName);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.m_142466_(tag);
    }

    private boolean hasEmptyOrNonMaxSlot(ItemStack pStack) {
        for (int i = 0; i < Util.ITEM_SLOT_END_RANGE; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (!stack.m_41619_() && (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)pStack) || stack.m_41613_() >= this.stackMultiplier * pStack.m_41741_())) continue;
            return true;
        }
        return false;
    }

    public static boolean filterTest(ItemStack stack) {
        return stack.m_41720_() instanceof BackpackItem;
    }

    public void serverTick(Level level) {
        if (!level.f_46443_) {
            this.moveItems();
            ++this.lastTick;
            int updateEveryXTicks = 30;
            if (this.lastTick >= updateEveryXTicks) {
                this.lastTick = 0;
                this.doTick = true;
            }
            if (!this.doTick) {
                return;
            }
            if (!this.initializedBlock) {
                level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
                this.initializedBlock = true;
            }
            if (this.upgrades.contains((Object)"backpack_magnet_upgrade")) {
                BackpackAsBlockUpgradeHandler upgradeHandler = new BackpackAsBlockUpgradeHandler(this);
                upgradeHandler.applyMagnetUpgrade();
            }
            this.doTick = false;
        }
    }

    public void moveItems() {
        ItemStack ghostSlot = this.itemHandler.getStackInSlot(this.GHOST_SLOT);
        if (ghostSlot.m_41619_()) {
            return;
        }
        this.isGhostSlotLocked = true;
        for (int i = 0; i < Util.ITEM_SLOT_END_RANGE; ++i) {
            ItemStack mergeSlot = this.itemHandler.getStackInSlot(i);
            if (mergeSlot.m_41619_()) {
                this.doMove(i, mergeSlot, ghostSlot);
                break;
            }
            if (!ItemStack.m_150942_((ItemStack)mergeSlot, (ItemStack)ghostSlot) || mergeSlot.m_41613_() >= this.stackMultiplier * ghostSlot.m_41741_()) continue;
            this.doMove(i, mergeSlot, ghostSlot);
            break;
        }
    }

    private void doMove(int mergeSlotId, ItemStack mergeStack, ItemStack ghostStack) {
        if (mergeStack.m_41619_()) {
            this.itemHandler.setStackInSlot(mergeSlotId, ghostStack.m_41777_());
            ghostStack.m_41774_(ghostStack.m_41613_());
        } else {
            int mergeSlotFreeSpace = this.stackMultiplier * mergeStack.m_41741_() - mergeStack.m_41613_();
            int amountToMove = Math.min(ghostStack.m_41613_(), mergeSlotFreeSpace);
            mergeStack.m_41769_(amountToMove);
            ghostStack.m_41774_(amountToMove);
        }
        this.m_6596_();
        this.isGhostSlotLocked = false;
    }

    @Override
    public int getStackMultiplier() {
        return this.stackMultiplier;
    }

    @Override
    public void setPlayerInteraction(boolean isPlayer) {
        this.isPlayerInteraction = isPlayer;
    }

    @Override
    public void setDataChanged() {
        this.m_6596_();
    }

    public void m_6596_() {
        this.refreshUpgrades();
        super.m_6596_();
    }

    @Override
    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public void setTag(CompoundTag tag) {
    }

    @Override
    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public void setSortOrder(SortOrder order) {
        this.sortOrder = order;
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            ModNetwork.sendToServer(new SetSortOrderPacket(this.sortOrder));
        }
        this.m_6596_();
    }

    public int calcRedstoneFromInventory() {
        int itemsFound = 0;
        float proportion = 0.0f;
        for (int i = 0; i < Util.ITEM_SLOT_END_RANGE; ++i) {
            ItemStack itemstack = this.itemHandler.getStackInSlot(i);
            if (itemstack.m_41619_()) continue;
            proportion += (float)itemstack.m_41613_() / (float)(itemstack.m_41741_() * this.stackMultiplier);
            ++itemsFound;
        }
        return Mth.m_14143_((float)((proportion /= (float)Util.ITEM_SLOT_END_RANGE) * 14.0f)) + (itemsFound > 0 ? 1 : 0);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        FriendlyByteBuf extraData = new FriendlyByteBuf(Unpooled.buffer());
        extraData.m_130064_(this.pos);
        return new BackpackBlockMenu(pContainerId, pPlayerInventory, extraData);
    }
}

