/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.main;

import java.util.ArrayList;
import java.util.List;
import net.fxnt.fxntstorage.backpack.BackpackBlock;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.backpack.main.IBackpackContainer;
import net.fxnt.fxntstorage.init.ModNetwork;
import net.fxnt.fxntstorage.item.upgrades.UpgradeItem;
import net.fxnt.fxntstorage.network.packet.SetSortOrderPacket;
import net.fxnt.fxntstorage.network.packet.SyncNBTDataPacket;
import net.fxnt.fxntstorage.util.SortOrder;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackpackContainer
implements IBackpackContainer,
ICapabilityProvider,
IItemHandlerModifiable {
    private final int CONTAINER_SIZE = BackpackBlock.getSlotCount();
    private final Player player;
    private int stackMultiplier;
    private final ItemStack stack;
    private final ItemStackHandler itemHandler = new ItemStackHandler(this.CONTAINER_SIZE);
    private final LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    private final NonNullList<String> upgrades = NonNullList.m_122779_();
    private SortOrder sortOrder = SortOrder.COUNT;

    public BackpackContainer(ItemStack itemStack, Player player) {
        BackpackItem backpackItem;
        this.player = player;
        this.stack = itemStack;
        Item item = itemStack.m_41720_();
        if (item instanceof BackpackItem && (item = (backpackItem = (BackpackItem)item).m_40614_()) instanceof BackpackBlock) {
            BackpackBlock backpackBlock = (BackpackBlock)item;
            this.stackMultiplier = backpackBlock.getStackMultiplier();
        }
        this.loadItemsFromStack(itemStack);
    }

    @Override
    public void setTag(CompoundTag tag) {
        if (!this.player.m_9236_().f_46443_) {
            return;
        }
        this.stack.m_41751_(tag);
    }

    public void loadItemsFromStack(ItemStack itemStack) {
        CompoundTag blockEntityTag = itemStack.m_41737_("BlockEntityTag");
        if (blockEntityTag != null && blockEntityTag.m_128441_("Items")) {
            ListTag listTag = blockEntityTag.m_128469_("Items").m_128437_("Items", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag tag = listTag.m_128728_(i);
                int slot = tag.m_128445_("Slot") & 0xFF;
                ItemStack slotStack = ItemStack.m_41712_((CompoundTag)tag);
                if (tag.m_128425_("ActualCount", 3)) {
                    int actualCount = tag.m_128451_("ActualCount");
                    slotStack.m_41764_(Math.max(actualCount, 0));
                }
                if (slot >= this.itemHandler.getSlots()) continue;
                this.itemHandler.setStackInSlot(slot, slotStack);
            }
            this.upgrades.clear();
            ListTag upgradesList = blockEntityTag.m_128437_("Upgrades", 8);
            for (int i = 0; i < upgradesList.size(); ++i) {
                this.upgrades.add(i, (Object)upgradesList.m_128778_(i));
            }
            if (blockEntityTag.m_128425_("StackMultiplier", 3)) {
                this.stackMultiplier = blockEntityTag.m_128451_("StackMultiplier");
            }
            this.sortOrder = blockEntityTag.m_128425_("SortOrder", 8) ? SortOrder.valueOf(blockEntityTag.m_128461_("SortOrder")) : SortOrder.COUNT;
        }
    }

    public CompoundTag saveItemsToStack() {
        CompoundTag tag = new CompoundTag();
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            itemTag.m_128405_("ActualCount", this.itemHandler.getStackInSlot(i).m_41613_());
            this.itemHandler.getStackInSlot(i).m_41739_(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        nbt.m_128405_("Size", this.itemHandler.getSlots());
        tag.m_128365_("Items", (Tag)nbt);
        ListTag upgradesList = new ListTag();
        for (int i = 0; i < this.upgrades.size(); ++i) {
            upgradesList.add(i, (Tag)StringTag.m_129297_((String)((String)this.upgrades.get(i))));
        }
        tag.m_128365_("Upgrades", (Tag)upgradesList);
        tag.m_128405_("StackMultiplier", this.stackMultiplier);
        tag.m_128359_("SortOrder", this.sortOrder.name());
        return tag;
    }

    public List<ItemStack> getItems() {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            itemList.add(this.itemHandler.getStackInSlot(i));
        }
        return itemList;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction direction) {
        return ForgeCapabilities.ITEM_HANDLER.orEmpty(capability, this.lazyItemHandler);
    }

    public NonNullList<String> getUpgrades() {
        return this.upgrades;
    }

    @Override
    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        if (this.player.m_9236_().f_46443_) {
            ModNetwork.sendToServer(new SetSortOrderPacket(sortOrder));
        }
        this.setDataChanged();
    }

    public int getSlots() {
        return this.itemHandler.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int i) {
        return this.itemHandler.getStackInSlot(i);
    }

    public void setStackInSlot(int i, @NotNull ItemStack itemStack) {
        this.itemHandler.setStackInSlot(i, itemStack);
    }

    @NotNull
    public ItemStack insertItem(int i, @NotNull ItemStack itemStack, boolean b) {
        return this.itemHandler.insertItem(i, itemStack, b);
    }

    @NotNull
    public ItemStack extractItem(int i, int i1, boolean b) {
        return this.itemHandler.extractItem(i, i1, b);
    }

    public int getSlotLimit(int i) {
        return this.itemHandler.getSlotLimit(i);
    }

    public boolean isItemValid(int i, @NotNull ItemStack itemStack) {
        return true;
    }

    @Override
    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public int getStackMultiplier() {
        return this.stackMultiplier;
    }

    @Override
    public void setPlayerInteraction(boolean isPlayer) {
    }

    @Override
    public void setDataChanged() {
        if (this.player.m_9236_().f_46443_) {
            return;
        }
        this.setChanged();
    }

    public void refreshUpgrades() {
        this.upgrades.clear();
        int UPGRADE_SLOT_START_INDEX = 132;
        int UPGRADE_SLOT_END_INDEX = UPGRADE_SLOT_START_INDEX + 6;
        for (int i = UPGRADE_SLOT_START_INDEX; i < UPGRADE_SLOT_END_INDEX; ++i) {
            UpgradeItem upgradeItem;
            String upgradeName;
            ItemStack itemStack = this.itemHandler.getStackInSlot(i);
            Item item = itemStack.m_41720_();
            if (!(item instanceof UpgradeItem) || this.upgrades.contains((Object)(upgradeName = (upgradeItem = (UpgradeItem)item).getUpgradeName()))) continue;
            this.upgrades.add((Object)upgradeName);
        }
    }

    public void setChanged() {
        SortOrder newSort;
        CompoundTag tag;
        if (this.player.m_9236_().f_46443_) {
            return;
        }
        NonNullList oldItemStacks = NonNullList.m_122780_((int)this.CONTAINER_SIZE, (Object)ItemStack.f_41583_);
        NonNullList newItemStacks = NonNullList.m_122780_((int)this.CONTAINER_SIZE, (Object)ItemStack.f_41583_);
        CompoundTag blockEntityTag = this.stack.m_41737_("BlockEntityTag");
        if (blockEntityTag == null) {
            CompoundTag tag2 = new CompoundTag();
            ContainerHelper.m_18973_((CompoundTag)tag2, (NonNullList)NonNullList.m_122780_((int)this.CONTAINER_SIZE, (Object)ItemStack.f_41583_));
            ItemStack itemStack1 = this.stack;
            itemStack1.m_41700_("BlockEntityTag", (Tag)tag2);
            blockEntityTag = BlockItem.m_186336_((ItemStack)itemStack1);
        } else {
            ListTag listTag = blockEntityTag.m_128469_("Items").m_128437_("Items", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                tag = listTag.m_128728_(i);
                int slot = tag.m_128445_("Slot") & 0xFF;
                ItemStack slotStack = ItemStack.m_41712_((CompoundTag)tag);
                if (tag.m_128425_("ActualCount", 3)) {
                    int actualCount = tag.m_128451_("ActualCount");
                    slotStack.m_41764_(Math.max(actualCount, 0));
                }
                if (slot >= oldItemStacks.size()) continue;
                oldItemStacks.set(slot, (Object)slotStack);
            }
        }
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            newItemStacks.set(i, (Object)this.itemHandler.getStackInSlot(i));
        }
        SortOrder oldSort = blockEntityTag != null && blockEntityTag.m_128441_("SortOrder") ? SortOrder.valueOf(blockEntityTag.m_128461_("SortOrder")) : SortOrder.COUNT;
        this.sortOrder = newSort = this.sortOrder != null ? this.sortOrder : SortOrder.COUNT;
        if (!BackpackContainer.itemStacksAreSame((NonNullList<ItemStack>)oldItemStacks, (NonNullList<ItemStack>)newItemStacks) || !newSort.equals((Object)oldSort)) {
            this.refreshUpgrades();
            tag = this.saveItemsToStack();
            this.stack.m_41784_().m_128365_("BlockEntityTag", (Tag)tag);
            ModNetwork.sendToPlayer((ServerPlayer)this.player, new SyncNBTDataPacket(this.stack));
        }
    }

    private static boolean itemStacksAreSame(NonNullList<ItemStack> oldStack, NonNullList<ItemStack> newStack) {
        if (oldStack.size() != newStack.size()) {
            return false;
        }
        for (int i = 0; i < oldStack.size(); ++i) {
            if (ItemStack.m_41728_((ItemStack)((ItemStack)oldStack.get(i)), (ItemStack)((ItemStack)newStack.get(i)))) continue;
            return false;
        }
        return true;
    }
}

