/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.fxnt.fxntstorage.FXNTStorage;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.backpack.renderer.BackpackModelBase;
import net.fxnt.fxntstorage.backpack.renderer.BackpackModelPlayer;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.fxnt.fxntstorage.init.ModBlocks;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BackpackRenderPlayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private ResourceLocation TEXTURE_LOCATION;
    private final BackpackModelPlayer<AbstractClientPlayer> model;

    public BackpackRenderPlayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> pRenderer) {
        super(pRenderer);
        ModelPart modelPart = BackpackModelBase.createModel(true).m_171564_();
        this.model = new BackpackModelPlayer(modelPart);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, @NotNull AbstractClientPlayer livingEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack backpack = BackpackHelper.getEquippedBackpackStack((LivingEntity)livingEntity);
        if (backpack.m_41619_()) {
            return;
        }
        if (FXNTStorage.curiosLoaded) {
            boolean isCuriosSlotVisible = BackpackHelper.isBackpackCuriosSlotVisible((Player)livingEntity);
            if (!(livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof BackpackItem) && !isCuriosSlotVisible) {
                return;
            }
        }
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_252880_(0.0f, 0.65f, -0.3f);
        poseStack.m_85841_(0.85f, 0.85f, 0.85f);
        if (livingEntity.m_6047_()) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-58.0f));
            poseStack.m_85837_(0.0, 0.15, -0.1);
        }
        ((PlayerModel)this.m_117386_()).m_102872_(this.model);
        this.model.setupAnim((HumanoidModel<AbstractClientPlayer>)((HumanoidModel)this.m_117386_()));
        if (backpack.m_41720_().equals(ModBlocks.BACKPACK.m_5456_())) {
            this.TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"fxntstorage", (String)"textures/block/backpack.png");
        } else if (backpack.m_41720_().equals(ModBlocks.ANDESITE_BACKPACK.m_5456_())) {
            this.TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"fxntstorage", (String)"textures/block/andesite_backpack.png");
        } else if (backpack.m_41720_().equals(ModBlocks.COPPER_BACKPACK.m_5456_())) {
            this.TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"fxntstorage", (String)"textures/block/copper_backpack.png");
        } else if (backpack.m_41720_().equals(ModBlocks.BRASS_BACKPACK.m_5456_())) {
            this.TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"fxntstorage", (String)"textures/block/brass_backpack.png");
        } else if (backpack.m_41720_().equals(ModBlocks.HARDENED_BACKPACK.m_5456_())) {
            this.TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"fxntstorage", (String)"textures/block/hardened_backpack.png");
        }
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)this.TEXTURE_LOCATION));
        this.model.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }
}

