/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.tooltip;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.createmod.catnip.lang.FontHelper;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.container.StorageBoxItem;
import net.fxnt.fxntstorage.init.ModTags;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxItem;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class BackpackTooltip
implements TooltipComponent {
    protected List<ItemStack> storage = new ArrayList<ItemStack>();
    protected List<ItemStack> upgrades = new ArrayList<ItemStack>();
    protected List<Component> tooltipText = new ArrayList<Component>();
    private final Item item;

    public BackpackTooltip(ItemStack stack) {
        this.item = stack.m_41720_();
        this.loadTagData(BlockItem.m_186336_((ItemStack)stack));
    }

    private void loadTagData(CompoundTag tag) {
        this.storage = this.loadInventory(tag);
        this.upgrades = this.loadUpgrades(tag);
        if ((this.item instanceof BackpackItem || this.item instanceof SimpleStorageBoxItem) && this.upgrades.isEmpty() && this.storage.isEmpty()) {
            this.tooltipText.add((Component)Component.m_237115_((String)"tooltip.fxntstorage.no_inventory_or_upgrades").m_130948_(FontHelper.Palette.STANDARD_CREATE.highlight()));
        }
        if (this.item instanceof StorageBoxItem && this.storage.isEmpty()) {
            this.tooltipText.add((Component)Component.m_237115_((String)"tooltip.fxntstorage.no_inventory").m_130948_(FontHelper.Palette.STANDARD_CREATE.highlight()));
        }
    }

    private List<ItemStack> loadUpgrades(CompoundTag tag) {
        if (tag == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (this.item instanceof SimpleStorageBoxItem) {
            if (!tag.m_128441_("Items")) {
                return Collections.emptyList();
            }
            ListTag listTag = tag.m_128469_("Items").m_128437_("Items", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                ItemStack stack = ItemStack.m_41712_((CompoundTag)listTag.m_128728_(i));
                if (!stack.m_204117_(ModTags.Items.STORAGE_BOX_UPGRADE)) continue;
                boolean merged = false;
                for (ItemStack existingStack : list) {
                    if (!ItemStack.m_150942_((ItemStack)existingStack, (ItemStack)stack)) continue;
                    existingStack.m_41769_(stack.m_41613_());
                    merged = true;
                    break;
                }
                if (merged || stack.m_41619_()) continue;
                list.add(stack);
            }
        } else {
            if (!tag.m_128441_("Upgrades")) {
                return Collections.emptyList();
            }
            ListTag upgradeTags = tag.m_128437_("Upgrades", 8);
            for (Tag upgrade : upgradeTags) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)"fxntstorage", (String)upgrade.m_7916_()));
                if (item == null) continue;
                list.add(item.m_7968_());
            }
        }
        return list;
    }

    private List<ItemStack> loadInventory(CompoundTag tag) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (tag == null || !tag.m_128441_("Items")) {
            return Collections.emptyList();
        }
        ListTag listTag = tag.m_128469_("Items").m_128437_("Items", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag listItem = listTag.m_128728_(i);
            boolean actualCountTagIsPresent = listItem.m_128425_("ActualCount", 3);
            CompoundTag newTag = new CompoundTag();
            newTag.m_128359_("id", listItem.m_128461_("id"));
            newTag.m_128344_("Count", actualCountTagIsPresent ? (byte)1 : listItem.m_128445_("Count"));
            if (listItem.m_128441_("tag")) {
                newTag.m_128365_("tag", (Tag)listItem.m_128469_("tag"));
            }
            ItemStack stack = ItemStack.m_41712_((CompoundTag)newTag);
            int slot = listItem.m_128445_("Slot") & 0xFF;
            if (!(this.item instanceof BackpackItem && slot < Util.UPGRADE_SLOT_START_RANGE || this.item instanceof SimpleStorageBoxItem && slot == 0) && !(this.item instanceof StorageBoxItem)) continue;
            if (actualCountTagIsPresent) {
                int actualCount = listItem.m_128451_("ActualCount");
                stack.m_41764_(Math.max(actualCount, 0));
            }
            boolean merged = false;
            for (ItemStack existingStack : list) {
                if (!ItemStack.m_150942_((ItemStack)existingStack, (ItemStack)stack)) continue;
                existingStack.m_41769_(stack.m_41613_());
                merged = true;
                break;
            }
            if (merged || stack.m_41619_()) continue;
            list.add(stack);
        }
        list.sort((stack1, stack2) -> {
            int countCompare = Integer.compare(stack2.m_41613_(), stack1.m_41613_());
            if (countCompare != 0) {
                return countCompare;
            }
            return stack1.m_41720_().toString().compareTo(stack2.m_41720_().toString());
        });
        return list;
    }
}

