/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.upgrade;

import java.util.List;
import net.fxnt.fxntstorage.backpack.BackpackEntity;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.backpack.main.IBackpackContainer;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class BackpackAsBlockUpgradeHandler {
    private final IBackpackContainer container;
    private final BlockEntity blockEntity;
    private final Level level;
    private final BlockPos pos;
    private static final int magnetUpgradeRange = (Integer)ConfigManager.CommonConfig.BACKPACK_MAGNET_RANGE.get();

    public BackpackAsBlockUpgradeHandler(BackpackEntity backpackBlockEntity) {
        this.container = backpackBlockEntity;
        this.blockEntity = backpackBlockEntity;
        this.level = this.blockEntity.m_58904_();
        this.pos = this.blockEntity.m_58899_();
    }

    public void applyMagnetUpgrade() {
        AABB boundingBox;
        List nearbyItems;
        if (this.blockEntity != null && !this.level.f_46443_ && !(nearbyItems = this.level.m_45976_(ItemEntity.class, boundingBox = new AABB(this.pos).m_82400_((double)magnetUpgradeRange))).isEmpty()) {
            ArmorStand stand = (ArmorStand)EntityType.f_20529_.m_20615_(this.level);
            for (ItemEntity itemEntity : nearbyItems) {
                if (itemEntity.m_32055_().m_41720_() instanceof BackpackItem) continue;
                new BackpackHelper().itemEntityToBackpack(this.container, itemEntity, 0, Util.ITEM_SLOT_END_RANGE);
                if (stand == null) continue;
                stand.m_6034_((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() - 0.75, (double)this.pos.m_123343_() + 0.5);
                stand.f_19794_ = true;
                stand.m_6842_(true);
                this.level.m_7967_((Entity)stand);
                ((ServerLevel)this.level).m_7726_().m_8445_((Entity)itemEntity, (Packet)new ClientboundTakeItemEntityPacket(itemEntity.m_19879_(), stand.m_19879_(), itemEntity.m_32055_().m_41613_()));
            }
        }
    }
}

