/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.upgrade;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class TorchDeployerManager {
    private static final Map<UUID, Long> lastPlacementTime = new HashMap<UUID, Long>();

    public static boolean canPlaceTorch(Player player, long cooldownTicks) {
        long gameTime = player.m_9236_().m_46467_();
        UUID id = player.m_20148_();
        if (!lastPlacementTime.containsKey(id)) {
            lastPlacementTime.put(id, gameTime);
            return false;
        }
        long last = lastPlacementTime.getOrDefault(id, 0L);
        if (gameTime - last >= cooldownTicks) {
            lastPlacementTime.put(id, gameTime);
            return true;
        }
        return false;
    }

    public static void resetCooldown(Player player) {
        lastPlacementTime.put(player.m_20148_(), player.m_9236_().m_46467_());
    }

    public static void removePlayer(ServerPlayer player) {
        lastPlacementTime.remove(player.m_20148_());
    }
}

