/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.util;

import net.fxnt.fxntstorage.init.ModNetwork;
import net.fxnt.fxntstorage.network.packet.PickBlockUpgradePacket;
import net.fxnt.fxntstorage.network.packet.SortInventoryPacket;
import net.fxnt.fxntstorage.util.SortOrder;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class BackpackNetworkHelper {
    public static void sortBackpack(int pSlotId, SortOrder pSortOrder) {
        int slotEnd;
        int slotStart;
        if (pSlotId < Util.ITEM_SLOT_END_RANGE) {
            slotStart = 0;
            slotEnd = Util.ITEM_SLOT_END_RANGE;
        } else if (pSlotId < Util.TOOL_SLOT_END_RANGE) {
            slotStart = Util.TOOL_SLOT_START_RANGE;
            slotEnd = Util.TOOL_SLOT_END_RANGE;
        } else {
            if (pSlotId < Util.UPGRADE_SLOT_END_RANGE) {
                return;
            }
            if (pSlotId < Util.UPGRADE_SLOT_END_RANGE + 27) {
                slotStart = Util.UPGRADE_SLOT_END_RANGE;
                slotEnd = Util.UPGRADE_SLOT_END_RANGE + 27;
            } else {
                slotStart = Util.UPGRADE_SLOT_END_RANGE + 27;
                slotEnd = Util.UPGRADE_SLOT_END_RANGE + 36;
            }
        }
        ModNetwork.sendToServer(new SortInventoryPacket(0, slotStart, slotEnd, pSortOrder));
    }

    public static void doPickBlock(ItemStack stack) {
        ModNetwork.sendToServer(new PickBlockUpgradePacket(stack));
    }

    public static void writeItemStack(@NotNull ItemStack stack, FriendlyByteBuf buf) {
        if (stack.m_41619_()) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            Item item = stack.m_41720_();
            buf.m_130130_(Item.m_41393_((Item)item));
            buf.m_130130_(stack.m_41613_());
            CompoundTag compoundTag = null;
            if (stack.m_41782_()) {
                compoundTag = stack.m_41784_();
            }
            buf.m_130079_(compoundTag);
        }
    }

    public static ItemStack readItemStack(@NotNull FriendlyByteBuf buf) {
        if (!buf.readBoolean()) {
            return ItemStack.f_41583_;
        }
        int itemId = buf.m_130242_();
        int itemCount = buf.m_130242_();
        ItemStack itemstack = new ItemStack((ItemLike)Item.m_41445_((int)itemId), itemCount);
        itemstack.m_41751_(buf.m_130260_());
        return itemstack;
    }
}

