/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.cache;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BackpackShapeCache {
    private static final Map<Direction, VoxelShape> shapes = new EnumMap<Direction, VoxelShape>(Direction.class);

    public static void clearCache() {
        shapes.clear();
        BackpackShapeCache.initializeShapes();
    }

    private static void initializeShapes() {
        shapes.put(Direction.NORTH, BackpackShapeCache.createShapeForDirection(Direction.NORTH));
        shapes.put(Direction.SOUTH, BackpackShapeCache.createShapeForDirection(Direction.SOUTH));
        shapes.put(Direction.EAST, BackpackShapeCache.createShapeForDirection(Direction.EAST));
        shapes.put(Direction.WEST, BackpackShapeCache.createShapeForDirection(Direction.WEST));
    }

    private static VoxelShape createShapeForDirection(Direction direction) {
        VoxelShape finalShape = Shapes.m_83040_();
        List<VoxelShape> parts = Arrays.asList(Block.m_49796_((double)3.0, (double)0.0, (double)5.0, (double)13.0, (double)11.0, (double)11.0), Block.m_49796_((double)3.5, (double)0.5, (double)11.0, (double)12.5, (double)10.5, (double)11.25), Block.m_49796_((double)13.0, (double)0.5, (double)5.5, (double)13.25, (double)10.5, (double)10.5), Block.m_49796_((double)2.75, (double)0.5, (double)5.5, (double)3.0, (double)10.5, (double)10.5), Block.m_49796_((double)3.5, (double)-0.25, (double)5.5, (double)12.5, (double)0.0, (double)10.5), Block.m_49796_((double)4.0, (double)0.5, (double)3.0, (double)12.0, (double)7.5, (double)5.0), Block.m_49796_((double)5.0, (double)1.5, (double)2.5, (double)11.0, (double)6.5, (double)3.5), Block.m_49796_((double)6.0, (double)14.0, (double)8.0, (double)10.0, (double)14.25, (double)9.0), Block.m_49796_((double)9.0, (double)13.25, (double)8.0, (double)10.0, (double)14.0, (double)9.0), Block.m_49796_((double)6.0, (double)13.25, (double)8.0, (double)7.0, (double)14.0, (double)9.0), Block.m_49796_((double)3.5, (double)11.0, (double)7.0, (double)12.5, (double)13.0, (double)10.0), Block.m_49796_((double)12.5, (double)11.0, (double)7.25, (double)12.75, (double)12.8, (double)10.0), Block.m_49796_((double)3.25, (double)11.0, (double)7.25, (double)3.5, (double)12.8, (double)10.0), Block.m_49796_((double)3.5, (double)11.0, (double)6.0, (double)12.5, (double)12.5, (double)7.0), Block.m_49796_((double)4.0, (double)11.0, (double)5.9, (double)12.0, (double)11.1, (double)6.0), Block.m_49796_((double)6.0, (double)6.0, (double)2.4, (double)10.0, (double)6.1, (double)2.5), Block.m_49796_((double)9.9, (double)5.8, (double)2.4, (double)10.0, (double)6.0, (double)2.5), Block.m_49796_((double)11.9, (double)11.0, (double)5.7, (double)12.0, (double)11.1, (double)5.9), Block.m_49796_((double)3.5, (double)11.0, (double)10.0, (double)12.5, (double)12.8, (double)11.0), Block.m_49796_((double)4.5, (double)7.0, (double)4.0, (double)11.5, (double)8.0, (double)5.0), Block.m_49796_((double)9.5, (double)1.0, (double)11.0, (double)11.5, (double)12.0, (double)11.75), Block.m_49796_((double)4.5, (double)1.0, (double)11.0, (double)6.5, (double)12.0, (double)11.75), Block.m_49796_((double)9.75, (double)12.0, (double)11.0, (double)11.25, (double)12.75, (double)11.25), Block.m_49796_((double)4.75, (double)12.0, (double)11.0, (double)6.25, (double)12.75, (double)11.25), Block.m_49796_((double)4.75, (double)0.25, (double)11.0, (double)6.25, (double)1.05, (double)11.4), Block.m_49796_((double)9.75, (double)0.25, (double)11.0, (double)11.25, (double)1.05, (double)11.4));
        for (VoxelShape part : parts) {
            VoxelShape rotatedPart = BackpackShapeCache.rotateHorizontal(part, direction);
            finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)rotatedPart);
        }
        return finalShape.m_83296_();
    }

    public static VoxelShape getShape(Direction direction) {
        return shapes.get(direction);
    }

    private static VoxelShape rotateHorizontal(VoxelShape shape, Direction dir) {
        return switch (dir) {
            case Direction.SOUTH -> Shapes.m_166049_((double)(1.0 - shape.m_83297_(Direction.Axis.X)), (double)shape.m_83288_(Direction.Axis.Y), (double)(1.0 - shape.m_83297_(Direction.Axis.Z)), (double)(1.0 - shape.m_83288_(Direction.Axis.X)), (double)shape.m_83297_(Direction.Axis.Y), (double)(1.0 - shape.m_83288_(Direction.Axis.Z)));
            case Direction.WEST -> Shapes.m_166049_((double)shape.m_83288_(Direction.Axis.Z), (double)shape.m_83288_(Direction.Axis.Y), (double)(1.0 - shape.m_83297_(Direction.Axis.X)), (double)shape.m_83297_(Direction.Axis.Z), (double)shape.m_83297_(Direction.Axis.Y), (double)(1.0 - shape.m_83288_(Direction.Axis.X)));
            case Direction.EAST -> Shapes.m_166049_((double)(1.0 - shape.m_83297_(Direction.Axis.Z)), (double)shape.m_83288_(Direction.Axis.Y), (double)shape.m_83288_(Direction.Axis.X), (double)(1.0 - shape.m_83288_(Direction.Axis.Z)), (double)shape.m_83297_(Direction.Axis.Y), (double)shape.m_83297_(Direction.Axis.X));
            default -> shape;
        };
    }

    static {
        BackpackShapeCache.initializeShapes();
    }
}

