/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.compat.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.common.transfer.RecipeTransferOperationsResult;
import mezz.jei.common.transfer.RecipeTransferUtil;
import net.fxnt.fxntstorage.backpack.main.BackpackContainer;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.fxnt.fxntstorage.init.ModNetwork;
import net.fxnt.fxntstorage.network.packet.TransferRecipePacket;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class JEIStonecuttingTransferHandler
implements IRecipeTransferHandler<StonecutterMenu, StonecutterRecipe> {
    private final IRecipeTransferHandlerHelper transferHelper;
    private final IStackHelper stackHelper;

    public JEIStonecuttingTransferHandler(IRecipeTransferHandlerHelper transferHelper, IStackHelper stackHelper) {
        this.transferHelper = transferHelper;
        this.stackHelper = stackHelper;
    }

    public Class<? extends StonecutterMenu> getContainerClass() {
        return StonecutterMenu.class;
    }

    public Optional<MenuType<StonecutterMenu>> getMenuType() {
        return Optional.of(MenuType.f_39980_);
    }

    public RecipeType<StonecutterRecipe> getRecipeType() {
        return RecipeTypes.STONECUTTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(StonecutterMenu container, StonecutterRecipe recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        Inventory playerInventory = player.m_150109_();
        ItemStack backpack = BackpackHelper.getEquippedBackpackStack((LivingEntity)player);
        LinkedHashMap<Object, ItemStack> availableItemStacks = new LinkedHashMap<Object, ItemStack>();
        for (int i = 0; i < playerInventory.m_6643_(); ++i) {
            ItemStack stack2 = playerInventory.m_8020_(i);
            if (stack2.m_41619_()) continue;
            availableItemStacks.put(new Slot((Container)playerInventory, i, 0, 0), stack2);
        }
        if (!backpack.m_41619_()) {
            BackpackContainer backpackContainer = new BackpackContainer(backpack, player);
            ItemStackHandler itemHandler = backpackContainer.getItemHandler();
            for (int i = 0; i < Util.ITEM_SLOT_END_RANGE; ++i) {
                ItemStack stack3 = itemHandler.getStackInSlot(i);
                if (stack3.m_41619_()) continue;
                availableItemStacks.put(new SlotItemHandler((IItemHandler)itemHandler, i, 0, 0), stack3);
            }
        }
        ArrayList<IRecipeSlotView> missingSlots = new ArrayList<IRecipeSlotView>();
        LinkedHashMap remainingStacks = new LinkedHashMap();
        availableItemStacks.forEach((slot, stack) -> remainingStacks.put(slot, stack.m_41777_()));
        for (IRecipeSlotView slotView : recipeSlots.getSlotViews()) {
            if (slotView.getRole() != RecipeIngredientRole.INPUT || slotView.isEmpty()) continue;
            boolean matched = false;
            for (ItemStack displayed : slotView.getItemStacks().toList()) {
                if (displayed.m_41619_()) continue;
                Ingredient ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{displayed});
                for (Map.Entry entry : remainingStacks.entrySet()) {
                    ItemStack testStack = (ItemStack)entry.getValue();
                    if (testStack.m_41619_() || !ingredient.test(testStack)) continue;
                    testStack.m_41774_(1);
                    if (testStack.m_41619_()) {
                        entry.setValue(ItemStack.f_41583_);
                    }
                    matched = true;
                    break;
                }
                if (!matched) continue;
                break;
            }
            if (matched) continue;
            missingSlots.add(slotView);
        }
        if (!missingSlots.isEmpty()) {
            return this.transferHelper.createUserErrorForMissingSlots((Component)Component.m_237115_((String)"jei.tooltip.error.recipe.transfer.missing"), missingSlots);
        }
        if (!doTransfer) {
            return null;
        }
        List<Slot> inputSlotList = List.of(container.m_38853_(1));
        RecipeTransferOperationsResult operations = RecipeTransferUtil.getRecipeTransferOperations((IStackHelper)this.stackHelper, availableItemStacks, (List)recipeSlots.getSlotViews(RecipeIngredientRole.INPUT), inputSlotList);
        if (!operations.missingItems.isEmpty()) {
            return this.transferHelper.createUserErrorForMissingSlots((Component)Component.m_237115_((String)"jei.tooltip.error.recipe.transfer.missing"), (Collection)operations.missingItems);
        }
        List<Integer> recipeList = operations.results.stream().map(op -> op.craftingSlot((AbstractContainerMenu)container).f_40219_).toList();
        ModNetwork.sendToServer(new TransferRecipePacket(recipe.m_6423_(), recipeList, maxTransfer, 0));
        Minecraft mc = Minecraft.m_91087_();
        Ingredient ingredient = (Ingredient)recipe.m_7527_().get(0);
        ItemStack inputStack = ingredient.m_43908_().length > 0 ? ingredient.m_43908_()[0] : ItemStack.f_41583_;
        SimpleContainer inv = new SimpleContainer(new ItemStack[]{inputStack});
        List list = mc.f_91073_.m_7465_().m_44056_(net.minecraft.world.item.crafting.RecipeType.f_44112_, (Container)inv, (Level)mc.f_91073_);
        for (int i = 0; i < list.size(); ++i) {
            if (!((StonecutterRecipe)list.get(i)).m_6423_().equals((Object)recipe.m_6423_())) continue;
            mc.f_91072_.m_105208_(container.f_38840_, i);
            break;
        }
        return null;
    }
}

