/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.container;

import com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchObservable;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.fxnt.fxntstorage.FXNTStorage;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.container.StorageBox;
import net.fxnt.fxntstorage.container.StorageBoxMenu;
import net.fxnt.fxntstorage.container.util.EnumProperties;
import net.fxnt.fxntstorage.container.util.StorageBoxFilteringBox;
import net.fxnt.fxntstorage.init.ModNetwork;
import net.fxnt.fxntstorage.init.ModTags;
import net.fxnt.fxntstorage.network.packet.SetSortOrderPacket;
import net.fxnt.fxntstorage.util.SortOrder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class StorageBoxEntity
extends SmartBlockEntity
implements Container,
MenuProvider,
Nameable,
ThresholdSwitchObservable {
    public int slotCount = 0;
    private int tickCount = 0;
    private Component customName;
    private int storedAmount = -1;
    private float percentageUsed = 0.0f;
    boolean voidUpgrade;
    private FilteringBehaviour filtering;
    private VersionedInventoryTrackerBehaviour invVersionTracker;
    private final ItemStackHandler itemHandler = this.createItemHandler();
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private SortOrder sortOrder;

    public StorageBoxEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.voidUpgrade = (Boolean)state.m_61143_((Property)StorageBox.VOID_UPGRADE);
        this.sortOrder = SortOrder.COUNT;
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                StorageBoxEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return StorageBoxEntity.this.f_58857_ != null && StorageBoxEntity.this.filterTest(stack);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                ItemStack amount = super.insertItem(slot, stack, simulate);
                if (StorageBoxEntity.this.percentageUsed == 100.0f && StorageBoxEntity.this.voidUpgrade) {
                    return ItemStack.f_41583_;
                }
                return amount;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ItemStack stackToExtract = this.getStackInSlot(slot);
                if (!StorageBoxEntity.this.filterTest(stackToExtract)) {
                    return ItemStack.f_41583_;
                }
                return super.extractItem(slot, amount, simulate);
            }
        };
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.lazyItemHandler);
    }

    public void initializeEntity(int slotCount) {
        this.slotCount = slotCount;
        this.itemHandler.setSize(this.slotCount);
    }

    public void onLoad() {
        super.onLoad();
        if (this.m_58904_() != null && this.m_58904_().f_46443_) {
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.invVersionTracker);
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new StorageBoxFilteringBox()).withCallback($ -> this.invVersionTracker.reset());
        behaviours.add((BlockEntityBehaviour)this.filtering);
    }

    public void m_6596_() {
        super.m_6596_();
        BlockPos pos = this.m_58899_();
        Level level = this.m_58904_();
        if (level != null) {
            level.m_46672_(pos, this.m_58900_().m_60734_());
        }
    }

    public Component m_7755_() {
        return this.m_5446_();
    }

    public Component m_7770_() {
        return this.customName;
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    public Component m_5446_() {
        return this.m_8077_() ? this.m_7770_() : this.m_58900_().m_60734_().m_49954_();
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrder order) {
        this.sortOrder = order;
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            ModNetwork.sendToServer(new SetSortOrderPacket(this.sortOrder));
        }
        this.m_6596_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        if (pPlayer.m_5833_()) {
            return null;
        }
        FriendlyByteBuf extraData = new FriendlyByteBuf(Unpooled.buffer());
        extraData.m_130064_(this.f_58858_);
        return new StorageBoxMenu(pContainerId, pPlayerInventory, extraData);
    }

    private void writeStoredData(CompoundTag tag) {
        tag.m_128405_("SlotCount", this.slotCount);
        tag.m_128405_("StoredAmount", this.calculateStoredAmount());
        tag.m_128350_("PercentageUsed", this.calculatePercentageUsed());
        tag.m_128379_("VoidUpgrade", this.voidUpgrade);
    }

    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
        this.writeStoredData(tag);
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128365_("Items", (Tag)this.itemHandler.serializeNBT());
        if (this.customName != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        tag.m_128359_("SortOrder", this.sortOrder.name());
        this.writeStoredData(tag);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.itemHandler.deserializeNBT(tag.m_128469_("Items"));
        this.slotCount = tag.m_128451_("SlotCount");
        this.storedAmount = tag.m_128451_("StoredAmount");
        this.percentageUsed = tag.m_128457_("PercentageUsed");
        this.voidUpgrade = tag.m_128471_("VoidUpgrade");
        if (tag.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
        SortOrder sortOrder = this.sortOrder = tag.m_128425_("SortOrder", 8) ? SortOrder.valueOf(tag.m_128461_("SortOrder")) : SortOrder.COUNT;
        if (this.slotCount == 0) {
            FXNTStorage.LOGGER.debug("Migrating slot layout from previous version of Storage Box @ {}", (Object)this.f_58858_);
            this.slotCount = tag.m_128451_("slotCount");
            this.storedAmount = tag.m_128451_("storedAmount");
            this.percentageUsed = tag.m_128451_("percentageUsed");
            this.voidUpgrade = tag.m_128471_("voidUpgrade");
            if (this.slotCount == 0 && tag.m_128441_("Items") && tag.m_128469_("Items").m_128441_("Size")) {
                this.slotCount = tag.m_128469_("Items").m_128451_("Size");
            }
        }
    }

    public int m_6643_() {
        return this.itemHandler.getSlots();
    }

    public boolean m_7983_() {
        return this.storedAmount <= 0;
    }

    public ItemStack m_8020_(int pSlot) {
        return this.itemHandler.getStackInSlot(pSlot);
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        this.itemHandler.extractItem(pSlot, pAmount, false);
        return this.itemHandler.getStackInSlot(pSlot);
    }

    public ItemStack m_8016_(int pSlot) {
        this.itemHandler.insertItem(pSlot, ItemStack.f_41583_, false);
        return this.itemHandler.getStackInSlot(pSlot);
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        this.itemHandler.setStackInSlot(pSlot, pStack);
    }

    public boolean m_6542_(Player pPlayer) {
        return !this.m_58901_() && Container.m_271806_((BlockEntity)this, (Player)pPlayer, (int)5);
    }

    public FilteringBehaviour getFilter() {
        return this.filtering;
    }

    public int getStoredAmount() {
        return this.calculateStoredAmount();
    }

    public int getPercentageUsed() {
        return Math.round(this.calculatePercentageUsed());
    }

    private int calculateStoredAmount() {
        int storedAmount = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            storedAmount += this.itemHandler.getStackInSlot(i).m_41613_();
        }
        return storedAmount;
    }

    private int calculateMaxValue() {
        int totalSpace = 0;
        int maxItemStackSize = this.m_6893_();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (!this.itemHandler.getStackInSlot(i).m_41619_()) {
                maxItemStackSize = this.itemHandler.getStackInSlot(i).m_41741_();
            }
            totalSpace += maxItemStackSize;
        }
        return totalSpace;
    }

    private int calculateCurrentValue() {
        int usedSpace = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            usedSpace += this.itemHandler.getStackInSlot(i).m_41613_();
        }
        return usedSpace;
    }

    public float calculatePercentageUsed() {
        int totalSpace = 0;
        int usedSpace = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            int maxStackSize = stack.m_41619_() ? 64 : stack.m_41741_();
            totalSpace += maxStackSize;
            usedSpace += stack.m_41613_();
        }
        if (totalSpace == 0) {
            return 0.0f;
        }
        return (float)usedSpace / (float)totalSpace * 100.0f;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128365_("Items", (Tag)this.itemHandler.serializeNBT());
        tag.m_128359_("SortOrder", this.sortOrder.name());
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Items"));
        if (tag.m_128425_("SortOrder", 8)) {
            this.sortOrder = SortOrder.valueOf(tag.m_128461_("SortOrder"));
        }
    }

    public void forceNextTick() {
        this.tickCount = 999;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (!pLevel.f_46443_) {
            if (this.tickCount++ < (Integer)ConfigManager.CommonConfig.STORAGE_BOX_UPDATE_TIME.get()) {
                return;
            }
            this.tickCount = 0;
            BlockState currentState = this.m_58900_();
            int oldStoredAmount = this.storedAmount;
            float oldPercentageUsed = this.percentageUsed;
            this.storedAmount = this.calculateStoredAmount();
            this.percentageUsed = this.calculatePercentageUsed();
            if (this.storedAmount != oldStoredAmount || this.percentageUsed != oldPercentageUsed) {
                this.m_6596_();
                pLevel.m_7260_(pPos, pState, currentState, 2);
            }
            int totalSlots = this.itemHandler.getSlots();
            boolean allSlotsFull = true;
            int filledSlots = 0;
            for (int i = 0; i < this.slotCount; ++i) {
                ItemStack slot = this.itemHandler.getStackInSlot(i);
                if (!slot.m_41619_()) {
                    ++filledSlots;
                    if (slot.m_41613_() >= slot.m_41741_()) continue;
                    allSlotsFull = false;
                    continue;
                }
                allSlotsFull = false;
            }
            int emptySlots = totalSlots - filledSlots;
            EnumProperties.StorageUsed newStorageUsed = EnumProperties.StorageUsed.EMPTY;
            if (allSlotsFull) {
                newStorageUsed = EnumProperties.StorageUsed.FULL;
            } else if (emptySlots == 0) {
                newStorageUsed = EnumProperties.StorageUsed.SLOTS_FILLED;
            } else if (filledSlots > 0) {
                newStorageUsed = EnumProperties.StorageUsed.HAS_ITEMS;
            }
            if (currentState.m_61143_(StorageBox.STORAGE_USED) != newStorageUsed) {
                pLevel.m_7731_(pPos, (BlockState)currentState.m_61124_(StorageBox.STORAGE_USED, (Comparable)((Object)newStorageUsed)), 2);
            }
        }
        super.tick();
    }

    public void transferToStorage(BlockState pState, Player pPlayer, Boolean transferAll) {
        ItemStack itemInHand = pPlayer.m_21120_(InteractionHand.MAIN_HAND);
        boolean isVoidEnabled = (Boolean)pState.m_61143_((Property)StorageBox.VOID_UPGRADE);
        if (transferAll.booleanValue()) {
            for (int i = 0; i < pPlayer.m_150109_().f_35974_.size(); ++i) {
                ItemStack playerStack = pPlayer.m_150109_().m_8020_(i);
                if (playerStack.m_41619_() || !this.filtering.test(playerStack)) continue;
                ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)this.itemHandler, (ItemStack)playerStack, (boolean)false);
                if (remainder.m_41613_() > 0 && isVoidEnabled) {
                    remainder = ItemStack.f_41583_;
                }
                pPlayer.m_150109_().m_6836_(i, remainder);
            }
        } else {
            if (itemInHand.m_41619_() || !this.filterTest(itemInHand)) {
                return;
            }
            ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)this.itemHandler, (ItemStack)itemInHand, (boolean)false);
            if (remainder.m_41613_() > 0 && isVoidEnabled) {
                remainder = ItemStack.f_41583_;
            }
            if (remainder.m_41613_() <= itemInHand.m_41613_()) {
                pPlayer.m_21008_(InteractionHand.MAIN_HAND, remainder);
            } else {
                pPlayer.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
        }
        this.m_6596_();
    }

    public void transferFromStorage(Player pPlayer) {
        ItemStack filterItem = this.filtering.getFilter();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.itemHandler.getStackInSlot(i);
            if (stackInSlot.m_41619_() || !ItemStack.m_150942_((ItemStack)this.itemHandler.getStackInSlot(i), (ItemStack)filterItem)) continue;
            int maxStack = Math.min(this.itemHandler.getStackInSlot(i).m_41741_(), this.itemHandler.getStackInSlot(i).m_41613_());
            int amountToExtract = pPlayer.m_6144_() ? maxStack : 1;
            ItemStack toExtract = stackInSlot.m_255036_(amountToExtract);
            ItemHandlerHelper.giveItemToPlayer((Player)pPlayer, (ItemStack)toExtract);
            this.itemHandler.extractItem(i, amountToExtract, false);
            break;
        }
        this.m_6596_();
    }

    public boolean filterTest(ItemStack stack) {
        if (stack.m_204117_(ModTags.Items.STORAGE_BOX_ITEM)) {
            return false;
        }
        return this.filtering.test(stack);
    }

    public void toggleVoidUpgrade() {
        BlockState blockState = this.m_58900_();
        Level level = this.m_58904_();
        if (level != null) {
            this.voidUpgrade = (Boolean)blockState.m_61143_((Property)StorageBox.VOID_UPGRADE) == false;
            level.m_46597_(this.m_58899_(), (BlockState)blockState.m_61124_((Property)StorageBox.VOID_UPGRADE, (Comparable)Boolean.valueOf(this.voidUpgrade)));
            this.m_6596_();
        }
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public void m_6211_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public int getMaxValue() {
        return this.calculateMaxValue();
    }

    public int getMinValue() {
        return 0;
    }

    public int getCurrentValue() {
        return this.calculateCurrentValue();
    }

    public MutableComponent format(int i) {
        return CreateLang.translateDirect((String)"create.gui.threshold_switch.currently", (Object[])new Object[]{i});
    }

    public void applyInventoryToBlock(ItemStackHandler wrapped) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, i < wrapped.getSlots() ? wrapped.getStackInSlot(i) : ItemStack.f_41583_);
        }
    }
}

