/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.container;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.fxnt.fxntstorage.container.StorageBoxEntity;
import net.fxnt.fxntstorage.util.RendererHelper;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class StorageBoxEntityRenderer
extends SmartBlockEntityRenderer<StorageBoxEntity> {
    public StorageBoxEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public static void renderFromContraptionContext(MovementContext context, ContraptionMatrices matrices, MultiBufferSource buffer) {
        double distance;
        BlockState state = context.state;
        CompoundTag tag = context.blockEntityData;
        if (tag == null || state == null) {
            return;
        }
        int amount = tag.m_128451_("StoredAmount");
        int percentUsed = Math.round(tag.m_128457_("PercentageUsed"));
        String line1 = Util.formatNumber(amount);
        Object line2 = tag.m_128471_("VoidUpgrade") ? "Void Mode" : percentUsed + "% Used";
        Direction side = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        PoseStack poseStack = matrices.getModelViewProjection();
        poseStack.m_85836_();
        poseStack.m_252880_((float)context.localPos.m_123341_() + 0.5f, (float)context.localPos.m_123342_() + 0.5f, (float)context.localPos.m_123343_() + 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252961_(RendererHelper.SIDE_ROT_Y[side.ordinal()]));
        poseStack.m_252880_(-0.5f, 0.0f, -0.5f);
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        double d = distance = context.position != null ? Math.sqrt(player.m_20238_(context.position)) : Math.sqrt(player.m_20238_(context.contraption.entity.toGlobalVector(Vec3.m_82512_((Vec3i)context.localPos), 1.0f)));
        if (distance >= 10.0) {
            poseStack.m_85849_();
            return;
        }
        int color = RendererHelper.getColorForDistance(distance);
        BlockPos lightPos = context.contraption.entity.m_20183_().m_121955_((Vec3i)context.localPos).m_121945_(side);
        int blockLight = context.world.m_45517_(LightLayer.BLOCK, lightPos);
        int skyLight = context.world.m_45517_(LightLayer.SKY, lightPos);
        int lightLevel = LightTexture.m_109885_((int)blockLight, (int)skyLight);
        RendererHelper.renderLine(line1, -1.0f, poseStack, buffer, color, lightLevel);
        RendererHelper.renderLine((String)line2, -4.0f, poseStack, buffer, color, lightLevel);
        if (tag.m_128441_("Filter")) {
            ItemStack filterItem;
            ItemStack itemStack = filterItem = tag.m_128469_("Filter").m_128456_() ? ItemStack.f_41583_ : ItemStack.m_41712_((CompoundTag)tag.m_128469_("Filter"));
            if (!filterItem.m_41619_()) {
                RendererHelper.renderItem(mc.m_91291_(), filterItem, poseStack, buffer, lightLevel, false);
            }
        }
        poseStack.m_85849_();
    }

    protected void renderSafe(StorageBoxEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Minecraft mc = Minecraft.m_91087_();
        Screen currentScreen = mc.f_91080_;
        boolean isPonderScene = currentScreen instanceof AbstractSimiScreen;
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        Level level = blockEntity.m_58904_();
        if (level == null) {
            return;
        }
        int amount = blockEntity.getStoredAmount();
        String line1 = Util.formatNumber(amount);
        String line2 = blockEntity.voidUpgrade ? "Void Mode" : blockEntity.getPercentageUsed() + "% Used";
        float distance = (float)Math.sqrt(blockEntity.m_58899_().m_203193_((Position)player.m_20182_()));
        if (distance > 10.0f && !isPonderScene) {
            return;
        }
        if (isPonderScene) {
            distance = 3.0f;
        }
        BlockState blockState = blockEntity.m_58900_();
        Direction side = (Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        BlockPos lightPos = blockEntity.m_58899_().m_121945_(side);
        int blockLight = level.m_45517_(LightLayer.BLOCK, lightPos);
        int skyLight = level.m_45517_(LightLayer.SKY, lightPos);
        int lightLevel = LightTexture.m_109885_((int)blockLight, (int)skyLight);
        FilteringRenderer.renderOnBlockEntity((SmartBlockEntity)blockEntity, (float)partialTick, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)lightLevel, (int)packedOverlay);
        poseStack.m_252880_(0.5f, 0.0f, 0.5f);
        poseStack.m_252931_(new Matrix4f().rotateYXZ(RendererHelper.SIDE_ROT_Y[side.ordinal()], 0.0f, 0.0f));
        poseStack.m_252880_(-0.5f, 0.0f, -0.5f);
        int color = RendererHelper.getColorForDistance(distance);
        RendererHelper.renderLine(line1, 7.0f, poseStack, buffer, color, lightLevel);
        RendererHelper.renderLine(line2, 4.0f, poseStack, buffer, color, lightLevel);
    }
}

