/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.container;

import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fxnt.fxntstorage.container.StorageBoxEntity;
import net.fxnt.fxntstorage.init.ModMenuTypes;
import net.fxnt.fxntstorage.util.SortOrder;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class StorageBoxMenu
extends AbstractContainerMenu {
    public final StorageBoxEntity blockEntity;
    private final Container container;
    private final int slotCount;
    public final Player player;
    private final FilteringBehaviour filtering;

    public StorageBoxMenu(int containerId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(containerId, playerInventory, Objects.requireNonNull(playerInventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_())));
    }

    public Container getInventory() {
        return this.container;
    }

    public StorageBoxMenu(int containerId, Inventory playerInventory, BlockEntity entity) {
        super((MenuType)ModMenuTypes.STORAGE_BOX_MENU.get(), containerId);
        this.blockEntity = (StorageBoxEntity)entity;
        SimpleContainerData data = new SimpleContainerData(this.blockEntity.slotCount);
        this.player = playerInventory.f_35978_;
        this.slotCount = data.m_6499_();
        this.container = this.blockEntity;
        StorageBoxMenu.m_38869_((Container)this.container, (int)this.slotCount);
        this.initSlots();
        this.filtering = this.blockEntity.getFilter();
    }

    public void initSlots() {
        Inventory playerInventory = this.player.m_150109_();
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
            int index = 0;
            for (int i = 0; i < this.slotCount; ++i) {
                this.m_38897_((Slot)new SlotItemHandler(iItemHandler, index, index * 18, 0));
                ++index;
            }
        });
        int yOffset = 0;
        int xOffset = 61;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, y * 9 + x + 9, xOffset + 18 * x, yOffset + y * 18));
            }
        }
        yOffset += 58;
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, xOffset + i * 18, yOffset));
        }
    }

    public boolean m_6875_(Player pPlayer) {
        return this.container.m_6542_(pPlayer);
    }

    public SortOrder getSortOrder() {
        return this.blockEntity.getSortOrder();
    }

    public void setSortOrder(SortOrder order) {
        this.blockEntity.setSortOrder(order);
    }

    public int getSlotsSize() {
        return this.f_38839_.size();
    }

    public int getContainerSize() {
        return this.slotCount;
    }

    public Slot getPlayerSlot(int slotIndex) {
        return (Slot)this.f_38839_.get(this.getSlotsSize() - 36 + slotIndex);
    }

    public Slot getHotbarSlot(int slotIndex) {
        return (Slot)this.f_38839_.get(this.getSlotsSize() - 36 + 27 + slotIndex);
    }

    public boolean filterTest(ItemStack stack) {
        ItemStack filterItem = this.filtering.getFilter();
        return FilterItemStack.of((ItemStack)filterItem).test(this.player.m_9236_(), stack);
    }

    public ItemStack m_7648_(Player player, int pIndex) {
        Slot srcSlot = (Slot)this.f_38839_.get(pIndex);
        if (!srcSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack srcStack = srcSlot.m_7993_();
        if (!this.filterTest(srcStack)) {
            return ItemStack.f_41583_;
        }
        ItemStack copyOfSrcStack = srcStack.m_41777_();
        if (pIndex < this.container.m_6643_() ? !this.m_38903_(srcStack, this.container.m_6643_(), this.container.m_6643_() + 36, true) : !this.m_38903_(srcStack, 0, this.container.m_6643_(), false)) {
            return ItemStack.f_41583_;
        }
        if (srcStack.m_41619_()) {
            srcSlot.m_5852_(ItemStack.f_41583_);
        } else {
            srcSlot.m_6654_();
        }
        return copyOfSrcStack;
    }

    public void sortStorageItems(int startIndex, int endIndex, SortOrder sortOrder) {
        ServerPlayer sp = (ServerPlayer)this.player;
        HashMap<Util.ItemWithNBT, Integer> itemCompMap = new HashMap<Util.ItemWithNBT, Integer>();
        for (int i = startIndex; i < endIndex; ++i) {
            ItemStack stack = this.m_38853_(i).m_7993_();
            if (stack.m_41619_()) continue;
            CompoundTag tag = stack.m_41783_();
            Util.ItemWithNBT key = new Util.ItemWithNBT(stack.m_41720_(), tag);
            itemCompMap.merge(key, stack.m_41613_(), Integer::sum);
        }
        ArrayList sortedItems = new ArrayList(itemCompMap.entrySet());
        switch (sortOrder) {
            case MOD: {
                sortedItems.sort(Comparator.comparing(entry -> Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)((Util.ItemWithNBT)entry.getKey()).item())).toString()).thenComparing(Map.Entry::getValue, Comparator.reverseOrder()));
                break;
            }
            case NAME: {
                sortedItems.sort(Comparator.comparing(entry -> ((Util.ItemWithNBT)entry.getKey()).item().m_7626_(new ItemStack((ItemLike)((Util.ItemWithNBT)entry.getKey()).item())).getString()).thenComparing(entry -> ((Util.ItemWithNBT)entry.getKey()).getDisplayNameString()).thenComparing(Map.Entry::getValue, Comparator.reverseOrder()));
                break;
            }
            default: {
                sortedItems.sort(Map.Entry.comparingByValue().reversed().thenComparing(entry -> ((Util.ItemWithNBT)entry.getKey()).toString()));
            }
        }
        NonNullList compactedList = NonNullList.m_122780_((int)(endIndex - startIndex), (Object)ItemStack.f_41583_);
        int idx = 0;
        for (Map.Entry entry2 : sortedItems) {
            Util.ItemWithNBT key = (Util.ItemWithNBT)entry2.getKey();
            Item item = key.item();
            CompoundTag tag = key.tag();
            int totalCount = (Integer)entry2.getValue();
            int maxStackSize = new ItemStack((ItemLike)item, 1).m_41741_();
            while (totalCount > 0) {
                int stackSize = Math.min(totalCount, maxStackSize);
                ItemStack stack = new ItemStack((ItemLike)item, stackSize);
                if (tag != null) {
                    stack.m_41751_(tag);
                }
                compactedList.set(idx, (Object)stack);
                totalCount -= stackSize;
                ++idx;
            }
        }
        for (int i = 0; i < compactedList.size(); ++i) {
            ItemStack itemStack = (ItemStack)compactedList.get(i);
            Slot slot = this.player.f_36096_.m_38853_(i + startIndex);
            slot.m_5852_(itemStack);
            if (startIndex < this.slotCount) continue;
            sp.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.player.f_36096_.f_38840_, this.m_182424_(), i + startIndex, itemStack));
        }
    }
}

