/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.container.mounted;

import com.simibubi.create.api.contraption.storage.item.MountedItemStorage;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.fxnt.fxntstorage.container.mounted.StorageBoxMountedStorage;
import net.fxnt.fxntstorage.init.ModMenuTypes;
import net.fxnt.fxntstorage.init.ModNetwork;
import net.fxnt.fxntstorage.network.packet.SetMountedStorageDirtyPacket;
import net.fxnt.fxntstorage.network.packet.SetSortOrderPacket;
import net.fxnt.fxntstorage.util.SortOrder;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class StorageBoxMountedMenu
extends AbstractContainerMenu {
    private final Container container;
    private final CompoundTag nbt;
    private final Player player;
    private final int contraptionId;
    private final BlockPos localPos;
    private final int slotCount;

    public StorageBoxMountedMenu(int containerId, Inventory playerInventory, FriendlyByteBuf buf) {
        this(containerId, playerInventory, (Container)new SimpleContainer(buf.readInt()), buf.readInt(), buf.m_130135_(), buf.m_130260_());
    }

    public Container getInventory() {
        return this.container;
    }

    public StorageBoxMountedMenu(int containerId, Inventory playerInventory, Container container, int contraptionId, BlockPos localPos, CompoundTag nbt) {
        super((MenuType)ModMenuTypes.STORAGE_BOX_MOUNTED_MENU.get(), containerId);
        this.nbt = nbt;
        this.container = container;
        this.player = playerInventory.f_35978_;
        this.contraptionId = contraptionId;
        this.localPos = localPos;
        SimpleContainerData data = new SimpleContainerData(container.m_6643_());
        this.slotCount = data.m_6499_();
        int index = 0;
        for (int i = 0; i < this.slotCount; ++i) {
            this.m_38897_(new Slot(container, index, index * 18, 0){

                public boolean m_5857_(@NotNull ItemStack stack) {
                    return StorageBoxMountedMenu.this.filterTest(stack);
                }

                public void m_6654_() {
                    super.m_6654_();
                    StorageBoxMountedMenu.this.setStorageDirty();
                }
            });
            ++index;
        }
        int yOffset = 0;
        int xOffset = 61;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, y * 9 + x + 9, xOffset + 18 * x, yOffset + y * 18));
            }
        }
        yOffset += 58;
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, xOffset + i * 18, yOffset));
        }
    }

    public boolean m_6875_(@NotNull Player pPlayer) {
        return this.container.m_6542_(pPlayer);
    }

    public SortOrder getSortOrder() {
        return SortOrder.valueOf(this.nbt.m_128461_("SortOrder"));
    }

    public void setSortOrder(SortOrder order) {
        this.nbt.m_128359_("SortOrder", order.name());
        if (this.player.m_9236_().f_46443_) {
            ModNetwork.sendToServer(new SetSortOrderPacket(this.getSortOrder()));
        } else {
            this.updateContraptionNbt(tag -> tag.m_128359_("SortOrder", order.name()));
        }
    }

    public int getSlotsSize() {
        return this.f_38839_.size();
    }

    public int getContainerSize() {
        return this.slotCount;
    }

    public Slot getPlayerSlot(int slotIndex) {
        return (Slot)this.f_38839_.get(this.getSlotsSize() - 36 + slotIndex);
    }

    public Slot getHotbarSlot(int slotIndex) {
        return (Slot)this.f_38839_.get(this.getSlotsSize() - 36 + 27 + slotIndex);
    }

    public boolean filterTest(ItemStack stack) {
        ItemStack filterItem = ItemStack.m_41712_((CompoundTag)this.nbt.m_128469_("Filter"));
        return FilterItemStack.of((ItemStack)filterItem).test(this.player.m_9236_(), stack);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int pIndex) {
        Slot srcSlot = (Slot)this.f_38839_.get(pIndex);
        if (!srcSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack srcStack = srcSlot.m_7993_();
        if (!this.filterTest(srcStack)) {
            return ItemStack.f_41583_;
        }
        ItemStack copyOfSrcStack = srcStack.m_41777_();
        if (pIndex < this.container.m_6643_() ? !this.m_38903_(srcStack, this.container.m_6643_(), this.container.m_6643_() + 36, true) : !this.m_38903_(srcStack, 0, this.container.m_6643_(), false)) {
            return ItemStack.f_41583_;
        }
        if (srcStack.m_41619_()) {
            srcSlot.m_5852_(ItemStack.f_41583_);
        } else {
            srcSlot.m_6654_();
        }
        return copyOfSrcStack;
    }

    public void sortStorageItems(int startIndex, int endIndex, SortOrder sortOrder) {
        ServerPlayer sp = (ServerPlayer)this.player;
        HashMap<Util.ItemWithNBT, Integer> itemCompMap = new HashMap<Util.ItemWithNBT, Integer>();
        for (int i = startIndex; i < endIndex; ++i) {
            ItemStack stack = this.m_38853_(i).m_7993_();
            if (stack.m_41619_()) continue;
            CompoundTag tag = stack.m_41783_();
            Util.ItemWithNBT key = new Util.ItemWithNBT(stack.m_41720_(), tag);
            itemCompMap.merge(key, stack.m_41613_(), Integer::sum);
        }
        ArrayList sortedItems = new ArrayList(itemCompMap.entrySet());
        switch (sortOrder) {
            case MOD: {
                sortedItems.sort(Comparator.comparing(entry -> Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)((Util.ItemWithNBT)entry.getKey()).item())).toString()).thenComparing(Map.Entry::getValue, Comparator.reverseOrder()));
                break;
            }
            case NAME: {
                sortedItems.sort(Comparator.comparing(entry -> ((Util.ItemWithNBT)entry.getKey()).item().m_7626_(new ItemStack((ItemLike)((Util.ItemWithNBT)entry.getKey()).item())).getString()).thenComparing(entry -> ((Util.ItemWithNBT)entry.getKey()).getDisplayNameString()).thenComparing(Map.Entry::getValue, Comparator.reverseOrder()));
                break;
            }
            default: {
                sortedItems.sort(Map.Entry.comparingByValue().reversed().thenComparing(entry -> ((Util.ItemWithNBT)entry.getKey()).toString()));
            }
        }
        NonNullList compactedList = NonNullList.m_122780_((int)(endIndex - startIndex), (Object)ItemStack.f_41583_);
        int idx = 0;
        for (Map.Entry entry2 : sortedItems) {
            Util.ItemWithNBT key = (Util.ItemWithNBT)entry2.getKey();
            Item item = key.item();
            CompoundTag tag = key.tag();
            int totalCount = (Integer)entry2.getValue();
            int maxStackSize = new ItemStack((ItemLike)item, 1).m_41741_();
            while (totalCount > 0) {
                int stackSize = Math.min(totalCount, maxStackSize);
                ItemStack stack = new ItemStack((ItemLike)item, stackSize);
                if (tag != null) {
                    stack.m_41751_(tag);
                }
                compactedList.set(idx, (Object)stack);
                totalCount -= stackSize;
                ++idx;
            }
        }
        for (int i = 0; i < compactedList.size(); ++i) {
            ItemStack itemStack = (ItemStack)compactedList.get(i);
            Slot slot = this.player.f_36096_.m_38853_(i + startIndex);
            slot.m_5852_(itemStack);
            if (startIndex < this.slotCount) continue;
            sp.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.player.f_36096_.f_38840_, this.m_182424_(), i + startIndex, itemStack));
        }
    }

    private void updateContraptionNbt(Consumer<CompoundTag> editor) {
        Entity entity = this.player.m_9236_().m_6815_(this.contraptionId);
        if (!(entity instanceof AbstractContraptionEntity)) {
            return;
        }
        AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity;
        Contraption contraption = contraptionEntity.getContraption();
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(this.localPos);
        if (info == null) {
            return;
        }
        CompoundTag tag = info.f_74677_();
        editor.accept(tag);
        contraption.getBlocks().put(this.localPos, new StructureTemplate.StructureBlockInfo(info.f_74675_(), info.f_74676_(), tag));
        MountedItemStorage storage = (MountedItemStorage)contraption.getStorage().getMountedItems().storages.get((Object)this.localPos);
        if (storage != null && tag != null) {
            ((StorageBoxMountedStorage)storage).setSortOrder(SortOrder.valueOf(tag.m_128461_("SortOrder")));
        }
    }

    private void setStorageDirty() {
        ModNetwork.sendToServer(new SetMountedStorageDirtyPacket(this.contraptionId, this.localPos));
    }
}

