/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.controller;

import java.util.Objects;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.controller.StorageControllerEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageInterfaceEntity
extends BlockEntity {
    private int tickCount = 0;
    public StorageControllerEntity controller = null;
    private final LazyOptional<IItemHandlerModifiable> lazyItemHandler = LazyOptional.of(() -> new StorageInterfaceHandler(this));

    public StorageInterfaceEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void setController(StorageControllerEntity controller) {
        if (!this.checkController()) {
            this.controller = controller;
        }
    }

    private boolean checkController() {
        if (this.controller != null) {
            BlockEntity controllerCheck = Objects.requireNonNull(this.m_58904_()).m_7702_(this.controller.m_58899_());
            return controllerCheck == this.controller;
        }
        return false;
    }

    public void forgetController() {
        this.controller = null;
    }

    public void serverTick(Level level) {
        if (level.f_46443_) {
            return;
        }
        if (this.tickCount++ < (Integer)ConfigManager.CommonConfig.SIMPLE_STORAGE_NETWORK_UPDATE_TIME.get()) {
            return;
        }
        this.tickCount = 0;
        if (this.controller != null && !this.checkController()) {
            this.forgetController();
        }
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.controller != null ? this.controller.getItemHandler() : new EmptyHandler();
    }

    private record StorageInterfaceHandler(StorageInterfaceEntity storageInterfaceEntity) implements IItemHandlerModifiable
    {
        private IItemHandlerModifiable get() {
            return this.storageInterfaceEntity.getItemHandler();
        }

        public int getSlots() {
            return this.get().getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.get().getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.get().insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.get().extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.get().getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.get().isItemValid(slot, stack);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            this.get().setStackInSlot(slot, stack);
        }
    }
}

