/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.init;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fxnt.fxntstorage.FXNTStorage;
import net.fxnt.fxntstorage.network.handler.ClientPayloadHandler;
import net.fxnt.fxntstorage.network.handler.ServerPayloadHandler;
import net.fxnt.fxntstorage.network.packet.CrossbowChargedPacket;
import net.fxnt.fxntstorage.network.packet.JetpackFlyingPacket;
import net.fxnt.fxntstorage.network.packet.JetpackFuelSyncPacket;
import net.fxnt.fxntstorage.network.packet.KeyPressedPacket;
import net.fxnt.fxntstorage.network.packet.PickBlockUpgradePacket;
import net.fxnt.fxntstorage.network.packet.PlayerInputPacket;
import net.fxnt.fxntstorage.network.packet.SetCarriedPacket;
import net.fxnt.fxntstorage.network.packet.SetMountedStorageDirtyPacket;
import net.fxnt.fxntstorage.network.packet.SetSortOrderPacket;
import net.fxnt.fxntstorage.network.packet.SortInventoryPacket;
import net.fxnt.fxntstorage.network.packet.SyncClientSettingsPacket;
import net.fxnt.fxntstorage.network.packet.SyncContainerPacket;
import net.fxnt.fxntstorage.network.packet.SyncMountedStoragePacket;
import net.fxnt.fxntstorage.network.packet.SyncNBTDataPacket;
import net.fxnt.fxntstorage.network.packet.SyncSlotCountPacket;
import net.fxnt.fxntstorage.network.packet.TransferRecipePacket;
import net.fxnt.fxntstorage.network.packet.VisualJetpackAirPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ModNetwork {
    private static final String PROTOCOL_VERSION = "1";
    private static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fxntstorage", (String)"network"), () -> "1", "1"::equals, "1"::equals);
    private static int pkt = 0;
    private static final Map<String, BiConsumer<Object, Supplier<NetworkEvent.Context>>> HANDLERS = new HashMap<String, BiConsumer<Object, Supplier<NetworkEvent.Context>>>();

    public static void registerCommonPackets() {
        ModNetwork.registerClientboundMessage(JetpackFuelSyncPacket.class, JetpackFuelSyncPacket::encode, JetpackFuelSyncPacket::decode, "handleJetpackFuelSyncPacket");
        ModNetwork.registerClientboundMessage(SetCarriedPacket.class, SetCarriedPacket::encode, SetCarriedPacket::decode, "handleSetCarriedPacket");
        ModNetwork.registerClientboundMessage(SyncContainerPacket.class, SyncContainerPacket::encode, SyncContainerPacket::decode, "handleSyncContainerPacket");
        ModNetwork.registerClientboundMessage(SyncSlotCountPacket.class, SyncSlotCountPacket::encode, SyncSlotCountPacket::decode, "handleSyncSlotCountPacket");
        ModNetwork.registerClientboundMessage(VisualJetpackAirPacket.class, VisualJetpackAirPacket::encode, VisualJetpackAirPacket::decode, "handleVisualJetpackAirPacket");
        ModNetwork.registerClientboundMessage(SyncMountedStoragePacket.class, SyncMountedStoragePacket::encode, SyncMountedStoragePacket::decode, "handleSyncMountedStoragePacket");
        ModNetwork.registerClientboundMessage(SyncNBTDataPacket.class, SyncNBTDataPacket::encode, SyncNBTDataPacket::decode, "handleSyncNBTDataPacket");
        ModNetwork.registerMessage(CrossbowChargedPacket.class, CrossbowChargedPacket::encode, CrossbowChargedPacket::decode, ServerPayloadHandler::handleCrossbowChargedPacket);
        ModNetwork.registerMessage(JetpackFlyingPacket.class, JetpackFlyingPacket::encode, JetpackFlyingPacket::decode, ServerPayloadHandler::handleJetpackFlyingPacket);
        ModNetwork.registerMessage(KeyPressedPacket.class, KeyPressedPacket::encode, KeyPressedPacket::decode, ServerPayloadHandler::handleKeyPressedPacket);
        ModNetwork.registerMessage(PickBlockUpgradePacket.class, PickBlockUpgradePacket::encode, PickBlockUpgradePacket::decode, ServerPayloadHandler::handlePickBlockUpgradePacket);
        ModNetwork.registerMessage(PlayerInputPacket.class, PlayerInputPacket::encode, PlayerInputPacket::decode, ServerPayloadHandler::handlePlayerInputPacket);
        ModNetwork.registerMessage(SetMountedStorageDirtyPacket.class, SetMountedStorageDirtyPacket::encode, SetMountedStorageDirtyPacket::decode, ServerPayloadHandler::handleSetMountedStorageDirtyPacket);
        ModNetwork.registerMessage(SetSortOrderPacket.class, SetSortOrderPacket::encode, SetSortOrderPacket::decode, ServerPayloadHandler::handleSetSortOrderPacket);
        ModNetwork.registerMessage(SortInventoryPacket.class, SortInventoryPacket::encode, SortInventoryPacket::decode, ServerPayloadHandler::handleSortInventoryPacket);
        ModNetwork.registerMessage(SyncClientSettingsPacket.class, SyncClientSettingsPacket::encode, SyncClientSettingsPacket::decode, ServerPayloadHandler::handleSyncClientSettingsPacket);
        ModNetwork.registerMessage(TransferRecipePacket.class, TransferRecipePacket::encode, TransferRecipePacket::decode, ServerPayloadHandler::handleTransferRecipePacket);
    }

    public static <T> void sendToServer(T message) {
        INSTANCE.sendToServer(message);
    }

    public static <T> void sendToPlayer(ServerPlayer player, T message) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <T> void sendToAllTracking(Entity entity, T message) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), message);
    }

    private static void invokeClientHandler(String name, Object message, Supplier<NetworkEvent.Context> ctx) {
        BiConsumer<Object, Supplier<NetworkEvent.Context>> handler = HANDLERS.get(name);
        if (handler != null) {
            handler.accept(message, ctx);
        } else {
            FXNTStorage.LOGGER.error("No handler for message type: {}", (Object)name);
        }
    }

    private static <M> void registerClientboundMessage(Class<M> messageType, BiConsumer<M, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, M> decoder, String handler) {
        INSTANCE.registerMessage(pkt++, messageType, encoder, decoder, (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ModNetwork.lambda$registerClientboundMessage$10(handler, msg, (Supplier)ctx));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }

    private static <M> void registerMessage(Class<M> messageType, BiConsumer<M, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, M> decoder, BiConsumer<M, Supplier<NetworkEvent.Context>> messageConsumer) {
        INSTANCE.registerMessage(pkt++, messageType, encoder, decoder, messageConsumer);
    }

    private static /* synthetic */ void lambda$registerClientboundMessage$10(String handler, Object msg, Supplier ctx) {
        ModNetwork.invokeClientHandler(handler, msg, ctx);
    }

    static {
        HANDLERS.put("handleJetpackFuelSyncPacket", (msg, ctx) -> ClientPayloadHandler.handleJetpackFuelSyncPacket((JetpackFuelSyncPacket)msg, ctx));
        HANDLERS.put("handleSetCarriedPacket", (msg, ctx) -> ClientPayloadHandler.handleSetCarriedPacket((SetCarriedPacket)msg, ctx));
        HANDLERS.put("handleSyncContainerPacket", (msg, ctx) -> ClientPayloadHandler.handleSyncContainerPacket((SyncContainerPacket)msg, ctx));
        HANDLERS.put("handleSyncSlotCountPacket", (msg, ctx) -> ClientPayloadHandler.handleSyncSlotCountPacket((SyncSlotCountPacket)msg, ctx));
        HANDLERS.put("handleVisualJetpackAirPacket", (msg, ctx) -> ClientPayloadHandler.handleVisualJetpackAirPacket((VisualJetpackAirPacket)msg, ctx));
        HANDLERS.put("handleSyncMountedStoragePacket", (msg, ctx) -> ClientPayloadHandler.handleSyncMountedStoragePacket((SyncMountedStoragePacket)msg, ctx));
        HANDLERS.put("handleSyncNBTDataPacket", (msg, ctx) -> ClientPayloadHandler.handleSyncNBTDataPacket((SyncNBTDataPacket)msg, ctx));
    }
}

