/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.network.handler;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import java.util.function.Supplier;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.backpack.main.BackpackItemMenu;
import net.fxnt.fxntstorage.backpack.main.BackpackMenu;
import net.fxnt.fxntstorage.backpack.upgrade.JetpackHandler;
import net.fxnt.fxntstorage.backpack.upgrade.JetpackManager;
import net.fxnt.fxntstorage.container.StorageBox;
import net.fxnt.fxntstorage.network.packet.JetpackFuelSyncPacket;
import net.fxnt.fxntstorage.network.packet.SetCarriedPacket;
import net.fxnt.fxntstorage.network.packet.SyncContainerPacket;
import net.fxnt.fxntstorage.network.packet.SyncMountedStoragePacket;
import net.fxnt.fxntstorage.network.packet.SyncNBTDataPacket;
import net.fxnt.fxntstorage.network.packet.SyncSlotCountPacket;
import net.fxnt.fxntstorage.network.packet.VisualJetpackAirPacket;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBox;
import net.fxnt.fxntstorage.simple_storage.mounted.SimpleStorageBoxMountedMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkEvent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;

public class ClientPayloadHandler {
    public static void handleSetCarriedPacket(SetCarriedPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().isClient()) {
                Minecraft client = Minecraft.m_91087_();
                client.execute(() -> {
                    if (client.f_91074_ != null) {
                        client.f_91074_.f_36096_.m_142503_(packet.stack());
                    }
                });
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void handleSyncNBTDataPacket(SyncNBTDataPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().isClient()) {
                Minecraft client = Minecraft.m_91087_();
                client.execute(() -> {
                    if (client.f_91074_ != null) {
                        AbstractContainerMenu patt2508$temp;
                        ItemStack selectedItem = client.f_91074_.m_21205_();
                        if (selectedItem.m_41720_() instanceof BackpackItem) {
                            selectedItem.m_41751_(packet.stack().m_41783_());
                        }
                        if ((patt2508$temp = client.f_91074_.f_36096_) instanceof BackpackItemMenu) {
                            BackpackItemMenu backpackItemMenu = (BackpackItemMenu)patt2508$temp;
                            backpackItemMenu.setTag(packet.stack().m_41783_());
                        }
                    }
                });
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void handleSyncContainerPacket(SyncContainerPacket packet, @NotNull Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().isClient()) {
                Minecraft client = Minecraft.m_91087_();
                if (client.f_91074_ != null && client.f_91074_.f_36096_ instanceof BackpackMenu && client.f_91074_.f_36096_.f_38840_ == packet.containerId()) {
                    ItemStackHandler itemHandler = ((BackpackMenu)client.f_91074_.f_36096_).container.getItemHandler();
                    for (int i = 0; i < packet.items().size(); ++i) {
                        itemHandler.setStackInSlot(i, (ItemStack)packet.items().get(i));
                    }
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void handleSyncSlotCountPacket(SyncSlotCountPacket packet, @NotNull Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().isClient()) {
                Minecraft client = Minecraft.m_91087_();
                if (client.f_91074_ != null && client.f_91074_.f_36096_ instanceof BackpackMenu && client.f_91074_.f_36096_.f_38840_ == packet.containerId()) {
                    ItemStackHandler itemHandler = ((BackpackMenu)client.f_91074_.f_36096_).container.getItemHandler();
                    itemHandler.setStackInSlot(packet.slot(), packet.stack());
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void handleVisualJetpackAirPacket(VisualJetpackAirPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().isClient()) {
                Minecraft client = Minecraft.m_91087_();
                client.execute(() -> {
                    if (client.f_91074_ != null) {
                        if (packet.airRemaining() < 0) {
                            client.f_91074_.getPersistentData().m_128473_("VisualJetpackAir");
                        } else {
                            client.f_91074_.getPersistentData().m_128405_("VisualJetpackAir", packet.airRemaining());
                        }
                    }
                });
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void handleSyncMountedStoragePacket(SyncMountedStoragePacket packet, @NotNull Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().isClient()) {
                Minecraft client = Minecraft.m_91087_();
                if (client.f_91073_ == null) {
                    return;
                }
                Entity entity = client.f_91073_.m_6815_(packet.contraptionId());
                if (entity instanceof AbstractContraptionEntity) {
                    SimpleStorageBoxMountedMenu menu;
                    BlockState newState;
                    AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity;
                    StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)contraptionEntity.getContraption().getBlocks().get(packet.localPos());
                    CompoundTag newNbt = blockInfo.f_74677_();
                    CompoundTag nbt = packet.nbt();
                    BlockState oldState = blockInfo.f_74676_();
                    newNbt.m_128405_("StoredAmount", nbt.m_128451_("StoredAmount"));
                    newNbt.m_128379_("VoidUpgrade", nbt.m_128471_("VoidUpgrade"));
                    newNbt.m_128405_("MaxItemCapacity", nbt.m_128451_("MaxItemCapacity"));
                    if (oldState.m_60734_() instanceof SimpleStorageBox) {
                        if (nbt.m_128425_("FilterItem", 10)) {
                            newNbt.m_128365_("FilterItem", (Tag)nbt.m_128469_("FilterItem"));
                        }
                        newState = (BlockState)oldState.m_61124_(SimpleStorageBox.STORAGE_USED, (Comparable)((Object)packet.fillLevel()));
                    } else {
                        newNbt.m_128350_("PercentageUsed", nbt.m_128457_("PercentageUsed"));
                        newState = (BlockState)((BlockState)oldState.m_61124_(StorageBox.STORAGE_USED, (Comparable)((Object)packet.fillLevel()))).m_61124_((Property)StorageBox.VOID_UPGRADE, (Comparable)Boolean.valueOf(nbt.m_128471_("VoidUpgrade")));
                    }
                    AbstractContainerMenu patt7297$temp = client.f_91074_.f_36096_;
                    if (patt7297$temp instanceof SimpleStorageBoxMountedMenu && (menu = (SimpleStorageBoxMountedMenu)patt7297$temp).getLocalPos().equals((Object)packet.localPos())) {
                        menu.setFilterItem(ItemStack.m_41712_((CompoundTag)newNbt.m_128469_("FilterItem")));
                    }
                    StructureTemplate.StructureBlockInfo newInfo = new StructureTemplate.StructureBlockInfo(blockInfo.f_74675_(), newState, newNbt);
                    contraptionEntity.getContraption().getBlocks().put(packet.localPos(), newInfo);
                    contraptionEntity.getContraption().resetClientContraption();
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void handleJetpackFuelSyncPacket(JetpackFuelSyncPacket packet, @NonNull Supplier<// Could not load outer class - annotation placement on inner may be incorrect
    NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().isClient()) {
                Minecraft client = Minecraft.m_91087_();
                if (client.f_91074_ != null) {
                    client.execute(() -> {
                        JetpackHandler handler = JetpackManager.getJetpackHandler((Player)client.f_91074_);
                        if (handler != null) {
                            handler.onFuelSync(packet.fuelRemaining(), packet.serverTime());
                        }
                    });
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

