/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.network.handler;

import com.simibubi.create.api.contraption.storage.item.MountedItemStorage;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fxnt.fxntstorage.FXNTStorage;
import net.fxnt.fxntstorage.backpack.main.BackpackContainer;
import net.fxnt.fxntstorage.backpack.main.BackpackMenu;
import net.fxnt.fxntstorage.backpack.upgrade.BackpackOnBackUpgradeHandler;
import net.fxnt.fxntstorage.backpack.upgrade.JetpackHandler;
import net.fxnt.fxntstorage.backpack.upgrade.JetpackManager;
import net.fxnt.fxntstorage.backpack.util.BackpackHandler;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.fxnt.fxntstorage.container.StorageBoxMenu;
import net.fxnt.fxntstorage.container.mounted.StorageBoxMountedMenu;
import net.fxnt.fxntstorage.container.mounted.StorageBoxMountedStorage;
import net.fxnt.fxntstorage.network.packet.CrossbowChargedPacket;
import net.fxnt.fxntstorage.network.packet.JetpackFlyingPacket;
import net.fxnt.fxntstorage.network.packet.KeyPressedPacket;
import net.fxnt.fxntstorage.network.packet.PickBlockUpgradePacket;
import net.fxnt.fxntstorage.network.packet.PlayerInputPacket;
import net.fxnt.fxntstorage.network.packet.SetMountedStorageDirtyPacket;
import net.fxnt.fxntstorage.network.packet.SetSortOrderPacket;
import net.fxnt.fxntstorage.network.packet.SortInventoryPacket;
import net.fxnt.fxntstorage.network.packet.SyncClientSettingsPacket;
import net.fxnt.fxntstorage.network.packet.TransferRecipePacket;
import net.fxnt.fxntstorage.simple_storage.mounted.SimpleStorageBoxMountedStorage;
import net.fxnt.fxntstorage.util.EventHandler;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class ServerPayloadHandler {
    public static void handleCrossbowChargedPacket(CrossbowChargedPacket packet, @NotNull Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> EventHandler.consumeArrowFromBackpack((Player)((NetworkEvent.Context)context.get()).getSender()));
    }

    public static void handleKeyPressedPacket(KeyPressedPacket packet, @NotNull Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player != null) {
                switch (packet.hotkey()) {
                    case 0: {
                        JetpackManager.getJetpackHandler((Player)player).flyingOnKeyPress();
                        break;
                    }
                    case 1: {
                        JetpackManager.getJetpackHandler((Player)player).flyingOnKeyRelease();
                        break;
                    }
                    case 2: {
                        BackpackHandler.openBackpackFromInventory(player, (byte)1);
                        break;
                    }
                    case 3: {
                        if (!(player.f_36096_ instanceof BackpackMenu)) break;
                        player.m_6915_();
                        break;
                    }
                    case 4: {
                        AbstractContainerMenu patt3434$temp = player.f_36096_;
                        if (!(patt3434$temp instanceof BackpackMenu)) break;
                        BackpackMenu backpackMenu = (BackpackMenu)patt3434$temp;
                        backpackMenu.ctrlKeyDown = packet.pressed();
                        break;
                    }
                    case 5: {
                        JetpackHandler jetpackHandler = JetpackManager.getJetpackHandler((Player)player);
                        if (!(jetpackHandler.calculateJetPackFuel((Player)player) > 0.0)) break;
                        jetpackHandler.toggleHover();
                        break;
                    }
                    case 6: {
                        player.getPersistentData().m_128469_("fxntstorageSettings").m_128379_("MineAllBlocks", packet.pressed());
                    }
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void handlePickBlockUpgradePacket(PickBlockUpgradePacket packet, @NotNull Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player != null) {
                new BackpackOnBackUpgradeHandler((Player)player).applyPickBlockUpgrade(packet.stack());
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void handlePlayerInputPacket(PlayerInputPacket packet, @NotNull Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player != null) {
                JetpackManager.getJetpackHandler((Player)player).processPlayerInputPacket(packet.forwardImpulse(), packet.leftImpulse());
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void handleSetMountedStorageDirtyPacket(SetMountedStorageDirtyPacket packet, @NotNull Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Entity entity;
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player != null && (entity = player.m_9236_().m_6815_(packet.contraptionId())) instanceof AbstractContraptionEntity) {
                AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity;
                MountedItemStorage storage = (MountedItemStorage)contraptionEntity.getContraption().getStorage().getAllItemStorages().get((Object)packet.localPos());
                if (storage instanceof SimpleStorageBoxMountedStorage) {
                    ((SimpleStorageBoxMountedStorage)storage).markDirty();
                } else if (storage instanceof StorageBoxMountedStorage) {
                    ((StorageBoxMountedStorage)storage).markDirty();
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void handleSetSortOrderPacket(SetSortOrderPacket packet, @NotNull Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player != null) {
                AbstractContainerMenu patt6868$temp;
                AbstractContainerMenu patt6715$temp;
                AbstractContainerMenu menu;
                AbstractContainerMenu patt6501$temp = player.f_36096_;
                if (patt6501$temp instanceof BackpackMenu) {
                    menu = (BackpackMenu)patt6501$temp;
                    menu.container.setSortOrder(packet.sortOrder());
                    menu.container.setDataChanged();
                }
                if ((patt6715$temp = player.f_36096_) instanceof StorageBoxMenu) {
                    menu = (StorageBoxMenu)patt6715$temp;
                    menu.setSortOrder(packet.sortOrder());
                }
                if ((patt6868$temp = player.f_36096_) instanceof StorageBoxMountedMenu) {
                    menu = (StorageBoxMountedMenu)patt6868$temp;
                    menu.setSortOrder(packet.sortOrder());
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void handleSortInventoryPacket(SortInventoryPacket packet, @NotNull Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player != null) {
                AbstractContainerMenu menu;
                AbstractContainerMenu patt7496$temp;
                byte sortType = packet.invType();
                if (sortType == 0 && (patt7496$temp = player.f_36096_) instanceof BackpackMenu) {
                    menu = (BackpackMenu)patt7496$temp;
                    menu.sortBackpackItems(packet.slotStart(), packet.slotEnd(), packet.sortOrder());
                }
                if (sortType == 1) {
                    AbstractContainerMenu patt8007$temp;
                    AbstractContainerMenu patt7776$temp = player.f_36096_;
                    if (patt7776$temp instanceof StorageBoxMenu) {
                        menu = (StorageBoxMenu)patt7776$temp;
                        menu.sortStorageItems(packet.slotStart(), packet.slotEnd(), packet.sortOrder());
                    }
                    if ((patt8007$temp = player.f_36096_) instanceof StorageBoxMountedMenu) {
                        menu = (StorageBoxMountedMenu)patt8007$temp;
                        menu.sortStorageItems(packet.slotStart(), packet.slotEnd(), packet.sortOrder());
                    }
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void handleSyncClientSettingsPacket(SyncClientSettingsPacket packet, @NotNull Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player != null) {
                CompoundTag settings = packet.settings();
                CompoundTag settingsTag = Util.getOrCreateSubTag(player.getPersistentData(), "fxntstorageSettings");
                settingsTag.m_128391_(settings);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void handleTransferRecipePacket(TransferRecipePacket packet, @NotNull Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            block34: {
                List inputSlots;
                AbstractContainerMenu patt10141$temp;
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                if (player == null) break block34;
                Level level = player.m_9236_();
                ResourceLocation recipeId = packet.recipeId();
                Optional optional = level.m_7465_().m_44043_(recipeId);
                if (optional.isEmpty()) {
                    FXNTStorage.LOGGER.warn("Recipe not found: {}", (Object)recipeId);
                    return;
                }
                Recipe recipe = (Recipe)optional.get();
                Inventory playerInv = player.m_150109_();
                ItemStackHandler itemHandler = null;
                BackpackContainer container = null;
                ItemStack backpack = BackpackHelper.getEquippedBackpackStack((LivingEntity)player);
                if (!backpack.m_41619_()) {
                    container = new BackpackContainer(backpack, (Player)player);
                    itemHandler = container.getItemHandler();
                }
                if ((patt10141$temp = player.f_36096_) instanceof CraftingMenu) {
                    CraftingMenu openMenu = (CraftingMenu)patt10141$temp;
                    inputSlots = openMenu.f_38839_.subList(1, 10);
                } else {
                    AbstractContainerMenu patt10289$temp = player.f_36096_;
                    if (patt10289$temp instanceof StonecutterMenu) {
                        StonecutterMenu openMenu = (StonecutterMenu)patt10289$temp;
                        inputSlots = openMenu.f_38839_.subList(0, 1);
                    } else {
                        AbstractContainerMenu patt10439$temp = player.f_36096_;
                        if (patt10439$temp instanceof InventoryMenu) {
                            InventoryMenu openMenu = (InventoryMenu)patt10439$temp;
                            inputSlots = openMenu.f_38839_.subList(1, 5);
                        } else {
                            return;
                        }
                    }
                }
                for (Slot slot : inputSlots) {
                    ItemStack stack;
                    if (!slot.m_8010_((Player)player) || !slot.m_6657_() || playerInv.m_36054_(stack = slot.m_6201_(slot.m_7993_().m_41613_()))) continue;
                    player.m_36176_(stack, false);
                }
                List<Ingredient> ingredients = recipe.m_7527_().stream().filter(ingredient -> !ingredient.m_43947_()).toList();
                List<Integer> recipeMap = packet.recipeList();
                int maxCraftable = 1;
                if (packet.maxTransfer()) {
                    maxCraftable = ServerPayloadHandler.getMaxCraftableItems(ingredients, playerInv, (IItemHandler)itemHandler);
                    if (!FMLEnvironment.production) {
                        player.m_5661_((Component)Component.m_237113_((String)("\u00a7a" + maxCraftable + "\u00a7r maximum craftable")), false);
                    }
                }
                boolean twoByTwo = false;
                boolean symmetrical = false;
                if (recipe instanceof ShapedRecipe) {
                    ShapedRecipe sr = (ShapedRecipe)recipe;
                    twoByTwo = sr.m_44221_() <= 2 && sr.m_44220_() <= 2 && player.f_36096_ instanceof InventoryMenu;
                    symmetrical = Util.isSymmetrical(sr.m_44220_(), sr.m_44221_(), sr.m_7527_());
                }
                int offsetX = 0;
                int offsetY = 0;
                boolean isShaped = recipe instanceof ShapedRecipe;
                boolean doCenter = false;
                if (!twoByTwo && isShaped && symmetrical) {
                    ShapedRecipe sr = (ShapedRecipe)recipe;
                    offsetX = (3 - sr.m_44220_()) / 2;
                    offsetY = (3 - sr.m_44221_()) / 2;
                    doCenter = true;
                }
                for (int ingredientIndex = 0; ingredientIndex < ingredients.size() && ingredientIndex < recipeMap.size(); ++ingredientIndex) {
                    ItemStack extracted;
                    int extractAmount;
                    ItemStack stack;
                    int j;
                    int slotPosition;
                    Ingredient ingredient2;
                    block36: {
                        int gridSlotPosition;
                        block35: {
                            ingredient2 = ingredients.get(ingredientIndex);
                            if (ingredient2.m_43947_()) continue;
                            gridSlotPosition = recipeMap.get(ingredientIndex) - 1;
                            if (!twoByTwo) break block35;
                            switch (gridSlotPosition) {
                                case 0: {
                                    slotPosition = 0;
                                    break block36;
                                }
                                case 1: {
                                    slotPosition = 1;
                                    break block36;
                                }
                                case 3: {
                                    slotPosition = 2;
                                    break block36;
                                }
                                case 4: {
                                    slotPosition = 3;
                                    break block36;
                                }
                            }
                            continue;
                        }
                        if (doCenter) {
                            int x = gridSlotPosition % 3;
                            int y = gridSlotPosition / 3;
                            slotPosition = (y += offsetY) * 3 + (x += offsetX);
                        } else {
                            slotPosition = gridSlotPosition;
                        }
                    }
                    if (slotPosition < 0 || slotPosition >= inputSlots.size()) continue;
                    ItemStack collected = ItemStack.f_41583_;
                    int remaining = maxCraftable;
                    for (j = 0; j < playerInv.m_6643_() && remaining > 0; ++j) {
                        stack = playerInv.m_8020_(j);
                        if (stack.m_41619_() || !ingredient2.test(stack)) continue;
                        extractAmount = Math.min(stack.m_41613_(), remaining);
                        extracted = stack.m_41620_(extractAmount);
                        if (collected.m_41619_()) {
                            collected = extracted.m_41777_();
                        } else {
                            collected.m_41769_(extracted.m_41613_());
                        }
                        playerInv.m_6836_(j, stack);
                        remaining -= extracted.m_41613_();
                    }
                    if (remaining > 0 && itemHandler != null) {
                        for (j = 0; j < Util.ITEM_SLOT_END_RANGE && remaining > 0; ++j) {
                            stack = itemHandler.getStackInSlot(j);
                            if (stack.m_41619_() || !ingredient2.test(stack)) continue;
                            extractAmount = Math.min(stack.m_41613_(), remaining);
                            extracted = stack.m_41620_(extractAmount);
                            if (collected.m_41619_()) {
                                collected = extracted.m_41777_();
                            } else {
                                collected.m_41769_(extracted.m_41613_());
                            }
                            itemHandler.setStackInSlot(j, stack);
                            remaining -= extracted.m_41613_();
                        }
                    }
                    if (collected.m_41619_() || collected.m_41613_() < maxCraftable) {
                        return;
                    }
                    ((Slot)inputSlots.get(slotPosition)).m_269060_(collected);
                }
                AbstractContainerMenu handler = player.f_36096_;
                Slot output = handler.m_38853_(0);
                byte action = packet.action();
                if (action == 1) {
                    handler.m_150399_(output.m_150661_(), 0, ClickType.PICKUP, (Player)player);
                } else if (action == 2) {
                    handler.m_150399_(output.m_150661_(), 0, ClickType.QUICK_MOVE, (Player)player);
                }
                player.f_36096_.m_38946_();
                if (container != null) {
                    container.setDataChanged();
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    private static int getMaxCraftableItems(List<Ingredient> ingredients, Inventory inventory, @Nullable IItemHandler backpack) {
        int maxCrafts = 64;
        HashMap<Ingredient, Integer> ingredientCounts = new HashMap<Ingredient, Integer>();
        for (Ingredient ingredient : ingredients) {
            if (ingredient.m_43947_()) continue;
            ingredientCounts.merge(ingredient, 1, Integer::sum);
        }
        for (Map.Entry entry : ingredientCounts.entrySet()) {
            int craftsForIngredient;
            ItemStack stack;
            int i;
            Ingredient ingredient = (Ingredient)entry.getKey();
            int requiredPerCraft = (Integer)entry.getValue();
            int available = 0;
            int ingredientMaxStackSize = 64;
            for (i = 0; i < inventory.m_6643_(); ++i) {
                stack = inventory.m_8020_(i);
                if (stack.m_41619_() || !ingredient.test(stack)) continue;
                available += stack.m_41613_();
                ingredientMaxStackSize = Math.min(ingredientMaxStackSize, stack.m_41741_());
            }
            if (backpack != null) {
                for (i = 0; i < backpack.getSlots(); ++i) {
                    stack = backpack.getStackInSlot(i);
                    if (stack.m_41619_() || !ingredient.test(stack)) continue;
                    available += stack.m_41613_();
                    ingredientMaxStackSize = Math.min(ingredientMaxStackSize, stack.m_41741_());
                }
            }
            if ((maxCrafts = Math.min(maxCrafts, craftsForIngredient = Math.min(available / requiredPerCraft, ingredientMaxStackSize))) != 0) continue;
            break;
        }
        return maxCrafts;
    }

    public static void handleJetpackFlyingPacket(JetpackFlyingPacket packet, @NotNull Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player != null) {
                JetpackManager.getJetpackHandler((Player)player).processPlayerFlyingPacket(packet.flying(), packet.hovering());
            }
        });
        context.get().setPacketHandled(true);
    }
}

