/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.simple_storage.mounted;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.Objects;
import java.util.function.Consumer;
import net.fxnt.fxntstorage.init.ModItems;
import net.fxnt.fxntstorage.init.ModMenuTypes;
import net.fxnt.fxntstorage.init.ModNetwork;
import net.fxnt.fxntstorage.network.packet.SetMountedStorageDirtyPacket;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class SimpleStorageBoxMountedMenu
extends AbstractContainerMenu {
    private final Container container;
    private final CompoundTag nbt;
    private final Player player;
    private final int contraptionId;
    private final BlockPos localPos;

    public SimpleStorageBoxMountedMenu(int containerId, Inventory playerInventory, FriendlyByteBuf buf) {
        this(containerId, playerInventory, (Container)new SimpleContainer(SimpleStorageBoxEntity.SLOT_COUNT), buf.readInt(), buf.m_130135_(), Objects.requireNonNull(buf.m_130260_()));
    }

    public SimpleStorageBoxMountedMenu(int containerId, Inventory playerInventory, Container container, int contraptionId, BlockPos localPos, CompoundTag nbt) {
        super((MenuType)ModMenuTypes.SIMPLE_STORAGE_BOX_MOUNTED_MENU.get(), containerId);
        int x;
        int y;
        this.nbt = nbt;
        this.container = container;
        this.player = playerInventory.f_35978_;
        this.contraptionId = contraptionId;
        this.localPos = localPos;
        container.m_5856_(playerInventory.f_35978_);
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return SimpleStorageBoxMountedMenu.this.getStoredAmount();
            }

            public void m_6422_(int i) {
                SimpleStorageBoxMountedMenu.this.setStoredAmount(i);
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return SimpleStorageBoxMountedMenu.this.getMaxItemCapacity();
            }

            public void m_6422_(int i) {
                SimpleStorageBoxMountedMenu.this.setMaxItemCapacity(i);
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return SimpleStorageBoxMountedMenu.this.getVoidUpgrade() ? 1 : 0;
            }

            public void m_6422_(int i) {
                SimpleStorageBoxMountedMenu.this.setVoidUpgrade(i);
            }
        });
        this.m_38897_(new Slot(container, 1, 8, 20){

            public boolean m_5857_(ItemStack stack) {
                if (this.m_6657_()) {
                    return false;
                }
                return stack.m_150930_((Item)ModItems.STORAGE_BOX_VOID_UPGRADE.get());
            }

            public int m_6641_() {
                return 1;
            }
        });
        for (int i = 0; i < 9; ++i) {
            int slot = i + 2;
            y = 58;
            x = 8;
            this.m_38897_(new Slot(container, slot, x + 18 * i, y){

                public boolean m_5857_(ItemStack stack) {
                    if (this.m_6657_()) {
                        return false;
                    }
                    return stack.m_150930_((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get());
                }

                public int m_6641_() {
                    return 1;
                }

                public int m_5866_(ItemStack pStack) {
                    return 1;
                }

                public void m_6654_() {
                    super.m_6654_();
                    SimpleStorageBoxMountedMenu.this.setStorageDirty();
                }
            });
        }
        int xOffset = 8;
        int yOffset = 94;
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, y * 9 + x + 9, xOffset + 18 * x, yOffset + y * 18));
            }
        }
        yOffset = yOffset + 54 + 4;
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, xOffset + i * 18, yOffset));
        }
    }

    public void m_150399_(int slotId, int button, ClickType clickType, Player player) {
        int upgrades;
        ItemStack itemStack;
        int playerStartSlot = 10;
        if (slotId >= 0 && slotId < playerStartSlot && (itemStack = ((Slot)this.f_38839_.get(slotId)).m_7993_()).m_150930_((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get()) && (upgrades = this.getCapacityUpgrades()) > 0) {
            int storedAmount = this.getStoredAmount();
            int stackSize = 64;
            if (!this.container.m_8020_(0).m_41619_()) {
                stackSize = this.container.m_8020_(0).m_41741_();
            }
            int capacityCheck = 32;
            for (int i = 0; i < upgrades - 1; ++i) {
                capacityCheck *= 2;
            }
            if ((capacityCheck *= stackSize) < storedAmount) {
                return;
            }
        }
        super.m_150399_(slotId, button, clickType, player);
    }

    private int getCapacityUpgrades() {
        int count = 0;
        for (int i = 1; i < 10; ++i) {
            ItemStack stack = ((Slot)this.f_38839_.get(i)).m_7993_();
            if (stack.m_41619_() || !stack.m_150930_((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get())) continue;
            ++count;
        }
        return count;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack slotStack = ((Slot)this.f_38839_.get(index)).m_7993_();
        int playerStartSlot = 10;
        if (index < playerStartSlot) {
            int playerSlot = player.m_150109_().m_36050_(slotStack);
            if (playerSlot == -1) {
                playerSlot = player.m_150109_().m_36062_();
            }
            if (playerSlot > -1) {
                ItemStack playerStack = player.m_150109_().m_8020_(playerSlot);
                if (playerStack.m_41619_()) {
                    player.m_150109_().m_6836_(playerSlot, slotStack.m_255036_(1));
                } else {
                    playerStack.m_41769_(1);
                }
                slotStack.m_41774_(1);
                this.container.m_6596_();
                player.m_150109_().m_6596_();
                this.setStorageDirty();
                return ItemStack.f_41583_;
            }
        } else if (slotStack.m_150930_((Item)ModItems.STORAGE_BOX_VOID_UPGRADE.get())) {
            if (!((Slot)this.f_38839_.get(0)).m_6657_()) {
                ((Slot)this.f_38839_.get(0)).m_5852_(slotStack.m_255036_(1));
                slotStack.m_41774_(1);
                this.container.m_6596_();
                player.m_150109_().m_6596_();
                return slotStack;
            }
        } else if (slotStack.m_150930_((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get())) {
            for (int i = 1; i <= 9; ++i) {
                if (((Slot)this.f_38839_.get(i)).m_6657_()) continue;
                ((Slot)this.f_38839_.get(i)).m_5852_(slotStack.m_255036_(1));
                slotStack.m_41774_(1);
                this.container.m_6596_();
                player.m_150109_().m_6596_();
                return slotStack;
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public BlockPos getLocalPos() {
        return this.localPos;
    }

    public void setFilterItem(ItemStack stack) {
        this.nbt.m_128365_("FilterItem", (Tag)stack.m_255036_(1).m_41739_(new CompoundTag()));
    }

    public ItemStack getFilterItem() {
        CompoundTag filterTag = this.nbt.m_128469_("FilterItem");
        if (filterTag.m_128456_() || !filterTag.m_128425_("id", 8)) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)this.nbt.m_128469_("FilterItem"));
    }

    public int getStoredAmount() {
        if (this.player.m_9236_().f_46443_) {
            return this.nbt.m_128451_("StoredAmount");
        }
        return this.container.m_8020_(0).m_41613_();
    }

    public void setStoredAmount(int value) {
        this.nbt.m_128405_("StoredAmount", value);
        this.updateContraptionNbt(tag -> tag.m_128405_("StoredAmount", value));
    }

    public int getMaxItemCapacity() {
        int upgradeCount = 0;
        for (int i = 2; i < 11; ++i) {
            if (!this.container.m_8020_(i).m_150930_((Item)ModItems.STORAGE_BOX_CAPACITY_UPGRADE.get())) continue;
            ++upgradeCount;
        }
        int maxCapacity = 32 << upgradeCount;
        int stackSize = this.getFilterItem().m_41619_() ? 64 : this.getFilterItem().m_41741_();
        return maxCapacity * stackSize;
    }

    public void setMaxItemCapacity(int value) {
        this.nbt.m_128405_("MaxItemCapacity", value);
        this.updateContraptionNbt(tag -> tag.m_128405_("MaxItemCapacity", value));
    }

    public boolean getVoidUpgrade() {
        return !this.container.m_8020_(1).m_41619_();
    }

    public void setVoidUpgrade(int value) {
        this.nbt.m_128379_("VoidUpgrade", value != 0);
        this.updateContraptionNbt(tag -> tag.m_128379_("VoidUpgrade", value != 0));
    }

    public Container getContainer() {
        return this.container;
    }

    private void updateContraptionNbt(Consumer<CompoundTag> editor) {
        Entity entity = this.player.m_9236_().m_6815_(this.contraptionId);
        if (!(entity instanceof AbstractContraptionEntity)) {
            return;
        }
        AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity;
        Contraption contraption = contraptionEntity.getContraption();
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(this.localPos);
        if (info == null) {
            return;
        }
        CompoundTag tag = info.f_74677_();
        editor.accept(tag);
        contraption.getBlocks().put(this.localPos, new StructureTemplate.StructureBlockInfo(info.f_74675_(), info.f_74676_(), tag));
    }

    private void setStorageDirty() {
        ModNetwork.sendToServer(new SetMountedStorageDirtyPacket(this.contraptionId, this.localPos));
    }
}

