/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.storage_network;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fxnt.fxntstorage.config.ConfigManager;
import net.fxnt.fxntstorage.controller.StorageControllerEntity;
import net.fxnt.fxntstorage.controller.StorageInterfaceEntity;
import net.fxnt.fxntstorage.init.ModTags;
import net.fxnt.fxntstorage.simple_storage.SimpleStorageBoxEntity;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StorageNetwork {
    private final StorageControllerEntity controller;
    @Nullable
    private Level level;
    private BlockPos controllerPos;
    private final int searchRange = (Integer)ConfigManager.CommonConfig.SIMPLE_STORAGE_NETWORK_RANGE.get();
    private Set<BlockPos> components = new HashSet<BlockPos>();
    public NonNullList<StorageNetworkItem> boxes = NonNullList.m_122779_();
    private int networkVersion = 0;
    private int tickCount = 0;
    private Set<ItemStack> filterItems = new HashSet<ItemStack>();
    private final IItemHandlerModifiable itemHandler = new NetworkItemHandler();

    public StorageNetwork(StorageControllerEntity controller) {
        this.controller = controller;
        this.level = controller.m_58904_();
        this.controllerPos = controller.m_58899_();
        this.components = this.getConnectedComponents(this.level, this.controllerPos);
        this.getBoxes(this.level, this.components);
    }

    public void tick() {
        this.checkBoxes();
        if (this.tickCount++ < (Integer)ConfigManager.CommonConfig.SIMPLE_STORAGE_NETWORK_UPDATE_TIME.get()) {
            return;
        }
        this.tickCount = 0;
        this.refreshStorageNetwork();
    }

    private void refreshStorageNetwork() {
        this.level = this.controller.m_58904_();
        this.controllerPos = this.controller.m_58899_();
        Set<BlockPos> newComponents = this.getConnectedComponents(this.level, this.controllerPos);
        if (!newComponents.equals(this.components)) {
            HashSet<BlockPos> oldComponents = new HashSet<BlockPos>(this.components);
            oldComponents.removeAll(newComponents);
            for (BlockPos removedPos : oldComponents) {
                BlockEntity blockEntity = this.level.m_7702_(removedPos);
                if (!(blockEntity instanceof StorageInterfaceEntity)) continue;
                StorageInterfaceEntity storageInterface = (StorageInterfaceEntity)blockEntity;
                storageInterface.forgetController();
            }
            this.components = newComponents;
            this.networkVersion = (this.networkVersion + 1) % 1000;
        }
        this.getBoxes(this.level, this.components);
        Set<ItemStack> newFilterItems = this.getCurrentFilters();
        if (!this.areFilterSetsEqual(this.filterItems, newFilterItems)) {
            this.filterItems = newFilterItems;
        }
    }

    private boolean areFilterSetsEqual(Set<ItemStack> oldSet, Set<ItemStack> newSet) {
        if (oldSet.size() != newSet.size()) {
            return false;
        }
        for (ItemStack oldStack : oldSet) {
            boolean found = false;
            for (ItemStack newStack : newSet) {
                if (!ItemStack.m_150942_((ItemStack)oldStack, (ItemStack)newStack)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private void checkBoxes() {
        if (this.level == null) {
            return;
        }
        boolean networkChanged = false;
        for (StorageNetworkItem networkItem : this.boxes) {
            SimpleStorageBoxEntity boxEntity;
            BlockEntity blockEntity = this.level.m_7702_(networkItem.blockPos);
            if (blockEntity instanceof SimpleStorageBoxEntity && ((Object)((Object)(boxEntity = (SimpleStorageBoxEntity)blockEntity))).equals((Object)networkItem.simpleStorageBoxEntity)) continue;
            networkChanged = true;
            break;
        }
        if (networkChanged) {
            this.refreshStorageNetwork();
        }
    }

    private Set<ItemStack> getCurrentFilters() {
        HashSet<ItemStack> items = new HashSet<ItemStack>();
        for (StorageNetworkItem box : this.boxes) {
            ItemStack filterItem = box.simpleStorageBoxEntity.getFilterItem();
            if (filterItem.m_41619_()) continue;
            items.add(filterItem.m_41777_());
        }
        return items;
    }

    private Set<BlockPos> getConnectedComponents(@Nullable Level level, BlockPos origin) {
        if (level == null) {
            return new HashSet<BlockPos>();
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        positions.add(origin);
        int lastCheckedPos = 0;
        for (int distanceToController = 0; distanceToController < this.searchRange && lastCheckedPos < positions.size(); ++lastCheckedPos, ++distanceToController) {
            int i = lastCheckedPos;
            while (i < positions.size()) {
                BlockPos checkPos = (BlockPos)positions.get(i);
                for (Direction direction : Direction.values()) {
                    BlockPos pos = checkPos.m_121945_(direction);
                    if (!this.isNetworkComponent(level.m_8055_(pos)) || this.squaredDistance(this.controllerPos, pos) > this.searchRange * this.searchRange || positions.contains(pos)) continue;
                    positions.add(pos);
                }
                lastCheckedPos = i++;
            }
        }
        return new HashSet<BlockPos>(positions);
    }

    private int squaredDistance(BlockPos pos1, BlockPos pos2) {
        int dx = pos1.m_123341_() - pos2.m_123341_();
        int dy = pos1.m_123342_() - pos2.m_123342_();
        int dz = pos1.m_123343_() - pos2.m_123343_();
        return dx * dx + dy * dy + dz * dz;
    }

    private void getBoxes(Level level, Set<BlockPos> components) {
        this.boxes.clear();
        int b = 0;
        for (BlockPos blockPos : components) {
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof SimpleStorageBoxEntity) {
                SimpleStorageBoxEntity boxEntity = (SimpleStorageBoxEntity)blockEntity;
                StorageNetworkItem networkItem = new StorageNetworkItem(boxEntity);
                this.boxes.add(b, (Object)networkItem);
                ++b;
                continue;
            }
            if (!(blockEntity instanceof StorageInterfaceEntity)) continue;
            StorageInterfaceEntity interfaceEntity = (StorageInterfaceEntity)blockEntity;
            interfaceEntity.setController(this.controller);
        }
    }

    public void insertItems(ItemStack itemStack) {
        SimpleStorageBoxEntity targetBox;
        ItemStack remaining = itemStack.m_41777_();
        while (!remaining.m_41619_() && (targetBox = this.findBestTargetBox(itemStack)) != null) {
            ItemStack beforeInsertion = remaining.m_41777_();
            remaining = this.insertIntoBox(targetBox, itemStack, 0, false);
            if (remaining.m_41613_() < beforeInsertion.m_41613_()) continue;
            break;
        }
        itemStack.m_41764_(remaining.m_41613_());
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.itemHandler;
    }

    private boolean isNetworkComponent(BlockState blockState) {
        return blockState.m_204336_(ModTags.Blocks.STORAGE_NETWORK_BLOCK);
    }

    public boolean isItemInNetwork(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        for (ItemStack filterStack : this.filterItems) {
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)filterStack)) continue;
            return true;
        }
        return false;
    }

    public boolean canPlaceItem(int slot, ItemStack itemStack) {
        if (slot >= this.boxes.size()) {
            return false;
        }
        return ((StorageNetworkItem)this.boxes.get((int)slot)).simpleStorageBoxEntity.getItemHandler().insertItem(0, itemStack, true).m_41613_() < itemStack.m_41613_();
    }

    public boolean canTakeItem(int slot, ItemStack itemStack) {
        return slot <= this.boxes.size() && !itemStack.m_41619_();
    }

    @Nullable
    private SimpleStorageBoxEntity findBestTargetBox(ItemStack itemStack) {
        SimpleStorageBoxEntity emptyBox = null;
        Predicate<SimpleStorageBoxEntity> canAccept = box -> {
            int available = box.getMaxItemCapacity() - box.getStoredAmount();
            return available > 0 || box.hasVoidUpgrade();
        };
        for (StorageNetworkItem networkItem : this.boxes) {
            SimpleStorageBoxEntity box2 = networkItem.simpleStorageBoxEntity;
            if (ItemStack.m_150942_((ItemStack)box2.getFilterItem(), (ItemStack)itemStack) && canAccept.test(box2)) {
                return box2;
            }
            if (!box2.getFilterItem().m_41619_() || !canAccept.test(box2) || emptyBox != null) continue;
            emptyBox = box2;
        }
        return (Boolean)ConfigManager.CommonConfig.SIMPLE_STORAGE_NETWORK_FILL_EMPTY.get() != false ? emptyBox : null;
    }

    private ItemStack insertIntoBox(SimpleStorageBoxEntity targetBox, ItemStack itemStack, int boxSlot, boolean simulate) {
        int space;
        int toInsert;
        ItemStack remaining = itemStack.m_41777_();
        ItemStack current = targetBox.getItemHandler().getStackInSlot(boxSlot);
        int available = targetBox.maxItemCapacity - targetBox.getStoredAmount();
        if (available <= 0 && targetBox.hasVoidUpgrade()) {
            return ItemStack.f_41583_;
        }
        if (available <= 0 && !targetBox.hasVoidUpgrade()) {
            return itemStack;
        }
        if (current.m_41619_()) {
            int toInsert2 = Math.min(available, remaining.m_41613_());
            if (toInsert2 > 0 && !simulate) {
                ItemStack copy = remaining.m_41777_();
                copy.m_41764_(toInsert2);
                targetBox.getItemHandler().setStackInSlot(boxSlot, copy);
                targetBox.setFilter(copy);
                targetBox.m_6596_();
            }
            remaining.m_41774_(toInsert2);
        } else if (ItemStack.m_150942_((ItemStack)current, (ItemStack)remaining) && (toInsert = Math.min(space = Math.min(available, targetBox.maxItemCapacity - current.m_41613_()), remaining.m_41613_())) > 0) {
            if (!simulate) {
                current.m_41769_(toInsert);
                targetBox.m_6596_();
            }
            remaining.m_41774_(toInsert);
        }
        return remaining.m_41619_() ? ItemStack.f_41583_ : remaining;
    }

    private class NetworkItemHandler
    implements IItemHandlerModifiable {
        private NetworkItemHandler() {
        }

        public int getSlots() {
            return StorageNetwork.this.boxes.size();
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot > StorageNetwork.this.boxes.size()) {
                return ItemStack.f_41583_;
            }
            return ((StorageNetworkItem)StorageNetwork.this.boxes.get((int)slot)).simpleStorageBoxEntity.getItemHandler().getStackInSlot(0);
        }

        public ItemStack insertItem(int slot, ItemStack itemStack, boolean simulate) {
            if (itemStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (!StorageNetwork.this.canPlaceItem(slot, itemStack)) {
                return itemStack;
            }
            int boxSlot = 0;
            SimpleStorageBoxEntity targetBox = StorageNetwork.this.findBestTargetBox(itemStack);
            if (targetBox == null) {
                return itemStack;
            }
            return StorageNetwork.this.insertIntoBox(targetBox, itemStack, boxSlot, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            int boxSlot = 0;
            if (slot >= StorageNetwork.this.boxes.size()) {
                return ItemStack.f_41583_;
            }
            SimpleStorageBoxEntity box = ((StorageNetworkItem)StorageNetwork.this.boxes.get((int)slot)).simpleStorageBoxEntity;
            ItemStack current = box.getItemHandler().getStackInSlot(boxSlot);
            if (current.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (!StorageNetwork.this.canTakeItem(slot, current)) {
                return ItemStack.f_41583_;
            }
            int toExtract = Math.min(current.m_41613_(), amount);
            if (simulate) {
                if (toExtract == 0) {
                    return ItemStack.f_41583_;
                }
                ItemStack copy = current.m_41777_();
                copy.m_41764_(toExtract);
                return copy;
            }
            return box.getItemHandler().extractItem(boxSlot, toExtract, false);
        }

        public int getSlotLimit(int slot) {
            if (slot <= StorageNetwork.this.boxes.size()) {
                return ((StorageNetworkItem)StorageNetwork.this.boxes.get((int)slot)).simpleStorageBoxEntity.maxItemCapacity;
            }
            return 0;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return StorageNetwork.this.canPlaceItem(slot, stack);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            if (slot >= StorageNetwork.this.boxes.size()) {
                return;
            }
            ((StorageNetworkItem)StorageNetwork.this.boxes.get((int)slot)).simpleStorageBoxEntity.getItemHandler().setStackInSlot(0, stack);
        }
    }

    public static class StorageNetworkItem {
        public final SimpleStorageBoxEntity simpleStorageBoxEntity;
        public final BlockPos blockPos;

        public StorageNetworkItem(SimpleStorageBoxEntity entity) {
            this.simpleStorageBoxEntity = entity;
            this.blockPos = entity.m_58899_();
        }
    }
}

