/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fxnt.fxntstorage.backpack.BackpackEntity;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.fxnt.fxntstorage.cache.BackpackShapeCache;
import net.fxnt.fxntstorage.init.ModBlockEntities;
import net.fxnt.fxntstorage.init.ModDataComponents;
import net.fxnt.fxntstorage.util.SortOrder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class BackpackBlock
extends BaseEntityBlock {
    public static final MapCodec<BackpackBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockBehaviour.propertiesCodec(), (App)Codec.INT.fieldOf("max_stack_size").forGetter(BackpackBlock::getStackMultiplier)).apply((Applicative)instance, BackpackBlock::new));
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public final int stackMultiplier;
    public static final int ITEM_SLOT_COUNT = 108;
    public static final int TOOL_SLOT_COUNT = 24;
    public static final int UPGRADE_SLOT_COUNT = 6;
    public static final int TOTAL_SLOT_COUNT = 138;

    public BackpackBlock(BlockBehaviour.Properties pProperties, int stackMultiplier) {
        super(pProperties.strength(0.2f, 600.0f));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
        this.stackMultiplier = stackMultiplier;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        BlockEntityType type = (BlockEntityType)ModBlockEntities.BACKPACK_ENTITY.get();
        BackpackEntity blockEntity = new BackpackEntity(type, pPos, pState);
        blockEntity.setData(138, this.stackMultiplier);
        return blockEntity;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : BackpackBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.BACKPACK_ENTITY.get()), (type, wor, pos, entity) -> entity.serverTick(type));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BackpackEntity) {
            BackpackEntity be = (BackpackEntity)blockEntity;
            be.readInventory((ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY));
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                be.setCustomName(stack.getHoverName());
            }
            SortOrder order = Optional.ofNullable((SortOrder)((Object)stack.get(ModDataComponents.INVENTORY_SORT_ORDER))).orElse(SortOrder.COUNT);
            be.setSortOrder(order);
        }
    }

    public static int getSlotCount() {
        return 138;
    }

    public static int getItemSlotCount() {
        return 108;
    }

    public static int getToolSlotCount() {
        return 24;
    }

    public static int getUpgradeSlotCount() {
        return 6;
    }

    public int getStackMultiplier() {
        return this.stackMultiplier;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (player.isCrouching() && !BackpackHelper.isWearingBackpack(player)) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof BackpackEntity)) {
                return InteractionResult.FAIL;
            }
            BackpackEntity backpackEntity = (BackpackEntity)blockEntity;
            ItemStack itemStack = new ItemStack((ItemLike)BackpackItem.byBlock((Block)this));
            itemStack = this.saveEntityToStack(backpackEntity, itemStack);
            level.removeBlock(pos, false);
            boolean equipped = BackpackHelper.equipBackpack(player, itemStack);
            return equipped ? InteractionResult.CONSUME : InteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BackpackEntity) {
            BackpackEntity backPackEntity = (BackpackEntity)blockEntity;
            player.openMenu((MenuProvider)backPackEntity, pos);
        }
        return InteractionResult.CONSUME;
    }

    private ItemStack saveEntityToStack(BackpackEntity blockEntity, ItemStack itemStack) {
        itemStack = blockEntity.saveToItemStack(itemStack);
        return itemStack;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BackpackShapeCache.getShape((Direction)state.getValue((Property)FACING));
    }

    @NotNull
    public VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return BackpackShapeCache.getShape((Direction)state.getValue((Property)FACING));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BackpackShapeCache.getShape((Direction)state.getValue((Property)FACING));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING});
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BackpackEntity) {
            BackpackEntity backpackEntity = (BackpackEntity)blockEntity;
            return backpackEntity.calcRedstoneFromInventory();
        }
        return 0;
    }
}

