/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack;

import com.simibubi.create.foundation.item.TooltipHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.lang.FontHelper;
import net.fxnt.fxntstorage.FXNTStorage;
import net.fxnt.fxntstorage.backpack.BackpackBlock;
import net.fxnt.fxntstorage.backpack.tooltip.BackpackTooltip;
import net.fxnt.fxntstorage.backpack.util.BackpackHandler;
import net.fxnt.fxntstorage.backpack.util.BackpackHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class BackpackItem
extends BlockItem {
    private final Block block;

    public BackpackItem(Block block, Item.Properties properties) {
        super(block, properties.stacksTo(1).fireResistant());
        this.block = block;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, LivingEntity entity) {
        if (armorType != EquipmentSlot.CHEST) {
            return false;
        }
        if (stack.getItem() instanceof BackpackItem && entity.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof BackpackItem) {
            return true;
        }
        if (FXNTStorage.curiosLoaded) {
            return !BackpackHelper.isWearingBackpack((Player)entity);
        }
        return super.canEquip(stack, armorType, entity);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BackpackHandler.openBackpackFromInventory(serverPlayer, (byte)2);
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(usedHand));
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    @NotNull
    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pIsAdvanced);
        MutableComponent CTRL_TO_VIEW_CONTENTS = Component.translatable((String)"tooltip.fxntstorage.holdForContents", (Object[])new Object[]{Screen.hasControlDown() ? "\u00a7fCtrl" : "\u00a77Ctrl"}).withStyle(ChatFormatting.DARK_GRAY);
        MutableComponent SHIFT_TO_VIEW_SUMMARY = Component.translatable((String)"tooltip.fxntstorage.holdForDescription", (Object[])new Object[]{Screen.hasShiftDown() ? "\u00a7fShift" : "\u00a77Shift"}).withStyle(ChatFormatting.DARK_GRAY);
        String translationKey = "tooltip.fxntstorage.backpack";
        int placeholder = ((BackpackBlock)this.block).stackMultiplier;
        ArrayList<MutableComponent> summaryLines = new ArrayList<MutableComponent>();
        summaryLines.add(Component.empty());
        summaryLines.addAll(TooltipHelper.cutTextComponent((Component)Component.translatable((String)(translationKey + ".summary")), (FontHelper.Palette)FontHelper.Palette.STANDARD_CREATE));
        summaryLines.add(Component.empty());
        for (int i = 1; i < 10 && I18n.exists((String)(translationKey + ".condition" + i)); ++i) {
            summaryLines.addAll(TooltipHelper.cutTextComponent((Component)Component.translatable((String)(translationKey + ".condition" + i)), (FontHelper.Palette)FontHelper.Palette.ALL_GRAY));
            summaryLines.addAll(TooltipHelper.cutTextComponent((Component)Component.translatable((String)(translationKey + ".behaviour" + i), (Object[])new Object[]{placeholder}), (Style)FontHelper.Palette.STANDARD_CREATE.primary(), (Style)FontHelper.Palette.STANDARD_CREATE.highlight(), (int)1));
        }
        if (Screen.hasShiftDown() == Screen.hasControlDown()) {
            pTooltipComponents.add((Component)SHIFT_TO_VIEW_SUMMARY);
            pTooltipComponents.add((Component)CTRL_TO_VIEW_CONTENTS);
        }
        if (Screen.hasShiftDown() && !Screen.hasControlDown()) {
            pTooltipComponents.add((Component)SHIFT_TO_VIEW_SUMMARY);
            pTooltipComponents.addAll(summaryLines);
        }
        if (!Screen.hasShiftDown() && Screen.hasControlDown()) {
            pTooltipComponents.add((Component)CTRL_TO_VIEW_CONTENTS);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public Optional<TooltipComponent> getTooltipImage(ItemStack pStack) {
        if (Screen.hasControlDown() && !Screen.hasShiftDown()) {
            return Optional.of(new BackpackTooltip(pStack));
        }
        return Optional.empty();
    }
}

