/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.main;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.fxnt.fxntstorage.backpack.BackpackBlock;
import net.fxnt.fxntstorage.backpack.BackpackItem;
import net.fxnt.fxntstorage.backpack.main.IBackpackContainer;
import net.fxnt.fxntstorage.init.ModDataComponents;
import net.fxnt.fxntstorage.item.upgrades.UpgradeItem;
import net.fxnt.fxntstorage.network.packet.SetSortOrderPacket;
import net.fxnt.fxntstorage.util.SortOrder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackpackContainer
implements IBackpackContainer,
IItemHandlerModifiable {
    private final int CONTAINER_SIZE = BackpackBlock.getSlotCount();
    private final Player player;
    private int stackMultiplier;
    private final ItemStack stack;
    private final ItemStackHandler itemHandler = new ItemStackHandler(this.CONTAINER_SIZE);
    private final NonNullList<String> upgrades = NonNullList.create();
    private SortOrder sortOrder = SortOrder.COUNT;

    public BackpackContainer(ItemStack itemStack, @Nullable Player player) {
        BackpackItem backpackItem;
        this.player = player;
        this.stack = itemStack;
        Item item = itemStack.getItem();
        if (item instanceof BackpackItem && (item = (backpackItem = (BackpackItem)item).getBlock()) instanceof BackpackBlock) {
            BackpackBlock backpackBlock = (BackpackBlock)item;
            this.stackMultiplier = backpackBlock.getStackMultiplier();
        }
        this.loadItemsFromStack(itemStack);
    }

    @Override
    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public void readInventory(ItemContainerContents contents) {
        List itemStacks = contents.stream().toList();
        for (int i = 0; i < itemStacks.size(); ++i) {
            this.itemHandler.setStackInSlot(i, (ItemStack)itemStacks.get(i));
        }
    }

    public void loadItemsFromStack(ItemStack itemStack) {
        if (itemStack.getComponents().has(DataComponents.CONTAINER)) {
            this.readInventory((ItemContainerContents)itemStack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY));
        }
        if (itemStack.getComponents().has(ModDataComponents.BACKPACK_UPGRADES)) {
            this.upgrades.clear();
            List upgradeList = (List)itemStack.getComponents().get(ModDataComponents.BACKPACK_UPGRADES);
            if (upgradeList != null) {
                this.upgrades.clear();
                this.upgrades.addAll((Collection)upgradeList);
            }
        }
        this.stackMultiplier = Optional.ofNullable((Integer)itemStack.getComponents().get(ModDataComponents.BACKPACK_STACK_MULTIPLIER)).orElse(((BackpackBlock)((BackpackItem)itemStack.getItem()).getBlock()).getStackMultiplier());
        this.sortOrder = Optional.ofNullable((SortOrder)((Object)itemStack.getComponents().get(ModDataComponents.INVENTORY_SORT_ORDER))).orElse(SortOrder.COUNT);
    }

    public void saveItemsToStack() {
        this.stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getItems()));
        this.stack.set(ModDataComponents.BACKPACK_UPGRADES, this.upgrades);
        this.stack.set(ModDataComponents.BACKPACK_STACK_MULTIPLIER, (Object)this.stackMultiplier);
        this.stack.set(ModDataComponents.INVENTORY_SORT_ORDER, (Object)this.sortOrder);
    }

    public List<ItemStack> getItems() {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            itemList.add(this.itemHandler.getStackInSlot(i));
        }
        return itemList;
    }

    public NonNullList<String> getUpgrades() {
        return this.upgrades;
    }

    @Override
    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        if (this.player.level().isClientSide) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SetSortOrderPacket(sortOrder), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.setDataChanged();
    }

    public int getSlots() {
        return this.itemHandler.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int i) {
        return this.itemHandler.getStackInSlot(i);
    }

    public void setStackInSlot(int i, @NotNull ItemStack itemStack) {
        this.itemHandler.setStackInSlot(i, itemStack);
    }

    @NotNull
    public ItemStack insertItem(int i, @NotNull ItemStack itemStack, boolean b) {
        return this.itemHandler.insertItem(i, itemStack, b);
    }

    @NotNull
    public ItemStack extractItem(int i, int i1, boolean b) {
        return this.itemHandler.extractItem(i, i1, b);
    }

    public int getSlotLimit(int i) {
        return this.itemHandler.getSlotLimit(i);
    }

    public boolean isItemValid(int i, @NotNull ItemStack itemStack) {
        return true;
    }

    @Override
    public int getStackMultiplier() {
        return this.stackMultiplier;
    }

    @Override
    public void setPlayerInteraction(boolean isPlayer) {
    }

    @Override
    public void setDataChanged() {
        if (this.player == null || this.player.level().isClientSide) {
            return;
        }
        this.setChanged();
    }

    public void refreshUpgrades() {
        this.upgrades.clear();
        int UPGRADE_SLOT_START_INDEX = 132;
        int UPGRADE_SLOT_END_INDEX = UPGRADE_SLOT_START_INDEX + 6;
        for (int i = UPGRADE_SLOT_START_INDEX; i < UPGRADE_SLOT_END_INDEX; ++i) {
            UpgradeItem upgradeItem;
            String upgradeName;
            ItemStack itemStack = this.itemHandler.getStackInSlot(i);
            Item item = itemStack.getItem();
            if (!(item instanceof UpgradeItem) || this.upgrades.contains((Object)(upgradeName = (upgradeItem = (UpgradeItem)item).getUpgradeName()))) continue;
            this.upgrades.add((Object)upgradeName);
        }
    }

    public void setChanged() {
        if (this.player == null || this.player.level().isClientSide) {
            return;
        }
        IItemHandler cap = (IItemHandler)this.stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (cap != null) {
            SortOrder newSort;
            NonNullList oldInventory = NonNullList.withSize((int)this.CONTAINER_SIZE, (Object)ItemStack.EMPTY);
            NonNullList newInventory = NonNullList.withSize((int)this.CONTAINER_SIZE, (Object)ItemStack.EMPTY);
            SortOrder oldSort = (SortOrder)((Object)this.stack.get(ModDataComponents.INVENTORY_SORT_ORDER));
            this.sortOrder = newSort = this.sortOrder != null ? this.sortOrder : SortOrder.COUNT;
            for (int i = 0; i < cap.getSlots(); ++i) {
                oldInventory.set(i, (Object)cap.getStackInSlot(i));
            }
            for (int j = 0; j < this.itemHandler.getSlots(); ++j) {
                newInventory.set(j, (Object)this.itemHandler.getStackInSlot(j));
            }
            if (!newInventory.equals((Object)oldInventory) || !newSort.equals((Object)oldSort)) {
                this.refreshUpgrades();
                this.saveItemsToStack();
            }
        }
    }
}

