/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpack.main;

import com.simibubi.create.api.packager.unpacking.UnpackingHandler;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import java.util.List;
import net.fxnt.fxntstorage.backpack.BackpackEntity;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public enum BackpackUnpacking implements UnpackingHandler
{
    INSTANCE;


    public boolean unpack(Level level, BlockPos blockPos, BlockState blockState, Direction direction, List<ItemStack> items, @Nullable PackageOrderWithCrafts packageOrderWithCrafts, boolean simulate) {
        BlockEntity targetBE = level.getBlockEntity(blockPos);
        if (targetBE == null) {
            return false;
        }
        BackpackEntity backpackEntity = (BackpackEntity)targetBE;
        ItemStackHandler targetInv = backpackEntity.getItemHandler();
        if (targetInv == null) {
            return false;
        }
        if (!simulate) {
            for (ItemStack itemStack : items) {
                targetInv.insertItem(targetInv.getSlots() - 1, itemStack, false);
                backpackEntity.moveItems();
            }
            return true;
        }
        int slotLimit = Util.ITEM_SLOT_END_RANGE;
        int stackMultiplier = backpackEntity.stackMultiplier;
        ItemStack[] virtualStacks = new ItemStack[slotLimit];
        int[] remaining = new int[slotLimit];
        for (int i = 0; i < slotLimit; ++i) {
            ItemStack slotStack = targetInv.getStackInSlot(i);
            virtualStacks[i] = slotStack.copy();
            remaining[i] = slotStack.isEmpty() ? -1 : stackMultiplier * slotStack.getMaxStackSize() - slotStack.getCount();
        }
        block2: for (ItemStack insertStack : items) {
            int insertable;
            ItemStack vs;
            int i;
            int toInsert = insertStack.getCount();
            for (i = 0; i < slotLimit; ++i) {
                vs = virtualStacks[i];
                if (vs.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)vs, (ItemStack)insertStack) || (insertable = Math.min(remaining[i], toInsert)) <= 0) continue;
                int n = i;
                remaining[n] = remaining[n] - insertable;
                vs.grow(insertable);
                if ((toInsert -= insertable) <= 0) continue block2;
            }
            for (i = 0; i < slotLimit; ++i) {
                vs = virtualStacks[i];
                if (!vs.isEmpty()) continue;
                virtualStacks[i] = insertStack.copy();
                virtualStacks[i].setCount(0);
                remaining[i] = stackMultiplier * insertStack.getMaxStackSize();
                insertable = Math.min(remaining[i], toInsert);
                if (insertable <= 0) continue;
                int n = i;
                remaining[n] = remaining[n] - insertable;
                virtualStacks[i].grow(insertable);
                if ((toInsert -= insertable) <= 0) continue block2;
            }
            return false;
        }
        return true;
    }
}

